﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class Person_Register3 : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            txtUserName.Value = Request["txtUserName"].ToString();
            txtUserPwd.Value = Request["txtUserPwd"].ToString();
            txtQuestion.Value = Request["txtQuestion"].ToString();
            txtAnswer.Value = Request["txtAnswer"].ToString();
            txtMail.Text = txtEmail.Value = Request["txtEmail"].ToString();
            txtUserType.Value = Request["txtUserType"].ToString();

            IniBirth();
        }

    }
    protected void btnRegister_Click(object sender, EventArgs e)
    {
        String sql = String.Empty;
        ArrayList paramList = new ArrayList();

        String perId = generateId();

        SqlConnection conn = null;
        SqlTransaction trans = null;
        bool transBegin = false;
        try
        {
            conn = DB.GetConnection();

            SqlCommand cmd = new SqlCommand();
            cmd.Connection = conn;
            cmd.CommandType = CommandType.Text;
            trans = conn.BeginTransaction();
            cmd.Transaction = trans;
            transBegin = true;

            sql = "SELECT * FROM personal_base where perid = @0 OR username = @1";
            SqlParameter[] parameters = new SqlParameter[2];
            parameters[0] = new SqlParameter();
            parameters[0].ParameterName = "@0";
            parameters[0].Value = perId;

            parameters[1] = new SqlParameter();
            parameters[1].ParameterName = "@1";
            parameters[1].Value = txtUserName.Value;

            if (DB.GetDataSet(conn, sql, trans, parameters).Tables[0].Rows.Count > 0)
            {
                if (transBegin) trans.Rollback();
                transBegin = false;
                this.Response.Write("<script>alert('已存在相同的用户名称，请更换用户名');window.history.back(-1)</script>");
                return;
            }
            else
            {


                sql = "INSERT INTO personal_base(perid,mobilephone,username,password,email,usertype,reg_date," +
                  "lastlogin_date,lastlogin_ip,lastupdate_date,login_count,question,answer) " +
                  "VALUES(@0,@1,@2,@3,@4,@5,GETDATE(),GETDATE(),@6,GETDATE(),1,@7,@8)";
                cmd.CommandText = sql;

                paramList.Add(perId);
                paramList.Add(txtMobile.Text);
                paramList.Add(txtUserName.Value);
                paramList.Add(Common.Md5(txtUserPwd.Value));
                paramList.Add(txtMail.Text);
                paramList.Add(Convert.ToInt32(txtUserType.Value));
                paramList.Add(Request.ServerVariables.Get("REMOTE_ADDR").ToString());
                paramList.Add(txtQuestion.Value);
                paramList.Add(txtAnswer.Value);

                parameters = new SqlParameter[paramList.Count];

                for (int i = 0; i < paramList.Count; ++i)
                {
                    parameters[i] = new SqlParameter();
                    parameters[i].ParameterName = "@" + i.ToString();
                    parameters[i].Value = paramList[i];
                }
                DB.ExecuteSQL(cmd, parameters);


                sql = "INSERT INTO personal_info(perid,realname,sex,nation,education,marrage," +
                      "idcardtype,idcardno,stature,weight,birth_year,birth_month,birth_day," +
                      "hukou_province,hukou_city,current_province,current_city,self_evaluation," +
                      "phone,im,webhome,zipcode,address,Photo_URL_IsShow) " +
                      "VALUES(@0,@1,@2,@3,@4,@5,@6,@7,@8,@9,@10,@11,@12,@13,@14,@15,@16,@17,@18,@19,@20,@21,@22,1)";

                cmd.CommandText = sql;

                paramList.Clear();
                paramList.Add(perId);
                paramList.Add(txtRealName.Text);
                paramList.Add(getGender());
                paramList.Add(cmbNation.SelectedItem.Text);
                paramList.Add(cmbEducate.SelectedItem.Text);
                paramList.Add(Convert.ToInt32(cmbMarriage.SelectedItem.Value));
                paramList.Add(Convert.ToInt32(cmbCertificatType.SelectedItem.Value));
                paramList.Add(txtCertificateNo.Text);
                String stature = txtStature.Text.Trim() == "" ? "0" : txtStature.Text;
                paramList.Add(Convert.ToInt32(stature));
                String weight = txtWeight.Text.Trim() == "" ? "0" : txtWeight.Text;
                paramList.Add(Convert.ToInt32(weight));
                paramList.Add(Convert.ToInt32(txtBirthYear.Text));
                paramList.Add(Convert.ToInt32(cmbBirthMonth.SelectedItem.Text));
                paramList.Add(Convert.ToInt32(cmbBirthDay.SelectedItem.Text));
                paramList.Add(txtProvince1.Text);
                paramList.Add(txtCity1.Text);
                paramList.Add(txtProvince2.Text);
                paramList.Add(txtCity2.Text);
                paramList.Add(txtIntroduce.Text);
                paramList.Add(txtPhone.Text);
                paramList.Add(txtIm.Text);
                paramList.Add(txtHomePage.Text);
                paramList.Add(txtZipCode.Text);
                paramList.Add(txtAddress.Text);

                parameters = new SqlParameter[paramList.Count];

                for (int i = 0; i < paramList.Count; ++i)
                {
                    parameters[i] = new SqlParameter();
                    parameters[i].ParameterName = "@" + i.ToString();
                    parameters[i].Value = paramList[i];
                }

                DB.ExecuteSQL(cmd, parameters);

                trans.Commit();
                transBegin = false;
                Session["perid"] = perId;
                Response.Redirect("RegisterOk.aspx");
            }

        }
        catch (Exception ex)
        {
            if (transBegin)
                trans.Rollback();
            Response.Write(ex.Message);
            Response.End();
        }
        finally
        {
            if (conn != null && conn.State == ConnectionState.Open)
                conn.Close();
        }
    }

    private int getGender()
    {
        int gender = 0;
        if (rdoMale.Checked)
            gender = 1;
        if (rdoFemale.Checked)
            gender = 0;
        if (rdoNone.Checked)
            gender = 2;

        return gender;
    }

    private string generateId()
    {
        long i = 1;
        foreach (byte b in Guid.NewGuid().ToByteArray())
        {
            i *= ((int)b + 1);
        }
        return string.Format("{0:x}", i - DateTime.Now.Ticks);
    }

    private void IniBirth()
    {
        for (int i = 1; i < 13; ++i)
        {
            cmbBirthMonth.Items.Add(i.ToString());
        }

        for (int i = 1; i < 32; ++i)
        {
            cmbBirthDay.Items.Add(i.ToString());
        }
    }
}
