﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Person_Resume_ResumeMode1 : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Request.QueryString["param"] != null)
            {
                txtPerid.Value = Request.QueryString["param"].ToString();
                loadData(txtPerid.Value);
                checkIsRead();
            }
            if (Session["perid"] != null)
            {
                btnAddDb.Visible = false;
                btnInvite.Visible = false;
            }
        }
    }

    private void checkIsRead()
    {
        if (Request.QueryString["mailid"] != null)
        {
            String sql = "UPDATE company_inbox SET isread=1 WHERE id=@0";
            DB.ExecuteSQL(sql, Request.QueryString["mailid"].ToString());
        }
    }

    private void loadData(String perid)
    {
        try
        {
            object[] parameters = new object[1];
            parameters[0] = perid;
            //0基本信息，求职一向
            String sql = "SELECT a.PerID, a.Email, a.MobilePhone, b.RealName, b.Sex, b.Nation, b.Education, " +
                         "b.Marrage, b.IDCardNo, b.Stature, b.Weight, b.Birth_Year, b.Birth_Month, b.Birth_Day, " +
                         "b.Hukou_Province, b.Hukou_City, b.Current_Province, b.Current_City,  " +
                         "b.Self_Evaluation, b.Photo_URL, b.Photo_URL_IsShow, b.Phone, b.IM, b.WebHome,  " +
                         "b.ZipCode, b.Address " +
                         "FROM personal_base a LEFT OUTER JOIN " +
                         "personal_info b ON a.PerID = b.PerID " +
                         "WHERE a.perid=@0";
            //求职意向
            sql += ";SELECT c.JobType, c.JobClass1, c.JobClass2, c.JobClass3, " +
                         "c.JobClass4, c.JobClass5, c.WorkArea1, c.WorkArea2, c.WorkArea3, c.WorkArea4, " +
                         "c.WorkArea5, c.JobName1, c.JobName2, c.JobName3, c.JobName4, c.JobName5,c.Salary " +
                         "FROM personal_will c WHERE c.perid=@0";
            //1技能
            sql += ";SELECT CASE skillType WHEN 0 THEN '外语技能' WHEN 1 THEN 'IT技能' WHEN 2 THEN '证书' " +
                   " WHEN 3 THEN '其他' END skilltype, skillName, degree " +
                   " FROM personal_skill WHERE perid=@0";
            //2教育
            sql += ";SELECT schoolname,degree," +
                     "CAST(begindate_year AS VARCHAR)+ '.' + RIGHT('00' + CAST(begindate_month AS VARCHAR), 2) " +
                     " + '---' + " +
                     "CAST(enddate_year AS VARCHAR)+ '.' + RIGHT('00' + CAST(enddate_month AS VARCHAR), 2) time " +
                     "FROM personal_education WHERE perid=@0 and type=0";
            //3培训
            sql += ";SELECT schoolname,magorin_class," +
                     "CAST(begindate_year AS VARCHAR)+ '.' + RIGHT('00' + CAST(begindate_month AS VARCHAR), 2) " +
                     " + '---' + " +
                     "CAST(enddate_year AS VARCHAR)+ '.' + RIGHT('00' + CAST(enddate_month AS VARCHAR), 2) time " +
                     "FROM personal_education WHERE perid=@0 and type=1";
            //4工作经历
            sql += ";SELECT companyname,jobname,type,industry,jobname,memo,demission," +
                     "CAST(begindate_year AS VARCHAR)+ '.' + RIGHT('00' + CAST(begindate_month AS VARCHAR), 2) " +
                     " + '---' + " +
                     "CAST(enddate_year AS VARCHAR)+ '.' + RIGHT('00' + CAST(enddate_month AS VARCHAR), 2) time " +
                     "FROM personal_workexperience WHERE perid=@0";

            DataSet resume = DB.GetDataSet(sql, parameters);

            if (resume.Tables[0].Rows.Count > 0)
            {
                setFormData(resume.Tables[0].Rows[0]);
            }

            if (resume.Tables[1].Rows.Count > 0)
                setJobWill(resume.Tables[1].Rows[0]);

            lstSkill.DataSource = resume.Tables[2].DefaultView;
            lstSkill.DataBind();

            lstEducation.DataSource = resume.Tables[3].DefaultView;
            lstEducation.DataBind();

            lstTrain.DataSource = resume.Tables[4].DefaultView;
            lstTrain.DataBind();

            lstExperience.DataSource = resume.Tables[5].DefaultView;
            lstExperience.DataBind();
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    private void setFormData(DataRow row)
    {
        txtRealName.Value=lblRealName.Text = lblRealName2.Text = row["realname"].ToString();
        lblSex.Text = Common.sex[Convert.ToInt16(row["sex"])];
        lblNation.Text = row["nation"].ToString();
        lblBitrh.Text = Common.ToYMD(row["Birth_Year"].ToString() + "-" + row["Birth_Month"].ToString() + "-" + row["Birth_Day"].ToString());
        lblIdNumber.Text = row["IDCardNo"].ToString();
        lblMarriage.Text = row["Marrage"].ToString();
        lblStature.Text = row["stature"].ToString();
        lblWeight.Text = row["weight"].ToString();
        lblHukou.Text = row["Hukou_City"].ToString();
        lblCurrent.Text = row["current_city"].ToString();
        lblDegree.Text = row["Education"].ToString();
        lblPhone.Text = row["phone"].ToString();
        lblMobile.Text = row["mobilephone"].ToString();
        lblEmail.Text = row["email"].ToString();
        lblIm.Text = row["im"].ToString();
        lblHomepage.Text = row["webhome"].ToString();
        lblZipcode.Text = row["zipcode"].ToString();
        lblAddress.Text = row["address"].ToString();
        lblSelfEvaluation.Text = replace(row["Self_Evaluation"].ToString());
        if (Convert.ToString(row["Photo_URL_IsShow"]).Trim() != "" && Convert.ToString(row["Photo_URL_IsShow"]).Trim() == "1")
            //imgPerson.ImageUrl = "~/Person/" + Convert.ToString(row["Photo_URL"]).Trim();
            imgPerson.ImageUrl = getPicUrl(Convert.ToString(row["Photo_URL"]).Trim(), Convert.ToString(row["PerId"]).Trim());
    }

    protected string getPicUrl(string url, string id)
    {
        string path = Server.MapPath("~/temp/image/");
        return Common.downloadFile(url, path, id, "~/temp/image/");
    }

    private void setJobWill(DataRow row)
    {
        lblJobType.Text = Common.jobType[Convert.ToInt16(row["jobtype"])];
        lblJobClass.Text = getFieldValue(row, "JobClass", true);
        lblJobName.Text = getFieldValue(row, "jobname", false);
        lblWorkArea.Text = getFieldValue(row, "workarea", false);
        lblSalary.Text = row["salary"].ToString();
    }


    private String getFieldValue(DataRow row,String field,bool isReturn)
    {
        String ret = "";
        for (int i = 1; i < 6; ++i)
        { 
            String value = Convert.ToString(row[field+i.ToString()]);
            if (value.IndexOf('|') > 0)
            {
                value = value.Split('|')[1];
                value = value.Replace("-", "");
            }
            ret += value;
            if (i<5 && value.Trim() !="")
            {
                ret += isReturn ?"</br>":" ; ";
            }
        }

        return ret;
    }

    public String replace(String field)
    {
        String ret = "";
        ret = field.Replace("\r\n", "</br>");
        return ret;
    }


    protected void btnAddDb_Click(object sender, EventArgs e)
    {
        String comid = Convert.ToString(Session["comid"]);
        if (comid.Trim() == "")
        {
            Response.Redirect("index.aspx");
            return;
        }
        String sql = "SELECT comid FROM company_db WHERE comid=@0 AND perid=@1 ";
        ArrayList paramList = new ArrayList();
        paramList.Add( comid);
        paramList.Add( txtPerid.Value);

        if (DB.GetDataSet(sql,paramList).Tables[0].Rows.Count <= 0)
        {
            sql = "INSERT INTO company_db(comid,perid,adddate,classid) " +
                  "VALUES( @0,@1,GETDATE(),0)";
            DB.ExecuteSQL(sql, paramList);
        }
        Common.Alert("已经加入人才库", this);
    }
}
