﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class Person_SearchList : System.Web.UI.Page
{
    const Int32 rows = 20;
    protected void Page_Load(object sender, EventArgs e)
    {

        if (!IsPostBack)
        {
            if (Session["search"] != null)
            {
                saveCondition(Session["search"]);
                getRecordCount();
                txtPageIndex.Value = "1";
                loadData(Convert.ToInt32(txtPageIndex.Value));
            }
        }
    }

    private void loadData(int pageNo)
    {
        try
        {
            if (pageNo == 0)
                pageNo = 1;
            ArrayList parameters = new ArrayList();

            String sql = String.Format("SELECT TOP {0} b.comid,b.jobid,b.jobName,a.companyname,b.work_city," +
                         "CASE b.salary WHEN 0 THEN '面议' ELSE CONVERT(VARCHAR(10),CONVERT(DECIMAL(10,2),b.Salary)) END salary," +
                         "CONVERT(VARCHAR(10),b.lastUpdate_Date,120) adddate ", rows);
            String whereSql = String.Format("FROM jobs b LEFT JOIN company_base a ON a.comid = b.comid {0} ", getWhere(ref parameters));
            String ordSql = "ORDER BY b.lastUpdate_Date DESC,b.comid";

            String inSql = String.Format(" AND b.jobid NOT IN (SELECT TOP {0} b.jobid {1} {2})", (pageNo - 1) * rows, whereSql, ordSql);
            sql = sql + whereSql + inSql + ordSql;

            sql = "SELECT     TOP (20) b.ComID, b.JobId, b.JobName, a.CompanyName, b.Work_City, CASE b.salary WHEN 0 THEN '面议' ELSE CONVERT(VARCHAR(10), CONVERT(DECIMAL(10, 2), b.Salary)) END AS salary, CONVERT(VARCHAR(10), b.LastUpdate_Date, 120) AS adddate FROM         jobs AS b LEFT OUTER JOIN company_base AS a ON a.ComID = b.ComID WHERE     (b.IsActive = 1) AND (a.IsVerified = 1) AND (GETDATE() < b.EndDate or b.EndDate is null or b.EndDate='') AND (b.JobType = 0) ORDER BY b.LastUpdate_Date DESC, b.ComID";
            DataTable jobs = DB.GetDataSet(sql, parameters).Tables[0];
            grdJobList.DataSource = jobs;
            grdJobList.DataBind();
            lblCurrent1.Text = lblCurrent.Text = pageNo.ToString();
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    private void getRecordCount()
    {
        ArrayList parameters = new ArrayList();
        String sql = String.Format("SELECT COUNT(b.jobid) cnt  " +
                     "FROM jobs b LEFT JOIN company_base a ON a.comid = b.comid {0} ", getWhere(ref parameters));
        DataTable inbox = DB.GetDataSet(sql, parameters).Tables[0];
        Int32 recCnt = Convert.ToInt32(inbox.Rows[0]["cnt"].ToString());
        txtPagesCnt.Value = Common.getPageCnt(recCnt, rows).ToString();
        lblRecCount.Text = recCnt.ToString();
        if (txtPagesCnt.Value == "0")
        {
            lblCurrent1.Text = lblCurrent.Text = "无记录";
        }
        else
        {
            lblCurrent1.Text = lblCurrent.Text = String.Format("第{0}页", txtPageIndex.Value);
        }
        lblPageCount.Text = txtPagesCnt.Value;
    }

    private void saveCondition(object condition)
    {
        Condition sc = (Condition)condition;
        txtJobClass.Value = sc.JobClass;
        txtJobClassValue.Value = sc.JobClassValue;
        txtJobType.Value = sc.WorkType.ToString();
        txtDegree.Value = sc.Degree;
        txtWorkYears.Value = sc.WorkYears.ToString();
        txtSalary.Value = sc.Salary.ToString();
        txtCompanyType.Value = sc.CompanyType;
        txtPublishDate.Value = sc.PublishDate.ToString();
        txtKeyword.Value = sc.Keyword;

    }

    private String getWhere(ref ArrayList parameters)
    {
        int index = 0;
        String where = "WHERE b.isactive=1 AND a.IsVerified=1 AND (GETDATE()<b.enddate or b.enddate is null or b.enddate = '') ";
        //职位类别
        if (txtJobClassValue.Value != "0-0" && txtJobClassValue.Value.Trim() != "")
        {
            if (txtJobClass.Value.IndexOf("-不限") >= 0)
            {
                where += String.Format("AND b.jobclass LIKE @{0}", index);
                parameters.Add( "%"+txtJobClassValue.Value+"%");
                index++;
            }
            else
            {
                where += String.Format("AND b.jobclass =@{0} ", index);
                parameters.Add(txtJobClassValue.Value);
                index++;
            }
        }
        //学历要求
        if (txtDegree.Value.Trim() != "无" && txtDegree.Value.Trim() != "")
        {
            where += String.Format("AND b.education =@{0} ", index);
            parameters.Add(txtDegree.Value);
            index++;
        }
        //工作年限
        if (txtWorkYears.Value.Trim() != "0" && txtWorkYears.Value.Trim() != "")
        {
            where += String.Format("AND b.work_years >=@{0} ", index);
            parameters.Add( txtWorkYears.Value);
            index++;
        }
        //工作类型
        if (txtJobType.Value.Trim() != "")
        {
            where += String.Format("AND b.jobtype =@{0} ", index);
            parameters.Add(txtJobType.Value);
            index++;
        }
        //薪水
        if (txtSalary.Value.Trim() != "")
        {
            where += String.Format("AND b.salary >=@{0} ", index);
            parameters.Add(txtSalary.Value);
            index++;
        }
        //公司性质
        if (txtCompanyType.Value.Trim() != "0" && txtCompanyType.Value.Trim() != "")
        {
            where += String.Format("AND a.type =@{0} ", index);
            parameters.Add(txtCompanyType.Value);
            index++;
        }
        //发布日期
        if (txtPublishDate.Value.Trim() != "0" && txtPublishDate.Value.Trim() != ""){
            where += String.Format("AND DATEDIFF(dd, b.lastUpdate_date, GETDATE()) <= @{0} ", index);
            parameters.Add(txtPublishDate.Value);
            index++;
        }
        //关键字
        if (txtKeyword.Value.Trim() != "")
        {
            where += string.Format( "AND (b.jobName LIKE @{0} OR a.companyname LIKE @{0}) ",index);
            parameters.Add("%" + txtKeyword.Value + "%");
            index++;
        }
        return where;
    }


    protected void btnFirst_Click(object sender, EventArgs e)
    {
        txtPageIndex.Value = "1";
        loadData(Convert.ToInt32(txtPageIndex.Value));

    }

    protected void btnPer_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtPageIndex.Value);
        if (index - 1 < 1)
            txtPageIndex.Value = "1";
        else
            txtPageIndex.Value = Convert.ToString(--index);
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnNext_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtPageIndex.Value);
        if (index + 1 > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;
        else
            txtPageIndex.Value = Convert.ToString(++index);
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnLast_Click(object sender, EventArgs e)
    {
        txtPageIndex.Value = txtPagesCnt.Value;
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnGoto_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtGo.Text);
        txtPageIndex.Value = txtGo.Text;
        if (index < 1)
            txtPageIndex.Value = "1";
        if (index > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;

        txtGo.Text = txtPageIndex.Value;
        loadData(Convert.ToInt32(txtPageIndex.Value));

    }
    protected void grdJobList_RowEditing(object sender, GridViewEditEventArgs e)
    {
        try
        {
            int rowIndex = e.NewEditIndex;
            String jobId = ((Label)grdJobList.Rows[rowIndex].FindControl("lblJobId")).Text;
            Response.Write("<Script>window.open('JobInfo.aspx?jobid=" + jobId + "')</script>");

        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
        }

    }

    protected void btnAddFavorite1_Click(object sender, EventArgs e)
    {

        if (Session["perid"] != null)
            txtPerId.Value = Session["perid"].ToString();
        else
            Response.Redirect("~/include/Register_Person.aspx?mode=0");

        CheckBox chkSelect;
        String perid = Session["perid"].ToString();
        String sql = String.Empty;
        ArrayList paramList = new ArrayList();

        SqlConnection conn = null;
        SqlTransaction trans = null;
        bool transBegin = false;
        int checkCnt = 0;

        try
        {
            conn = DB.GetConnection();

            SqlCommand cmd = new SqlCommand();
            cmd.Connection = conn;
            cmd.CommandType = CommandType.Text;
            trans = conn.BeginTransaction();
            cmd.Transaction = trans;
            transBegin = true;

            sql = "SELECT jobid FROM personal_favorites WHERE perid=@0";
            
            DataTable favorites = DB.GetDataSet(conn, sql, trans,DB.Params2SqlParameter( perid) ).Tables[0];
            favorites.PrimaryKey = new DataColumn[] { favorites.Columns["jobid"] };
            for (int i = 0; i < grdJobList.Rows.Count; i++)
            {
                chkSelect = (CheckBox)grdJobList.Rows[i].FindControl("chkSelect");
                if (chkSelect.Checked)
                {
                    checkCnt++;
                    String jobid = ((Label)grdJobList.Rows[i].FindControl("lblJobId")).Text;
                    String comid = ((Label)grdJobList.Rows[i].FindControl("lblComId")).Text;
                    if (favorites.Rows.Find(jobid) == null)
                    {
                        sql = "INSERT INTO personal_favorites(perid,comid,jobid,adddate) " +
                                 "VALUES( @0,@1,@2,GETDATE())";

                        cmd.Parameters.Clear();
                        cmd.Parameters.Add(DB.Params2SqlParameter(perid));
                        cmd.Parameters.Add(DB.Params2SqlParameter(comid));
                        cmd.Parameters.Add(DB.Params2SqlParameter(jobid));
                        cmd.CommandText = sql;
                        cmd.ExecuteNonQuery();
                    }
                }
            }
            trans.Commit();
            transBegin = false;
            Session["perid"] = perid;
            if (checkCnt > 0)
                Common.Alert("选中职位已添加到收藏夹!", this);
        }
        catch (Exception ex)
        {
            if (transBegin)
                trans.Rollback();
            Response.Write(ex.Message);
            Response.End();
        }
        finally
        {
            if (conn != null && conn.State == ConnectionState.Open)
                conn.Close();
        }
    }
    protected void btnGoto2_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtGo2.Text);
        txtPageIndex.Value = txtGo2.Text;
        if (index < 1)
            txtPageIndex.Value = "1";
        if (index > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;

        txtGo2.Text = txtPageIndex.Value;
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }
}
