﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class wh_PersonFavorates : System.Web.UI.Page
{
    const Int32 rows = 20;
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Session["perid"] == null)
        {
            Response.Write("<script>alert('请登录再查找信息，谢谢！');location.href = 'index.aspx';</script>");
            return;
        }

        String perid = Session["perid"].ToString();
        getRecordCount(perid);
        if (!IsPostBack)
        {
            txtPageIndex.Value = "1";
            loadData(perid, Convert.ToInt32(txtPageIndex.Value));

        }
    }

    protected void btnFirst_Click(object sender, EventArgs e)
    {
        txtPageIndex.Value = "1";
        loadData(Session["perid"].ToString(), Convert.ToInt32(txtPageIndex.Value));

    }

    protected void btnPer_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtPageIndex.Value);
        if (index - 1 < 1)
            txtPageIndex.Value = "1";
        else
            txtPageIndex.Value = Convert.ToString(--index);
        loadData(Session["perid"].ToString(), Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnNext_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtPageIndex.Value);
        if (index + 1 > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;
        else
            txtPageIndex.Value = Convert.ToString(++index);
        loadData(Session["perid"].ToString(), Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnLast_Click(object sender, EventArgs e)
    {
        txtPageIndex.Value = txtPagesCnt.Value;
        loadData(Session["perid"].ToString(), Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnGoto_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtGo.Text);
        txtPageIndex.Value = txtGo.Text;
        if (index < 1)
            txtPageIndex.Value = "1";
        if (index > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;

        txtGo.Text = txtPageIndex.Value;
        loadData(Session["perid"].ToString(), Convert.ToInt32(txtPageIndex.Value));

    }

    protected void btnDelete_Click(object sender, EventArgs e)
    {
        CheckBox chkSelect;
        int index = 0;
        String deleteId = "";
        ArrayList paramList = new ArrayList();

        try
        {
            for (int i = 0; i < grdFavorites.Rows.Count; i++)
            {
                chkSelect = (CheckBox)grdFavorites.Rows[i].FindControl("chkSelect");
                if (chkSelect.Checked)
                {
                    deleteId +=  string.Format("@{0},",index);
                    paramList.Add(((Label)grdFavorites.Rows[i].FindControl("lblId")).Text);
                    index++;
                }
            }
            if (index > 0)
            {
                deleteId = deleteId.Substring(0, deleteId.Length - 1);
                String sql = String.Format("DELETE FROM personal_favorites WHERE id in ({0})", deleteId);
                DB.ExecuteSQL(sql,paramList);

                String perid = Session["perid"].ToString();
                getRecordCount(perid);
                if (Convert.ToInt32(txtPageIndex.Value) > Convert.ToInt32(txtPagesCnt.Value))
                    txtPageIndex.Value = txtPagesCnt.Value;
                loadData(perid, Convert.ToInt32(txtPageIndex.Value));
            }
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
        }
    }

    protected void btnSend_Click(object sender, EventArgs e)
    {
        CheckBox chkSelect;
        int index = 0;
        String deleteId = "";

        String perid = Session["perid"].ToString();
        String sql = String.Empty;
        ArrayList paramList = new ArrayList();
        SqlConnection conn = null;
        SqlTransaction trans = null;
        bool transBegin = false;
        ArrayList DelParamList = new ArrayList();

        try
        {
            conn = DB.GetConnection();
            SqlCommand cmd = new SqlCommand();
            cmd.Connection = conn;
            cmd.CommandType = CommandType.Text;
            trans = conn.BeginTransaction();
            cmd.Transaction = trans;
            transBegin = true;

            sql = "SELECT jobid FROM company_inbox WHERE perid=@0";
            DataTable comInbox = DB.GetDataSet(conn, sql, trans,DB.Params2SqlParameter(perid)).Tables[0];
            comInbox.PrimaryKey = new DataColumn[] { comInbox.Columns["jobid"] };

            for (int i = 0; i < grdFavorites.Rows.Count; i++)
            {
                chkSelect = (CheckBox)grdFavorites.Rows[i].FindControl("chkSelect");
                if (chkSelect.Checked)
                {
                    String id = ((Label)grdFavorites.Rows[i].FindControl("lblId")).Text;
                    sql = "SELECT a.perid,a.comid,a.jobid,b.jobname FROM personal_favorites a INNER JOIN jobs b ON a.jobid=b.jobid WHERE a.id=@0";
                    DataTable favorites = DB.GetDataSet(conn, sql, trans,DB.Params2SqlParameter(id)).Tables[0];
                    if (favorites.Rows.Count > 0)
                    {
                        String comid = favorites.Rows[0]["comid"].ToString();
                        String jobid = favorites.Rows[0]["jobid"].ToString();
                        String title = "应聘:" + favorites.Rows[0]["jobname"].ToString();

                        if (comInbox.Rows.Find(jobid) == null)
                        {
                            sql = "INSERT INTO company_inbox(perid,comid,jobid,apply_date,title,content,isread) " +
                                "VALUES( @0,@1,@2,GETDATE(),@3,@3,0)";

                            sql += ";INSERT INTO personal_outbox(perid,comid,jobid,adddate,title,issend) " +
                                  "VALUES( @0,@1,@2,GETDATE(),@3,1)";


                            cmd.CommandText = sql;
                            cmd.Parameters.Clear();

                            cmd.Parameters.Add( DB.Params2SqlParameter(perid));
                            cmd.Parameters.Add( DB.Params2SqlParameter(comid));
                            cmd.Parameters.Add( DB.Params2SqlParameter(jobid));
                            cmd.Parameters.Add( DB.Params2SqlParameter(title));

                            cmd.ExecuteNonQuery();
                            cmd.Parameters.Clear();
                        }
                    }
                    deleteId += string.Format( "@{0},",index);
                    DelParamList.Add(id);
                    index++;
                }
            }

            if (index > 0)
            {
                deleteId = deleteId.Substring(0, deleteId.Length - 1);
                sql = String.Format("DELETE FROM personal_favorites WHERE id in ({0})", deleteId);
                cmd.CommandText = sql;
                for (int j = 0; j < DelParamList.Count; j++)
                {
                    cmd.Parameters.Add(DB.Params2SqlParameter(DelParamList[j]));
                }
                cmd.ExecuteNonQuery();
            }
            trans.Commit();
            transBegin = false;

            if (index > 0)
            {
                getRecordCount(perid);
                if (Convert.ToInt32(txtPageIndex.Value) > Convert.ToInt32(txtPagesCnt.Value))
                    txtPageIndex.Value = txtPagesCnt.Value;
                loadData(perid, Convert.ToInt32(txtPageIndex.Value));
                Common.Alert("发送求职意向成功！", this);
            }

        }
        catch (Exception ex)
        {
            if (transBegin)
                trans.Rollback();
            Response.Write(ex.Message);
            Response.End();
        }
        finally
        {
            if (conn != null && conn.State == ConnectionState.Open)
                conn.Close();
        }
    }

    private void loadData(String perid, int pageNo)
    {
        if (pageNo == 0)
            pageNo = 1;
        String headSql = String.Format("SELECT TOP {0} a.id,a.perid,a.comid,a.jobid, b.CompanyName, c.JobName, CONVERT(VARCHAR(10),a.AddDate,120) adddate ", rows);
        String whereSql = " FROM personal_favorites a INNER JOIN company_base b ON a.ComID = b.ComID " +
                                        " INNER JOIN jobs c ON a.jobid = c.jobid " +
                                        " WHERE a.PerID = @0 ";
        String inSql = String.Format(" AND a.ID NOT IN (SELECT TOP {0} a.ID {1})", (pageNo - 1) * rows, whereSql);
        String sql = headSql + whereSql + inSql;
        DataTable inbox = DB.GetDataSet(sql, perid).Tables[0];
        grdFavorites.DataSource = inbox;
        grdFavorites.DataBind();
        grdFavorites.ShowHeader = true;
        lblCurrent.Text = String.Format("第{0}页", pageNo);
    }

    private void getRecordCount(String perid)
    {
        String whereSql = " FROM personal_favorites a INNER JOIN company_base b ON a.ComID = b.ComID " +
                                        " INNER JOIN jobs c ON a.jobid = c.jobid " +
                                        " WHERE a.PerID = @0 ";
        String sql = "SELECT COUNT(a.ID) cnt " + whereSql;
        DataTable inbox = DB.GetDataSet(sql,perid).Tables[0];
        Int32 recCnt = Convert.ToInt32(inbox.Rows[0]["cnt"].ToString());
        txtPagesCnt.Value = Common.getPageCnt(recCnt, rows).ToString();
        lblRecCount.Text = recCnt.ToString();
        if (txtPagesCnt.Value == "0")
            lblCurrent.Text = "无记录";
        else
            lblCurrent.Text = String.Format("第{0}页", txtPageIndex.Value);
    }
}
