﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;


public partial class wh_PersonWill : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
           txtPerId.Value = Session["perid"].ToString();
           loadData(Session["perid"].ToString());
            
        }
    }

    private void loadData(String perid)
    {


        String sql = "SELECT ncid,CASE salary WHEN 0 THEN '面议'  ELSE salary END salary,jobclass1,jobname1,workarea1 " +
                     "FROM personal_will WHERE perid=@0"; 

         DataTable user = DB.GetDataSet(sql,perid).Tables[0];

        grdWill.DataSource = user;
        grdWill.DataBind();
									
           
    }

   protected void grdWill_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        String ncid = ((Label)grdWill.Rows[e.RowIndex].FindControl("lblNcId")).Text;
        DeleteItem(ncid);
    }
    private void DeleteItem(String ncid)
    {
        try
        {
            String sql = "DELETE FROM personal_Will WHERE ncid=@0";
            DB.ExecuteSQL(sql, ncid);
     
           loadData(Session["perid"].ToString());
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }
  
  
    

    protected void btnSave_Click(object sender, EventArgs e)
    {
        fillList();
        try
        {
            if (Session["perid"] == null)
            {
                Response.Write("<script>alert('请登录再查找信息，谢谢！');location.href = 'index.aspx';</script>");
                return;
            }
            ArrayList paramList = new ArrayList();
            string perid = Session["perid"].ToString();
            String sql = "SELECT perid FROM personal_will WHERE perid=@0";

            if (DB.GetDataSet(sql, perid).Tables[0].Rows.Count > 0)
            {
                sql = "UPDATE personal_will SET jobtype=@1,workarea1=@2,workarea2=@3,workarea3=@4,workarea4=@5,workarea5=@6," +
                      "jobclass1=@7,jobclass2=@8,jobclass3=@9,jobclass4=@10,jobclass5=@11,jobname1=@12,jobname2=@13,jobname3=@14,jobname4=@15,jobname5=@16," +
                      "salary=@17,memo=@18,Update_Date=@19 where perid=@0";
            }
            else
            {
                sql = "INSERT INTO personal_will(perid,jobtype,workarea1,workarea2,workarea3,workarea4,workarea5," +
                      "jobclass1,jobclass2,jobclass3,jobclass4,jobclass5,jobname1,jobname2,jobname3,jobname4,jobname5," +
                      "salary,memo,Update_Date) " +
                      "VALUES(@0,@1,@2,@3,@4,@5,@6,@7,@8,@9,@10,@11,@12,@13,@14,@15,@16,@17,@18,@19)";
                
            }
            paramList.Add(perid);
            String[] jobClass = getList(lstJobClass);
            String[] workArea = getList(lstWorkArea);
            paramList.Add(Type);
            paramList.Add(workArea[0]);
            paramList.Add(workArea[1]);
            paramList.Add(workArea[2]);
            paramList.Add(workArea[3]);
            paramList.Add(workArea[4]);
            paramList.Add(jobClass[0]);
            paramList.Add(jobClass[1]);
            paramList.Add(jobClass[2]);
            paramList.Add(jobClass[3]);
            paramList.Add(jobClass[4]);
            paramList.Add(txtJobName1.Text);
            paramList.Add(txtJobName2.Text);
            paramList.Add(txtJobName3.Text);
            paramList.Add(txtJobName4.Text);
            paramList.Add(txtJobName5.Text);
            paramList.Add(getSalary());
            paramList.Add(txtMemo.Text);
            paramList.Add(Convert.ToString(new DateTime().ToString("yyyy-MM-dd")));

            DB.ExecuteSQL(sql, paramList);
            Common.Alert("保存数据成功!", this);
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    private int getSalary()
    {
        int salary = 0;
        if (txtSalary.Text.Trim() != "")
        {
            salary = Convert.ToInt32(txtSalary.Text);
        }
        return salary;
    }

    private int Type
    {
        get
        {
            int ret = 0;
            if (rdoFullTime.Checked)
                ret = 0;
            if (rdoPartTime.Checked)
                ret = 1;
            if (rdoOther.Checked)
                ret = 2;
            return ret;
        }
        set
        {
            switch (value)
            {
                case 0:
                    rdoFullTime.Checked = true;
                    break;
                case 1:
                    rdoPartTime.Checked = true;
                    break;
                case 2:
                    rdoOther.Checked = true;
                    break;
            }
        }
    }


    private String[] getList(ListBox lstObject)
    {
        String[] jobClass = new string[5];
        for (int i = 0; i < 5; ++i)
        {
            jobClass[i] = "";
        }
        for (int i = 0; i < lstObject.Items.Count; ++i)
        {
            jobClass[i] = lstObject.Items[i].Text;
        }
        return jobClass;
    }


    private void fillList()
    {
        String[] job = txtJob.Value.Split(';');
        String[] area = txtArea.Value.Split(';');
        String[] jobvalue = txtJobValue.Value.Split(';');
        String[] areavalue = txtAreaValue.Value.Split(';');
        lstJobClass.Items.Clear();
        lstWorkArea.Items.Clear();
        for (int i = 0; i < job.Length; ++i)
        {
            if (job[i].Trim() != "")
            {
                lstJobClass.Items.Add(new ListItem(job[i], jobvalue[i]));
            }
        }

        for (int i = 0; i < area.Length; ++i)
        {
            if (area[i].Trim() != "")
            {
                lstWorkArea.Items.Add(new ListItem(area[i], areavalue[i]));
            }
        }
    }
}
