﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class wh_PersonWork : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["perid"] != null)
            {
                InitForm();
            }
        }
    }

    private void InitForm()
    {
        txtPerId.Value = Session["perid"].ToString();
        InitMonth();
        LoadData(Session["perid"].ToString());
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            ArrayList paramList = new ArrayList();
            String sql = string.Empty;
            if (txtNcId.Value.Trim() != "")
            {
                sql = "UPDATE personal_workexperience SET companyname=@1,beginDate_year=@2,begindate_month=@3," +
                             "enddate_year=@4,enddate_month=@5,jobClass=@6,jobname=@7,memo=@8," +
                             "industry=@9,department=@10,demission=@11,type=@12 " +
                             "WHERE ncid=@0";
                paramList.Add(txtNcId.Value);
            }
            else
            {
                sql = "INSERT INTO personal_workexperience(perid,companyname,beginDate_year,begindate_month," +
                             "enddate_year,enddate_month,jobClass,jobname,memo,industry,department,demission,type) " +
                             "VALUES(@0,@1,@2,@3,@4,@5,@6,@7,@8,@9,@10,@11,@12)";
                paramList.Add(txtPerId.Value);
            }

            paramList.Add(txtCompanyName.Text);
            paramList.Add(Convert.ToInt32(txtBeginYear.Text));
            paramList.Add(Convert.ToInt32(cmbBeginMonth.Text));
            paramList.Add(Convert.ToInt32(txtEndYear.Text));
            paramList.Add(Convert.ToInt32(cmbEndMonth.Text));
            paramList.Add(txtJobClass.Text);
            paramList.Add(txtJobName.Text);
            paramList.Add(txtMemo.Text);
            paramList.Add(txtIndustry.Text);
            paramList.Add(txtDepartment.Text);
            paramList.Add(txtDemission.Text);
            paramList.Add(cmbType.Text);

            DB.ExecuteSQL(sql, paramList);
            DB.setLastUpdateTime(txtPerId.Value);
            ClearData();
            LoadData(txtPerId.Value);

            txtNcId.Value = "";
            Session["perid"] = txtPerId.Value;
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    private void LoadData(String perid)
    {
        String sql = "SELECT ncid,companyname,jobname," +
                     "CAST(begindate_year AS VARCHAR)+ '.' + RIGHT('00' + CAST(begindate_month AS VARCHAR), 2) " +
                     " + '---' + " +
                     "CAST(enddate_year AS VARCHAR)+ '.' + RIGHT('00' + CAST(enddate_month AS VARCHAR), 2) beTime " +
                     "FROM personal_workexperience WHERE perid=@0";

        DataSet user = DB.GetDataSet(sql, perid);
        DataTable education = user.Tables[0];

        grdWork.DataSource = user;
        grdWork.DataBind();
    }

    private void InitMonth()
    {
        for (int i = 1; i < 13; ++i)
        {
            cmbBeginMonth.Items.Add(i.ToString());
            cmbEndMonth.Items.Add(i.ToString());
        }
    }

    private void ClearData()
    {
        txtCompanyName.Text = "";
        txtBeginYear.Text = "";
        txtEndYear.Text = "";
        txtJobClass.Text = "";
        txtJobName.Text = "";
        txtMemo.Text = "";
        txtIndustry.Text = "";
        txtDemission.Text = "";
        txtDepartment.Text = "";
        cmbBeginMonth.SelectedIndex = 0;
        cmbEndMonth.SelectedIndex = 0;
        cmbType.SelectedIndex = 0;
    }
    protected void grdWork_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        String ncid = ((Label)grdWork.Rows[e.RowIndex].FindControl("lblNcId")).Text;
        DeleteItem(ncid);
    }

    private void DeleteItem(String ncid)
    {
        try
        {
            String sql = "DELETE FROM personal_workexperience WHERE ncid=@0";
            DB.ExecuteSQL(sql, ncid);
            ClearData();
            LoadData(txtPerId.Value);
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    protected void grdWork_RowEditing(object sender, GridViewEditEventArgs e)
    {
        String ncid = ((Label)grdWork.Rows[e.NewEditIndex].FindControl("lblNcId")).Text;
        UpdateItem(ncid);
    }

    private void UpdateItem(String ncid)
    {
        try
        {
            String sql = "SELECT * FROM personal_workexperience WHERE ncid=@0";
            DataTable work = DB.GetDataSet(sql, ncid).Tables[0];
            if (work.Rows.Count > 0)
            {
                DataRow row = work.Rows[0];
                txtCompanyName.Text = row["companyname"].ToString();
                txtBeginYear.Text = row["begindate_year"].ToString();
                txtEndYear.Text = row["enddate_year"].ToString();
                cmbBeginMonth.SelectedValue = row["begindate_month"].ToString();
                cmbEndMonth.SelectedValue = row["enddate_month"].ToString();
                txtJobClass.Text = row["jobclass"].ToString();
                txtJobName.Text = row["jobname"].ToString();
                txtMemo.Text = row["memo"].ToString();
                txtIndustry.Text = row["industry"].ToString();
                txtDepartment.Text = row["department"].ToString();
                txtDemission.Text = row["demission"].ToString();
                cmbType.SelectedValue = row["type"].ToString();
                txtNcId.Value = ncid;
            }
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }
}

