﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class wh_Person_Searchlist : System.Web.UI.Page
{
    const Int32 rows = 20;
    String is_txtJobClass, is_txtJobClassValue, is_txtCompanyType, is_txtDegree, is_txtWorkYears, is_txtSalary, is_txtPublishDate, is_txtKeyword;

    protected void Page_Load(object sender, EventArgs e)
    {

        if (!IsPostBack)
        {

            saveCondition();
            //getRecordCount();
            txtPageIndex.Value = "1";
            loadData(Convert.ToInt32(txtPageIndex.Value));

        }
    }

    private void saveCondition()
    {
        //txtJobClass.Value = Request.Form["txtJob"].ToString();
        //txtJobClassValue.Value = Request.Form["txtJobValue"].ToString();
        //txtCompanyType.Value = Request.Form["cmbType"].ToString();
        //txtDegree.Value = Request.Form["cmbDegree"].ToString();
        //txtWorkYears.Value = Request.Form["cmbWorkYears"].ToString();

        //txtSalary.Value = Request.Form["txtSalary"].ToString();
        //txtPublishDate.Value = Request.Form["cmbPublishDate"].ToString();
        //txtKeyword.Value = Request.Form["txtKeyWord"].ToString();

        is_txtJobClass = Request.Form["txtJob"].ToString();
        is_txtJobClassValue = Request.Form["txtJobValue"].ToString();
        is_txtCompanyType = Request.Form["cmbType"].ToString();
        is_txtDegree = Request.Form["cmbDegree"].ToString();
        is_txtWorkYears = Request.Form["cmbWorkYears"].ToString();

        is_txtSalary = Request.Form["txtSalary"].ToString();
        is_txtPublishDate = Request.Form["cmbPublishDate"].ToString();
        is_txtKeyword = Request.Form["txtKeyWord"].ToString();

        //*防止SQL注入
        //if (!DB.CheckParams(new object[] { jobType, jobTypeValue, is_txtCompanyType, is_txtDegree, is_txtWorkYears, is_txtSalary, is_txtPublishDate, is_txtKeyword }))
        //{
        //    Response.Redirect("ErrorSQLZR.aspx");
        //    return;
        //}
    }

    private void loadData(int pageNo)
    {
        try
        {
            if (pageNo == 0)
                pageNo = 1;
            object[] parameters = new object[10];
            Int16 ParamsNum = 0; 

            String selectSql = String.Format("SELECT TOP {0} b.comid,b.jobid,b.jobName,a.companyname,b.work_city," +
                         "CASE b.salary WHEN 0 THEN '面议' ELSE CONVERT(VARCHAR(10),CONVERT(DECIMAL(10,2),b.Salary)) END salary," +
                         "CONVERT(VARCHAR(10),b.lastUpdate_Date,120) adddate ", rows);
            String fromSql = String.Format("FROM jobs b LEFT JOIN company_base a ON a.comid = b.comid ");
            String ordSql = "ORDER BY b.lastUpdate_Date DESC,b.comid";

            String where = "WHERE b.isactive=1 AND a.IsVerified=1 ";
            //职位类别
            if (is_txtJobClassValue != "0-0" && is_txtJobClassValue.Trim() != "")
            {
                if (is_txtJobClass.IndexOf("-不限") >= 0)
                {
                    where += String.Format("AND b.jobclass LIKE @{0}", ParamsNum);
                    parameters[ParamsNum] = '%' + is_txtJobClassValue + '%';
                    ParamsNum++;
                }
                else
                {
                    where += String.Format("AND b.jobclass = @{0} ", ParamsNum);
                    parameters[ParamsNum] = is_txtJobClassValue;
                    ParamsNum++;
                }
            }
            //学历要求
            if (is_txtDegree.Trim() != "无" && is_txtDegree.Trim() != "")
            {
                where += String.Format("AND b.education =@{0} ", ParamsNum);
                parameters[ParamsNum] = is_txtDegree;
                ParamsNum++;
            }
            //工作年限
            if (is_txtWorkYears.Trim() != "0" && is_txtWorkYears.Trim() != "")
            {
                where += String.Format("AND b.work_years > @{0} ", ParamsNum);
                parameters[ParamsNum] = is_txtWorkYears;
                ParamsNum++;
            }
            ////在哪工作
            //if (txtWorkarea.Value.Trim() != "")
            //{
            //    where += String.Format("AND b.work_city = @{0} ", ParamsNum);
            //    parameters[ParamsNum] = txtWorkarea.Value;
            //    ParamsNum++;
            //}
            ////工作类型
            //if (txtJobType.Value.Trim() != "")
            //{
            //    where += String.Format("AND b.jobtype = @{0} ", ParamsNum);
            //    parameters[ParamsNum] = txtJobType.Value;
            //    ParamsNum++;
            //}

            //薪水
            if (is_txtSalary.Trim() != "")
            {
                where += String.Format("AND b.salary >= @{0} ", ParamsNum);
                parameters[ParamsNum] = is_txtSalary;
                ParamsNum++;
            }
            //公司性质
            if (is_txtCompanyType.Trim() != "0" && is_txtCompanyType.Trim() != "")
            {
                where += String.Format("AND a.type = @{0} ", ParamsNum);
                parameters[ParamsNum] = is_txtCompanyType;
                ParamsNum++;
            }
            //发布日期
            if (is_txtPublishDate.Trim() != "0" && is_txtPublishDate.Trim() != "")
            {
                where += String.Format("AND DATEDIFF(dd, b.lastUpdate_date, GETDATE()) <= @{0} ", ParamsNum);
                parameters[ParamsNum] = is_txtPublishDate;
                ParamsNum++;
            }
            //关键字
            if (is_txtKeyword.Trim() != "")
            {
                where += String.Format("AND (b.jobName LIKE @{0} OR a.companyname LIKE @{0}) ", ParamsNum);
                parameters[ParamsNum] = "%" + is_txtKeyword + "%";
                ParamsNum++;
            }

            String InSql = String.Format(" and b.jobid not in ( select top {0} b.jobid {1} {2} {3} )", rows * ( pageNo - 1) ,fromSql, where, ordSql);
            String DataSql = selectSql + fromSql + where + InSql + ordSql;
            String RowsSql = "select count(*) cnt " + fromSql + where;

            DataSet ds = DB.GetDataSet(RowsSql + ";" + DataSql, parameters);
            DataTable dt_rows = ds.Tables[0];

            Int32 recCnt = Convert.ToInt32(dt_rows.Rows[0]["cnt"].ToString());
            txtPagesCnt.Value = Common.getPageCnt(recCnt, rows).ToString();
            lblRecCount.Text = recCnt.ToString();
            if (txtPagesCnt.Value == "0")
            {
                lblCurrent1.Text = lblCurrent.Text = "无记录";
            }
            else
            {
                lblCurrent1.Text = lblCurrent.Text = String.Format("第{0}页", txtPageIndex.Value);
            }
            lblPageCount.Text = txtPagesCnt.Value;

            DataTable jobs = ds.Tables[1];
            grdJobList.DataSource = jobs;
            grdJobList.DataBind();
            lblCurrent1.Text = lblCurrent.Text = pageNo.ToString();
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    //private void getRecordCount()
    //{
    //    object[] parameters = new object[1];
    //    String sql = String.Format("SELECT COUNT(b.jobid) cnt  " +
    //                 "FROM jobs b LEFT JOIN company_base a ON a.comid = b.comid {0} ", getWhere(parameters));
    //    DataTable inbox = DB.GetDataSet(sql, parameters).Tables[0];
    //    Int32 recCnt = Convert.ToInt32(inbox.Rows[0]["cnt"].ToString());
    //    txtPagesCnt.Value = Common.getPageCnt(recCnt, rows).ToString();
    //    lblRecCount.Text = recCnt.ToString();
    //    if (txtPagesCnt.Value == "0")
    //    {
    //        lblCurrent1.Text = lblCurrent.Text = "无记录";
    //    }
    //    else
    //    {
    //        lblCurrent1.Text = lblCurrent.Text = String.Format("第{0}页", txtPageIndex.Value);
    //    }
    //    lblPageCount.Text = txtPagesCnt.Value;
    //}


  


    //private String getWhere(object[] parameters)
    //{
    //    //*防止SQL注入
    //    //if (!DB.CheckParams( new object[] { parameters} ))
    //    //{
    //    //    Response.Redirect("ErrorSQLZR.aspx");
    //    //    return "";
    //    //}


    //    String where = "WHERE b.isactive=1 AND a.IsVerified=1 ";
    //    //职位类别
    //    if (is_txtJobClassValue != "0-0" && is_txtJobClassValue.Trim() != "")
    //    {
    //        if (is_txtJobClass.IndexOf("-不限") >= 0)
    //            where += String.Format("AND b.jobclass LIKE '%{0}%'", is_txtJobClassValue);
    //        else
    //            where += String.Format("AND b.jobclass ='{0}' ", is_txtJobClassValue);
    //    }
    //    //学历要求
    //    if (is_txtDegree.Trim() != "无" && is_txtDegree.Trim() != "")
    //        where += String.Format("AND b.education ='{0}' ", is_txtDegree);
    //    //工作年限
    //    if (is_txtWorkYears.Trim() != "0" && is_txtWorkYears.Trim() != "")
    //        where += String.Format("AND b.work_years > {0} ", Convert.ToInt32(is_txtWorkYears));
    //    //在哪工作
    //    if (txtWorkarea.Value.Trim() != "")
    //        where += String.Format("AND b.work_city ='{0}' ", txtWorkarea.Value);
    //    //工作类型
    //    if (txtJobType.Value.Trim() != "")
    //        where += String.Format("AND b.jobtype ={0} ", Convert.ToInt32(txtJobType.Value));
    //    //薪水
    //    if (is_txtSalary.Trim() != "")
    //        where += String.Format("AND b.salary ={0} ", is_txtSalary);
    //    //公司性质
    //    if (is_txtCompanyType.Trim() != "0" && is_txtCompanyType.Trim() != "")
    //        where += String.Format("AND a.type ='{0}' ", is_txtCompanyType);
    //    //发布日期
    //    if (is_txtPublishDate.Trim() != "0" && is_txtPublishDate.Trim() != "")
    //        where += String.Format("AND DATEDIFF(dd, b.lastUpdate_date, GETDATE()) <= {0} ", is_txtPublishDate);
    //    //关键字
    //    if (is_txtKeyword.Trim() != "")
    //    {
    //        where += "AND (b.jobName LIKE @0 OR a.companyname LIKE @0) ";
    //        parameters[0] = "%" + is_txtKeyword + "%";
    //    }
    //    return where;
    //}


    
    protected void btnFirst_Click(object sender, EventArgs e)
    {
        txtPageIndex.Value = "1";
        loadData(Convert.ToInt32(txtPageIndex.Value));

    }

    protected void btnPer_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtPageIndex.Value);
        if (index - 1 < 1)
            txtPageIndex.Value = "1";
        else
            txtPageIndex.Value = Convert.ToString(--index);
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnNext_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtPageIndex.Value);
        if (index + 1 > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;
        else
            txtPageIndex.Value = Convert.ToString(++index);
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnLast_Click(object sender, EventArgs e)
    {
        txtPageIndex.Value = txtPagesCnt.Value;
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnGoto_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtGo.Text);
        txtPageIndex.Value = txtGo.Text;
        if (index < 1)
            txtPageIndex.Value = "1";
        if (index > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;

        txtGo.Text = txtPageIndex.Value;
        loadData(Convert.ToInt32(txtPageIndex.Value));

    }
    protected void grdJobList_RowEditing(object sender, GridViewEditEventArgs e)
    {
        try
        {
            int rowIndex = e.NewEditIndex;
            String jobId = ((Label)grdJobList.Rows[rowIndex].FindControl("lblJobId")).Text;
            Response.Redirect("JobInfo.aspx?jobid=" + jobId );

        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
        }

    }

    protected void btnAddFavorite1_Click(object sender, EventArgs e)
    {
        int t;
        if (Session["perid"] != null)
            //txtPerId.Value = Session["perid"].ToString();
            t = 0;
        else
            Response.Redirect("index.aspx");

        CheckBox chkSelect;
        String perid = Session["perid"].ToString();
        String sql = String.Empty;

        //*防止SQL注入
        //if (!DB.CheckParams(new object[] { perid }))
        //{
        //    Response.Redirect("ErrorSQLZR.aspx");
        //    return;
        //}

        SqlConnection conn = null;
        SqlTransaction trans = null;
        bool transBegin = false;
        int checkCnt = 0;

        try
        {
            conn = DB.GetConnection();

            SqlCommand cmd = new SqlCommand();
            cmd.Connection = conn;
            cmd.CommandType = CommandType.Text;
            trans = conn.BeginTransaction();
            cmd.Transaction = trans;
            transBegin = true;

            
            sql = "SELECT jobid FROM personal_favorites WHERE perid= @0";
            DataTable favorites = DB.GetDataSet(conn, sql, trans,DB.Params2SqlParameter( perid) ).Tables[0];
            favorites.PrimaryKey = new DataColumn[] { favorites.Columns["jobid"] };
            for (int i = 0; i < grdJobList.Rows.Count; i++)
            {
                chkSelect = (CheckBox)grdJobList.Rows[i].FindControl("chkSelect");
                if (chkSelect.Checked)
                {
                    checkCnt++;
                    String jobid = ((Label)grdJobList.Rows[i].FindControl("lblJobId")).Text;
                    String comid = ((Label)grdJobList.Rows[i].FindControl("lblComId")).Text;
                    if (favorites.Rows.Find(jobid) == null)
                    {
                        ////*防止SQL注入
                        //if (!DB.CheckParams(new object[] { jobid, comid }))
                        //{
                        //    Response.Redirect("ErrorSQLZR.aspx");
                        //    return;
                        //}

                        sql = "INSERT INTO personal_favorites(perid,comid,jobid,adddate) " +
                                 "VALUES( @0,@1,@2,GETDATE())";
                        
                        cmd.CommandText = sql;

                        cmd.Parameters.Clear();
                        SqlParameter[] parameters = new SqlParameter[3];
                        parameters[0] = new SqlParameter();
                        parameters[0].ParameterName = "@0";
                        parameters[0].Value = perid;
                        cmd.Parameters.Add(parameters[0]);

                        parameters[1] = new SqlParameter();
                        parameters[1].ParameterName = "@1";
                        parameters[1].Value = comid;
                        cmd.Parameters.Add(parameters[1]);

                        parameters[2] = new SqlParameter();
                        parameters[2].ParameterName = "@2";
                        parameters[2].Value = jobid;
                        cmd.Parameters.Add(parameters[2]);
                        
                        cmd.ExecuteNonQuery();
                    }
                }
            }
            trans.Commit();
            transBegin = false;
            Session["perid"] = perid;
            if (checkCnt > 0)
                Common.Alert("选中职位已添加到收藏夹!", this);
        }
        catch (Exception ex)
        {
            if (transBegin)
                trans.Rollback();
            Response.Write(ex.Message);
            Response.End();
        }
        finally
        {
            if (conn != null && conn.State == ConnectionState.Open)
                conn.Close();
        }
    }
    protected void btnGoto2_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtGo2.Text);
        txtPageIndex.Value = txtGo2.Text;
        if (index < 1)
            txtPageIndex.Value = "1";
        if (index > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;

        txtGo2.Text = txtPageIndex.Value;
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }
}
