﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class wh_Personbasic : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["perid"] != null)
            {
                IniBirth();
                loadBaseInfo();
            }
            else
            {
                Response.Write("<script>alert('请登录再查找信息，谢谢！');location.href = 'index.aspx';</script>");
                return;
            }
        }
    }

    private void loadBaseInfo()
    {
        String perid = Session["perid"].ToString();
        txtPerid.Value = perid;

        String sql = "SELECT RealName,sex,nation,birth_year,birth_month,birth_day," +
                     "Marrage,stature,weight,idcardtype,idcardno,hukou_province,hukou_city," +
                     "current_province,current_city,education,self_evaluation,phone,mobilephone," +
                     "im,webhome,email,zipcode,address FROM personal_base a " +
                     "LEFT JOIN personal_info b ON a.perid=b.perid " +
                     "WHERE a.perid = @0";
        DataTable user = DB.GetDataSet(sql,perid).Tables[0];
        if (user.Rows.Count > 0)
        {
            txtRealName.Text = user.Rows[0]["RealName"].ToString();
            setGender(Convert.ToInt32(user.Rows[0]["sex"].ToString()));
            cmbNation.SelectedIndex = cmbNation.Items.IndexOf(new ListItem(user.Rows[0]["nation"].ToString()));
            txtBirthYear.Text = user.Rows[0]["birth_year"].ToString();
            cmbBirthMonth.SelectedIndex = cmbBirthMonth.Items.IndexOf(new ListItem(user.Rows[0]["birth_month"].ToString()));
            cmbBirthDay.SelectedIndex = cmbBirthDay.Items.IndexOf(new ListItem(user.Rows[0]["birth_day"].ToString()));
            cmbMarriage.SelectedValue = user.Rows[0]["marrage"].ToString();
            txtStature.Text = user.Rows[0]["stature"].ToString();
            txtWeight.Text = user.Rows[0]["weight"].ToString();
            cmbCertificateType.SelectedValue = user.Rows[0]["idcardtype"].ToString();
            txtCertificateNo.Text = user.Rows[0]["idcardno"].ToString();
            txtProvince1.Text = user.Rows[0]["hukou_province"].ToString();
            txtCity1.Text = user.Rows[0]["hukou_city"].ToString();
            txtProvince2.Text = user.Rows[0]["current_province"].ToString();
            txtCity2.Text = user.Rows[0]["current_city"].ToString();
            cmbEducate.SelectedIndex = cmbEducate.Items.IndexOf(new ListItem(user.Rows[0]["education"].ToString()));
            txtIntroduce.Text = user.Rows[0]["self_evaluation"].ToString();
            txtPhone.Text = user.Rows[0]["phone"].ToString();
            txtMobile.Text = user.Rows[0]["mobilephone"].ToString();
            txtIm.Text = user.Rows[0]["im"].ToString();
            txtHomePage.Text = user.Rows[0]["webhome"].ToString();
            txtMail.Text = user.Rows[0]["email"].ToString();
            txtZipCode.Text = user.Rows[0]["zipcode"].ToString();
            txtAddress.Text = user.Rows[0]["address"].ToString();
        }

    }

    private void setGender(int gender)
    {
        switch (gender)
        {
            case 0:
                rdoFemale.Checked = true;
                break;
            case 1:
                rdoMale.Checked = true;
                break;
            case 2:
                rdoNone.Checked = true;
                break;
        }
    }

    private void IniBirth()
    {
        for (int i = 1; i < 13; ++i)
        {
            cmbBirthMonth.Items.Add(i.ToString());
        }

        for (int i = 1; i < 32; ++i)
        {
            cmbBirthDay.Items.Add(i.ToString());
        }
    }
    protected void btnOk_Click(object sender, EventArgs e)
    {
        String sql = String.Empty;
        ArrayList paramList = new ArrayList();

        String perId = txtPerid.Value;

        SqlConnection conn = null;
        SqlTransaction trans = null;
        bool transBegin = false;
        try
        {
            conn = DB.GetConnection();

            SqlCommand cmd = new SqlCommand();
            cmd.Connection = conn;
            cmd.CommandType = CommandType.Text;
            trans = conn.BeginTransaction();
            cmd.Transaction = trans;
            transBegin = true;

            sql = "UPDATE personal_base SET mobilephone=@0,email=@1 where perid=@2";
            cmd.CommandText = sql;

            paramList.Add(txtMobile.Text);
            paramList.Add(txtMail.Text);
            paramList.Add(perId);

            SqlParameter[] parameters = new SqlParameter[paramList.Count];
            for (int i = 0; i < paramList.Count; ++i)
            {
                parameters[i] = new SqlParameter();
                parameters[i].ParameterName = "@" + i.ToString();
                parameters[i].Value = paramList[i];
            }
            DB.ExecuteSQL(cmd, parameters);

            paramList.Clear();
            sql = "UPDATE personal_info SET RealName=@0,sex=@1,nation=@2,birth_year=@3,birth_month=@4,birth_day=@5," +
                 "Marrage=@6,stature=@7,weight=@8,idcardtype=@9,idcardno=@10,hukou_province=@11,hukou_city=@12," +
                 "current_province=@13,current_city=@14,education=@15,self_evaluation=@16,phone=@17," +
                 "im=@18,webhome=@19,zipcode=@20,address=@21 WHERE perid=@22";
            cmd.CommandText = sql;

            paramList.Add(txtRealName.Text);
            paramList.Add(getGender());
            paramList.Add(cmbNation.SelectedItem.Text);
            paramList.Add(Convert.ToInt32(txtBirthYear.Text));
            paramList.Add(Convert.ToInt32(cmbBirthMonth.SelectedItem.Value));
            paramList.Add(Convert.ToInt32(cmbBirthDay.SelectedItem.Value));
            paramList.Add(Convert.ToInt32(cmbMarriage.SelectedItem.Value));
            String stature = txtStature.Text.Trim() == "" ? "0" : txtStature.Text;
            paramList.Add(Convert.ToInt32(stature));
            String weight = txtWeight.Text.Trim() == "" ? "0" : txtWeight.Text;
            paramList.Add(Convert.ToInt32(weight));
            paramList.Add(Convert.ToInt32(cmbCertificateType.SelectedItem.Value));
            paramList.Add(txtCertificateNo.Text);
            paramList.Add(txtProvince1.Text);
            paramList.Add(txtCity1.Text);
            paramList.Add(txtProvince2.Text);
            paramList.Add(txtCity2.Text);
            paramList.Add(cmbEducate.SelectedItem.Text);
            paramList.Add(txtIntroduce.Text);
            paramList.Add(txtPhone.Text);
            paramList.Add(txtIm.Text);
            paramList.Add(txtHomePage.Text);
            paramList.Add(txtZipCode.Text);
            paramList.Add(txtAddress.Text);
            paramList.Add(perId);

            parameters = new SqlParameter[paramList.Count];
            for (int i = 0; i < paramList.Count; ++i)
            {
                parameters[i] = new SqlParameter();
                parameters[i].ParameterName = "@" + i.ToString();
                parameters[i].Value = paramList[i];
            }
            DB.ExecuteSQL(cmd, parameters);


            trans.Commit();

            DB.setLastUpdateTime(perId);
            transBegin = false;
            Session["perid"] = perId;
            Common.Alert("保存数据成功!", this);
        }
        catch (Exception ex)
        {
            if (transBegin)
                trans.Rollback();
            Response.Write(ex.Message);
            Response.End();
        }
        finally
        {
            if (conn != null && conn.State == ConnectionState.Open)
                conn.Close();
        }
    }

    private int getGender()
    {
        int gender = 0;
        if (rdoMale.Checked)
            gender = 1;
        if (rdoFemale.Checked)
            gender = 0;
        if (rdoNone.Checked)
            gender = 2;

        return gender;
    }
}
