﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class WAP_WebUserControlJobList : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {

        LoadData();
    }

    public int LoadData()
    {
        string Sql;
        string SQLWhere;
        string JobType = Request["ctl00$JobType"] + "".Trim();
        string KeyWord = Request["keyWord"] + "".Trim();
        int PageNum;
        int PageCount;
        int TopNum = 10;
        int MaxRow;
        int Rows;
        ArrayList paramList = new ArrayList();
        int index = 0;

        if (int.TryParse(Request["Page"] + "", out PageNum) == false) PageNum = 1;
        if (PageNum <= 0) PageNum = 1;
        MaxRow = PageNum * TopNum;

        if (JobType == "不限")
        {
            if (KeyWord == "")
            {
                SQLWhere = "where 1=1";
            }
            else
            {
                SQLWhere = String.Format("where (jobclass like @{0} or jobname like @{0} or required like @{0})", index);
                paramList.Add(KeyWord + "%");
                index++;
            }
        }
        else
        {
            if (KeyWord == "")
            {
                SQLWhere = String.Format(" where (jobclass like @{0}) ", index);
                paramList.Add(JobType + "%");
                index++;
            }
            else
            {
                SQLWhere = String.Format("where jobclass like @{0} and ( jobclass like @{1} or jobname like @{1} or required like @{1} ) ", index, index+1);
                paramList.Add(JobType + "%");
                paramList.Add(KeyWord + "%");
                index+=2;
            }
        }

        SQLWhere = SQLWhere + " and IsActive = 1 and convert( datetime,convert( varchar,enddate_year)+'-'+convert( varchar,enddate_month)+'-'+convert(varchar,enddate_day)+' 23:59:59',120) >= getdate()";
        Sql = String.Format("select count(*) PageCount from jobs {0} ", SQLWhere);
        DataSet ds = DB.GetDataSet(Sql, paramList);
        if (int.TryParse(ds.Tables[0].Rows[0]["PageCount"].ToString(), out Rows) == false) Rows = 0;
        double temp = 1.0 * Rows / TopNum;
        PageCount = (int)Math.Ceiling(temp);


        if (Rows < MaxRow)
        {
            TopNum = Rows - (MaxRow - TopNum);
            Sql = String.Format("select * from (select top {0} * from ( " +
                                  "select top {1} jobid,jobclass,jobname from jobs {2} order by jobclass,jobname) z order by jobclass desc,jobname desc) y order by jobclass,jobname;", TopNum, MaxRow, SQLWhere);
        }
        else
        {
            Sql = String.Format("select * from (select top {0} * from ( " +
                                   "select top {1} jobid,jobclass,jobname from jobs {2} order by jobclass,jobname) z order by jobclass desc,jobname desc) y order by jobclass,jobname;", TopNum, MaxRow, SQLWhere);
        }
        ds = DB.GetDataSet(Sql, paramList);
        RpJobList.DataSource = ds.Tables[0];
        RpJobList.DataBind();

        FirstPage.HRef = "Default.aspx?type=A&id=2.1&Page=1";
        PriorPage.HRef = "Default.aspx?type=A&id=2.1&Page="+(PageNum - 1).ToString();
        NextPage.HRef = "Default.aspx?type=A&id=2.1&Page="+(PageNum + 1).ToString();
        LastPage.HRef = "Default.aspx?type=A&id=2.1&Page=" + (PageCount ).ToString();

        if (PageNum <= 1)
        {
            FirstPage.HRef = "";
            PriorPage.HRef = "";
        }
        
        if (PageCount <= PageNum)
        {
            NextPage.HRef = "";
            LastPage.HRef = "";
        }
        PageTip.Text = "第" + PageNum.ToString() + "页，共" + PageCount.ToString() + "页";
        return 1;
        
    }

    
}
