﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class wh_com_searchlist : System.Web.UI.Page
{
    const Int32 rows = 10;
    String is_txtJobClass, is_txtJobClassValue, is_txtJobArea, is_txtJobAreaValue, is_txtEducation, is_txtSex;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
           
                saveCondition();
                //getRecordCount();
                txtPageIndex.Value = "1";
                loadData(Convert.ToInt32(txtPageIndex.Value));
           
        }
    }

    private void saveCondition()
    {

        //txtJobClass.Value = Request.Form["txtJob"].ToString();
        //txtJobClassValue.Value = Request.Form["txtJobValue"].ToString();
        //txtJobArea.Value = Request.Form["txtArea"].ToString();
        //txtJobAreaValue.Value = Request.Form["txtAreaValue"].ToString();
        //txtEducation.Value = Request.Form["cmbDegree"].ToString();
        //txtSex.Value = Request.Form["cmbSex"].ToString();

        is_txtJobClass = Request.Form["txtJob"].ToString();
        is_txtJobClassValue = Request.Form["txtJobValue"].ToString();
        is_txtJobArea = Request.Form["txtArea"].ToString();
        is_txtJobAreaValue = Request.Form["txtAreaValue"].ToString();
        is_txtEducation = Request.Form["cmbDegree"].ToString();
        is_txtSex = Request.Form["cmbSex"].ToString();

        //*防止SQL注入
        //if (!DB.CheckParams(new object[] { is_txtJobClass, is_txtJobClassValue, is_txtJobArea, is_txtJobAreaValue, is_txtEducation, is_txtSex  }))
        //{
        //    Response.Redirect("ErrorSQLZR.aspx");
        //    return;
        //}

    }

    private void loadData(int pageNo)
    {
        try
        {
            if (pageNo == 0)
                pageNo = 1;
            object[] parameters = new object[5];
            int ParamsNum = 0;
            
            String where = "WHERE  a.IsVerified=1 ";
            //职位类别
            if (is_txtJobClass != "不限" && is_txtJobClass.Trim() != "")
            {
                where += String.Format("AND (c.jobclass1 LIKE @{0} OR " +
                                            "c.jobclass2 LIKE @{0} OR " +
                                            "c.jobclass3 LIKE @{0} OR " +
                                            "c.jobclass4 LIKE @{0} OR " +
                                            "c.jobclass5 LIKE @{0} ) ", ParamsNum);
                parameters[ParamsNum] = "%" + is_txtJobClassValue.Trim() + "%";
                ParamsNum++;
            }
            //工作地区
            if (is_txtJobArea != "不限" && is_txtJobArea.Trim() != "")
            {
                where += String.Format("AND (c.workArea1 LIKE @{0} OR " +
                                            "c.workArea2 LIKE @{0} OR " +
                                            "c.workArea3 LIKE @{0} OR " +
                                            "c.workArea4 LIKE @{0} OR " +
                                            "c.workArea5 LIKE @{0} ) ", ParamsNum);
                parameters[ParamsNum] = "%" + is_txtJobAreaValue.Trim() + "%";
                ParamsNum++;
            }
            //教育程度
            if (is_txtEducation.Trim() != "无" && is_txtEducation.Trim() != "")
            {
                where += String.Format("AND b.education = @{0} ", ParamsNum);
                parameters[ParamsNum] = is_txtEducation;
                ParamsNum++;
            }

            //性别
            if (is_txtSex.Trim() != "2" && is_txtSex.Trim() != "")
            {
                where += String.Format("AND b.Sex = @{0} ", ParamsNum);
                parameters[ParamsNum] = is_txtSex;
                ParamsNum++;
            }
            //工作类型
            if (txtPublishDate.Value.Trim() != "0" && txtPublishDate.Value.Trim() != "")
            {
                where += String.Format("AND DATEDIFF(dd,a.LastUpdate_Date,GETDATE()) < @{0} ", ParamsNum);
                parameters[ParamsNum] = txtPublishDate.Value;
                ParamsNum++;
            }

            String SqlFromWhere = "FROM personal_base a LEFT JOIN " +
                        "    personal_info b ON a.perid = b.perid LEFT JOIN " +
                        "    personal_will c ON a.perid = c.perid " + where;
            String SqlOrder = "ORDER BY a.lastUpdate_Date DESC ";
            String SqlIn = String.Format(" and a.perid not in ( select top {0} a.perid {1} {2})", rows * (pageNo - 1), SqlFromWhere, SqlOrder);

            String SqlData = String.Format( "SELECT top {0} a.perid, b.realname, " +
                                            "    CASE b.sex WHEN 0 THEN '女' WHEN 1 THEN '男' ELSE '保密' END sex, b.education, " +
                                            "c.JobClass1 " +
                                           "+ case c.jobclass2 when null then '' when '' then '' else ' ｜ '+c.jobclass2 end " +
                                           "+ case c.jobclass3 when null then '' when '' then '' else ' ｜ '+c.jobclass3 end " +
                                           "+ case c.jobclass4 when null then '' when '' then '' else ' ｜ '+c.jobclass4 end " +
                                           "+ case c.jobclass5 when null then '' when '' then '' else ' ｜ '+c.jobclass5 end jobclass," +
                                           "CONVERT(VARCHAR(10),a.LastUpdate_Date,121) publishDate {1} {2} {3}", rows, SqlFromWhere, SqlIn, SqlOrder);
            

            String SqlRows = "select count( a.perid) " + SqlFromWhere;


            DataSet ds = DB.GetDataSet(SqlRows + ";" + SqlData, parameters);
            DataTable RowCount = ds.Tables[0];
            DataTable jobs = ds.Tables[1];

            //设置页数
            Int32 recCnt = Convert.ToInt32( RowCount.Rows[0][0]);
            txtPagesCnt.Value = Common.getPageCnt(recCnt, rows).ToString();
            lblRecCnt2.Text = lblRecCnt.Text = recCnt.ToString();
            if (txtPagesCnt.Value == "0")
            {
                lblCurrent2.Text = lblCurrent.Text = "无记录";
                lblPageIndex2.Text = lblPageIndex.Text = "1";
            }
            else
            {
                lblCurrent2.Text = lblCurrent.Text = String.Format("第{0}页", txtPageIndex.Value);
                lblPageIndex2.Text = lblPageIndex.Text = txtPagesCnt.Value;
            }
            lblPageCnt2.Text = lblPageCnt.Text = txtPagesCnt.Value;


            //设置数据
            grdPersons.DataSource = jobs;
            grdPersons.DataBind();
            lblCurrent2.Text = lblCurrent.Text = pageNo.ToString();


        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    //private void getRecordCount()
    //{
    //    String sql = String.Format("SELECT COUNT(a.perid) cnt  " +
    //                               "FROM personal_base a LEFT JOIN " +
    //                               "personal_info b ON a.perid = b.perid LEFT JOIN " +
    //                               "personal_will c ON a.perid = c.perid {0} ", getWhere());
    //    DataTable inbox = DB.GetDataSet(sql).Tables[0];
    //    Int32 recCnt = Convert.ToInt32(inbox.Rows[0]["cnt"].ToString());
    //    txtPagesCnt.Value = Common.getPageCnt(recCnt, rows).ToString();
    //    lblRecCnt2.Text = lblRecCnt.Text = recCnt.ToString();
    //    if (txtPagesCnt.Value == "0")
    //    {
    //        lblCurrent2.Text = lblCurrent.Text = "无记录";
    //        lblPageIndex2.Text = lblPageIndex.Text = "1";
    //    }
    //    else
    //    {
    //        lblCurrent2.Text = lblCurrent.Text = String.Format("第{0}页", txtPageIndex.Value);
    //        lblPageIndex2.Text = lblPageIndex.Text = txtPagesCnt.Value;
    //    }
    //    lblPageCnt2.Text = lblPageCnt.Text = txtPagesCnt.Value;
    //}

    //private String getWhere()
    //{
    //    //*防止SQL注入
    //    //if (!DB.CheckParams(new object[] { is_txtJobClass, is_txtJobClassValue, is_txtJobArea, is_txtJobAreaValue, is_txtEducation, is_txtSex, txtPublishDate.Value }))
    //    //{
    //    //    Response.Redirect("ErrorSQLZR.aspx");
    //    //    return "";
    //    //}

    //    String where = "WHERE  a.IsVerified=1 ";
    //    //职位类别
    //    if (is_txtJobClass != "不限" && is_txtJobClass.Trim() != "")
    //    {
    //        where += String.Format("AND (c.jobclass1 LIKE '%{0}%' OR " +
    //                                "c.jobclass2 LIKE '%{0}%' OR " +
    //                                "c.jobclass3 LIKE '%{0}%' OR " +
    //                                "c.jobclass4 LIKE '%{0}%' OR " +
    //                                "c.jobclass5 LIKE '%{0}%' ) ", is_txtJobClassValue);
    //    }
    //    //工作地区
    //    if (is_txtJobArea != "不限" && is_txtJobArea.Trim() != "")
    //    {
    //        where += String.Format("AND (c.workArea1 LIKE '%{0}%' OR " +
    //                                    "c.workArea2 LIKE '%{0}%' OR " +
    //                                    "c.workArea3 LIKE '%{0}%' OR " +
    //                                    "c.workArea4 LIKE '%{0}%' OR " +
    //                                    "c.workArea5 LIKE '%{0}%' ) ", is_txtJobAreaValue);
    //    }
    //    //教育程度
    //    if (is_txtEducation.Trim() != "无" && is_txtEducation.Trim() != "")
    //        where += String.Format("AND b.education ='{0}' ", is_txtEducation);
    //    //性别
    //    if (is_txtSex.Trim() != "2" && is_txtSex.Trim() != "")
    //        where += String.Format("AND b.Sex ={0} ", is_txtSex);
    //    //工作类型
    //    if (txtPublishDate.Value.Trim() != "0" && txtPublishDate.Value.Trim() != "")
    //        where += String.Format("AND DATEDIFF(dd,a.LastUpdate_Date,GETDATE()) <{0} ", txtPublishDate.Value);

    //    return where;
    //}

    protected void btnFirst_Click(object sender, EventArgs e)
    {
        txtPageIndex.Value = "1";
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnPer_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtPageIndex.Value);
        if (index - 1 < 1)
            txtPageIndex.Value = "1";
        else
            txtPageIndex.Value = Convert.ToString(--index);
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnNext_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtPageIndex.Value);
        if (index + 1 > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;
        else
            txtPageIndex.Value = Convert.ToString(++index);
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnLast_Click(object sender, EventArgs e)
    {
        txtPageIndex.Value = txtPagesCnt.Value;
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnGoto_Click(object sender, EventArgs e)
    {

        int index;
        bool RetuenValue = int.TryParse(txtGo.Text, out index);
        if ( !RetuenValue)
        {
            Response.Write("javascript:alert(\" - 请输入跳转页码 - \");history.go(-1);");
            Response.End();
        }

        txtPageIndex.Value = txtGo.Text;
        if (index < 1)
            txtPageIndex.Value = "1";
        if (index > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;

        txtGo.Text = txtPageIndex.Value;
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }
    protected void btnGoto2_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtGo2.Text);
        txtPageIndex.Value = index.ToString();
        if (index < 1)
            txtPageIndex.Value = "1";
        if (index > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;

        txtGo2.Text = txtPageIndex.Value;
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnLogout_Click(object sender, EventArgs e)
    {
        String region = "";
        if (Session["region"] != null)
            region = Session["region"].ToString();

        Session.Clear();
        if (region.Equals("五华"))
            Response.Redirect("index.aspx");
        else
            Response.Redirect("index.aspx");
    }
    protected void grdPersons_RowEditing(object sender, GridViewEditEventArgs e)
    {
        try
        {
            int rowIndex = e.NewEditIndex;
            String perId = ((Label)grdPersons.Rows[rowIndex].FindControl("lblPerId")).Text;
            Response.Redirect("Resume/ResumeMode1.aspx?param=" + perId );

        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
        }
    }

    public String handleWill(Object field)
    {
        String ret = "";
        ret = Convert.ToString(field);
        if (ret.Trim() == "")
            ret = "---";
        else
            ret = ret.Split('|')[0];
        return ret;

    }
}
