﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class wh_companyinfo : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            loadBaseInfo(Request.QueryString["comid"].ToString());
        }
    }

    private void loadBaseInfo(String comid)
    {
        //*防止SQL注入
        //if (!DB.CheckParams(new object[] { comid }))
        //{
        //    Response.Redirect("ErrorSQLZR.aspx");
        //    return;
        //}

        txtComId.Value = comid;

        String sql = "SELECT * FROM company_base WHERE comid = @0";
        DataTable company = DB.GetDataSet(sql, comid).Tables[0];

        if (company.Rows.Count > 0)
        {
            DataRow row = company.Rows[0];

            lblCompany.Text = Convert.ToString(row["companyname"]);
            lblLicense.Text = Convert.ToString(row["license"]);
            lblIndustry.Text = row["industry"].ToString();
            lblType.Text = row["Type"].ToString();

            lblFoundDate.Text = Convert.ToString(row["found_year"]) + "-" + Convert.ToString(row["found_month"]) + "-" + Convert.ToString(row["found_day"]);

            lblRegCapital.Text = Convert.ToString(row["reg_capital"]);
            String currency = Convert.ToString(row["reg_currency"]);
            String currencyName = "万";
            if (currency.CompareTo("0") == 0)
                currencyName += "人民币";
            else if (currency.CompareTo("1") == 0)
                currencyName += "美元";
            else if (currency.CompareTo("2") == 0)
                currencyName += "欧元";
            else if (currency.CompareTo("3") == 0)
                currencyName += "港币";
            else if (currency.CompareTo("4") == 0)
                currencyName += "台币";
            else if (currency.CompareTo("5") == 0)
                currencyName += "英镑";
            lblRegCurrency.Text = currencyName;
            lblWorkers.Text = Convert.ToString(row["workers"]);
            lblProvinceCity.Text = Convert.ToString(row["province"]) + Convert.ToString(row["city"]);
            lblMemo.Text = Convert.ToString(row["memo"]);
            lblPhone.Text = Convert.ToString(row["contact_phone"]);
            lblContactPerson.Text = Convert.ToString(row["contact_person"]);

            lblFax.Text = Convert.ToString(row["contact_fax"]);
            lblEmail.Text = Convert.ToString(row["email"]);
            lblWebsite.Text = Convert.ToString(row["website"]);
            lblZipCode.Text = Convert.ToString(row["zipcode"]);
            lblAddress.Text = Convert.ToString(row["address"]);

            if (Convert.ToString(row["Logo_Url"]) != null && Convert.ToString(row["Logo_Url"]) != "")
            {
                string path = "uploadfile/";
                imgLogo.ImageUrl = path + Convert.ToString(row["Logo_Url"]).Trim();
            }
            else
            {
                imgLogo.ImageUrl = "images/Company.gif";
            }
        }
    }

}

