﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class wh_dibu_view : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Request.QueryString["newsid"] == null)
        {
            Response.Write("没有相关数据");
        }
        else
        {
            Int32 iNewsID;
            string sNewsID = Request.QueryString["newsid"].ToString();
            bool b = int.TryParse(sNewsID, out iNewsID);
            if (b) loadData(iNewsID);
            else
            {
                Common.Alert("请输入正确的链接。", this);
            }
        }
    }


    private void loadData(Int32 newsid)
    {
        try
        {
            if (!DB.CheckParams(new object[] { newsid }))
            {
                return;
            }

            String sql = "SELECT a.*,b.typename FROM news_info a LEFT JOIN news_type b ON a.typeid=b.typeid WHERE newsid=@0";
            DataTable news = DB.GetDataSet(sql, newsid).Tables[0];

            if (news.Rows.Count > 0)
            {
                DataRow row = news.Rows[0];
                lblTitle.Text = Convert.ToString(row["title"]);
                lblContent.Text = Convert.ToString(row["Content"]);

            }

        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }
}
