﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class wh_jobinfo : System.Web.UI.Page
{
    private const String UNLIMITED = "不限";
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            

            if (Request.QueryString["type"] != null)
            {
                string Type = Request.QueryString["type"].ToString();
                Int32 iType;
                bool b = int.TryParse(Type, out iType);
                if (b)
                {
                    if (iType == 2)
                    {
                        btnApplicate.Visible = false;
                        btnResume.Visible = false;
                    }
                    else
                    {
                        Common.Alert("请输入正确的链接。", this);
                        return;
                    }
                }
            }
            if ( Request.QueryString["jobid"] != null )
            {
                string JobID = Request.QueryString["jobid"].ToString();
                Int32 iJobID;
                bool c = int.TryParse(JobID, out iJobID);
                if (c)
                {
                    loadData(iJobID);
                    txtJobId.Value = JobID;
                }
                else
                {
                    Common.Alert("请输入正确的链接。", this);
                    return;
                }
            }
        }
    }

    private void loadData(Int32 jobId)
    {
        //*防止SQL注入
        //if (!DB.CheckParams(new object[] { jobId }))
        //{
        //    Response.Redirect("ErrorSQLZR.aspx");
        //    return;
        //}

        try
        {
            String sql = String.Empty;
            sql = "SELECT b.comid,b.JobType, b.JobName, a.CompanyName, CONVERT(DECIMAL(10,2),b.Salary) salary, c.DeptName, b.Number," +
                  "CONVERT(VARCHAR(10), b.LastUpdate_Date,121) lastUpdate_Date,  " +
                  "CONVERT(VARCHAR(10), b.enddate,121) endDate, b.Work_City, b.Current_City, " +
                  "b.Education, b.Work_Years, b.Age_Min ,b.age_Max , b.Sex, " +
                  "b.Contact_Person, b.Contact_phone, b.Contact_fax, b.zipcode, b.Contact_Email, " +
                  "b.address, b.required, a.Memo,b.Contact_Phone_IsShow,b.Contact_Email_IsShow " +
                  "FROM company_base a INNER JOIN jobs b ON a.ComID = b.ComID " +
                  "LEFT OUTER JOIN company_dept c ON b.DeptID = c.DeptID " +
                  "WHERE b.jobid=@0";
            DataTable job = DB.GetDataSet(sql, jobId).Tables[0];
            if (job.Rows.Count > 0)
            {
                DataRow row = job.Rows[0];
                lblCompany.Text = row["CompanyName"].ToString();
                lblJobType.Text = getJobType(row["jobtype"].ToString());
                lblJobName.Text = row["jobName"].ToString();
                lblSalary.Text = Convert.ToInt32(row["salary"]) == 0 ? "面议" : row["salary"].ToString();
                lblGender.Text = getGender(row["sex"].ToString());
                lblDepartment.Text = row["deptname"].ToString();
                lblNumber.Text = row["number"].ToString() == "0" ? lblNumber.Text = UNLIMITED : row["Number"].ToString() + "人";
                lblPublishDate.Text = row["lastUpdate_Date"].ToString();
                lblEndDate.Text = row["endDate"].ToString();
                lblWorkCity.Text = row["work_city"].ToString();
                lblCurrentCity.Text = row["current_city"].ToString();
                lblEducation.Text = row["education"].ToString();
                lblWorkYears.Text = row["work_years"].ToString() == "0" ? UNLIMITED : row["work_years"].ToString();
                lblAges.Text = row["Age_Min"].ToString() + row["Age_Max"].ToString() == "00" ? UNLIMITED : row["Age_Min"].ToString() + " - " + row["Age_Max"].ToString();
                lblContactPerson.Text = row["Contact_person"].ToString();
                if (row["Contact_Phone_IsShow"].ToString() == "1")
                    lblContactPhone.Text = row["contact_phone"].ToString();
                lblFax.Text = row["contact_fax"].ToString();
                lblZipCode.Text = row["zipcode"].ToString();
                if (row["Contact_Phone_IsShow"].ToString() == "1")
                    lblEmail.Text = row["Contact_Email_IsShow"].ToString();
                lblAddress.Text = row["address"].ToString();
                lblRequired.Text = row["required"].ToString().Replace("\r\n", "</br>");
                lblMemo.Text = row["memo"].ToString().Replace("\r\n", "</br>");
                txtComId.Value = row["comid"].ToString();

                sql = "UPDATE company_base SET view_clicks=view_clicks+1 WHERE comid=@0";
                sql += ";UPDATE jobs SET viewclicks=viewclicks+1 WHERE jobid=@1" ;
                object[] parameters = new object[] { txtComId.Value, jobId };
                DB.ExecuteSQL(sql,parameters);
            }
            else
            {
                Response.Write("没有符合条件的职位信息！");
                Response.End();
            }
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    private String getGender(String sex)
    {
        String gender = "";
        switch (sex)
        {
            case "0":
                gender = "女";
                break;
            case "1":
                gender = "男";
                break;
            case "2":
                gender = UNLIMITED;
                break;
        }
        return gender;
    }


    private String getJobType(String type)
    {
        String jobType = "";
        switch (type)
        {
            case "0":
                jobType = "全职";
                break;
            case "1":
                jobType = "兼职";
                break;
            case "2":
                jobType = UNLIMITED;
                break;
        }
        return jobType;
    }




    protected void btnResume_Click(object sender, ImageClickEventArgs e)
    {
        Response.Redirect("personbasic.aspx");
    }



    protected void btnApplicate_Click(object sender, ImageClickEventArgs e)
    {
        try
        {
            if (Session["perid"] != null)
                txtPerId.Value = Session["perid"].ToString();
            else
                Response.Write("<script>alert('请登录后再发送求职申请！');location.href = 'index.aspx';</script>");

            String perid = txtPerId.Value;
            String jobid = txtJobId.Value;
            String comid = txtComId.Value;
            String title = "应聘：" + lblJobName.Text;

            //*防止SQL注入
            //if (!DB.CheckParams(new object[] { perid, comid, jobid, title }))
            //{
            //    Response.Redirect("ErrorSQLZR.aspx");
            //    return;
            //}

            String sql = "SELECT id FROM company_inbox WHERE perid=@0 AND jobid=@1";
            object[] parameters = new object[] { perid, jobid };
            DataTable inbox = DB.GetDataSet(sql, parameters).Tables[0];

            if (inbox.Rows.Count <= 0)
            {
                sql = "INSERT INTO company_inbox(perid,comid,jobid,apply_date,title,content,isread) " +
                             "VALUES(@0,@1,@2,GETDATE(),@3,@3,0)";
                object[] param1 = new object[]{perid, comid, jobid, title};
                sql += ";INSERT INTO personal_outbox(perid,comid,jobid,adddate,title,content,issend) " +
                             "VALUES(@0,@1,@2,GETDATE(),@3,@3,1)";
                sql += ";UPDATE jobs SET sendclicks=sendclicks+1 WHERE jobid=@2";
                DB.ExecuteSQL(sql, param1);
            }
            Common.Alert("发送求职申请成功！", this);
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }
    protected void btnAddFavorite_Click(object sender, EventArgs e)
    {
        try
        {
            String perid = Session["perid"].ToString();
            String jobid = txtJobId.Value;
            String comid = txtComId.Value;
            String title = "应聘：" + lblJobName.Text;

            //*防止SQL注入
            //if (!DB.CheckParams(new object[] { perid, comid, jobid, title }))
            //{
            //    Response.Redirect("ErrorSQLZR.aspx");
            //    return;
            //}

            String sql = "SELECT id FROM personal_favorites WHERE perid=@0 AND jobid=@1";
            object[] parameters = new object[] { perid, jobid };
            DataTable favorite = DB.GetDataSet(sql, parameters).Tables[0];

            if (favorite.Rows.Count <= 0)
            {
                sql = "INSERT INTO personal_favorites(perid,comid,jobid,adddate) " +
                             "VALUES(@0,@1,@2,GETDATE())";
                object[] param1 = new object[] { perid, comid, jobid };
                DB.ExecuteSQL(sql, param1);
            }
            Common.Alert("该职位已添加到你的收藏夹！", this);
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }
}
