﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class wh_jobmanage : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Session["comid"] == null)
            Response.Write("<script>alert('请登录再查找信息，谢谢！');location.href = 'index.aspx';</script>");
        if (!IsPostBack)
        {
            loadData();
        }
    }


    protected void btnLogout_Click(object sender, EventArgs e)
    {
        String region = "";
        if (Session["region"] != null)
            region = Session["region"].ToString();
        Session.Clear();
        if (region.Equals("五华"))
            Response.Redirect("index.aspx");
        else
            Response.Redirect("index.aspx");
    }

    private void loadData()
    {
        String comid = Session["comid"].ToString();
        String sql = "SELECT JobId, JobName, ViewClicks, SendClicks, CONVERT(VARCHAR(10), EndDate, 121) " +
                        "AS enddate, CASE isactive WHEN 1 THEN '招聘中' ELSE '已屏蔽' END status " +
                        "FROM jobs WHERE ComID = @0 ORDER BY lastupdate_date DESC";

        DataTable job = DB.GetDataSet(sql, comid).Tables[0];

        grdJobs.DataSource = job;
        grdJobs.DataBind();
    }

    protected void btnDisable_Click(object sender, EventArgs e)
    {
        String sql = "UPDATE jobs SET isActive=0 WHERE jobid IN ({0})";
        handleData(sql);
    }

    protected void btnEnabled_Click(object sender, EventArgs e)
    {
        String sql = "UPDATE jobs SET isActive=1 WHERE jobid IN ({0})";
        handleData(sql);
    }



    protected void grdJobs_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        String jobid = ((Label)grdJobs.Rows[e.RowIndex].FindControl("lblJobId")).Text;
        DeleteItem(jobid);
    }

    private void DeleteItem(String jobid)
    {
        try
        {
            String sql = "DELETE FROM jobs WHERE jobid=@0";
            DB.ExecuteSQL(sql,jobid);
            loadData();
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }




    protected void btnDelete_Click(object sender, EventArgs e)
    {
        String sql = "DELETE FROM jobs WHERE jobid IN ({0})";
        handleData(sql);
    }

    private void handleData(String sql)
    {
        String comid = Session["comid"].ToString();
        CheckBox chkSelect;
        int index = 0;
        String Id = "";
        ArrayList paramList = new ArrayList();

        try
        {
            for (int i = 0; i < grdJobs.Rows.Count; i++)
            {
                chkSelect = (CheckBox)grdJobs.Rows[i].FindControl("chkSelect");
                if (chkSelect.Checked)
                {
                    Id +=  string.Format("@{0},",index);
                    paramList.Add(((Label)grdJobs.Rows[i].FindControl("lblJobId")).Text);
                    index++;
                }
            }
            if (index > 0)
            {
                Id = Id.Substring(0, Id.Length - 1);
                String command = String.Format(sql, Id);
                DB.ExecuteSQL(command, paramList);

                loadData();
            }
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
        }
    }

}
