﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class wh_p_person : System.Web.UI.Page
{
    private const string CON_COMPLETE = "已填写";
    private const string CON_UNCOMPLETE = "未填写";

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["perid"] != null)
            {
                InitInformation();
                saveLoginInfo();
            }
            else
            {
                Response.Redirect("index.aspx");
                return;
            }

        }
    }

    private void InitInformation()
    {
        String perId = Session["perid"].ToString();
        String sql = String.Empty;
        sql = "SELECT realname,lastLogin_date,login_count,lastupdate_date FROM personal_info a INNER JOIN " +
                            "personal_base b ON a.PerID = b.PerID where a.perid=@0;";
        sql += "SELECT COUNT(perid) Mailcnt FROM personal_inbox WHERE perid=@0;";
        sql += "SELECT COUNT(perid) NewMailcnt FROM personal_inbox WHERE perid=@0 AND isread=0;";
        sql += "SELECT COUNT(perid) Favoratescnt FROM personal_favorites WHERE perid=@0;";
        sql += "SELECT COUNT(perid) outBoxcnt FROM personal_outbox WHERE perid=@0;";
        sql += "SELECT COUNT(perid) Educationcnt FROM personal_education WHERE perid=@0;";
        sql += "SELECT COUNT(perid) Workcnt FROM personal_workexperience WHERE perid=@0;";
        sql += "SELECT COUNT(perid) Skillcnt FROM personal_skill WHERE perid=@0;";
        sql += "SELECT COUNT(perid) Willcnt FROM personal_will WHERE perid=@0;";
        DataSet person = DB.GetDataSet(sql,perId);
        if (person.Tables.Count > 0)
        {
            lblUserName.Text = person.Tables[0].Rows[0]["realname"].ToString();
            lblLastTime.Text = person.Tables[0].Rows[0]["lastLogin_date"].ToString();
            lblLoginCount.Text = person.Tables[0].Rows[0]["login_count"].ToString();
            lblUpdateTime.Text = person.Tables[0].Rows[0]["lastupdate_date"].ToString();
            lblMail.Text = person.Tables[1].Rows[0]["Mailcnt"].ToString();
            lblNewMail.Text = person.Tables[2].Rows[0]["NewMailcnt"].ToString();
            lblFavorate.Text = person.Tables[3].Rows[0]["Favoratescnt"].ToString();
            lblOutBox.Text = person.Tables[4].Rows[0]["outBoxcnt"].ToString();
            lblBasic.Text = CON_COMPLETE;
            if (person.Tables[5].Rows[0]["Educationcnt"].ToString() == "0")
                lblEducation.Text = CON_UNCOMPLETE;
            else
                lblEducation.Text = CON_COMPLETE;

            if (person.Tables[6].Rows[0]["Workcnt"].ToString() == "0")
                lblExperience.Text = CON_UNCOMPLETE;
            else
                lblExperience.Text = CON_COMPLETE;

            if (person.Tables[7].Rows[0]["Skillcnt"].ToString() == "0")
                lblAdditional.Text = CON_UNCOMPLETE;
            else
                lblAdditional.Text = CON_COMPLETE;

            if (person.Tables[8].Rows[0]["Willcnt"].ToString() == "0")
                lblWish.Text = CON_UNCOMPLETE;
            else
                lblWish.Text = CON_COMPLETE;

        }

    }

    private void saveLoginInfo()
    {
        String perId = Session["perid"].ToString();
        String sql = "UPDATE personal_base SET lastlogin_ip=@0,lastlogin_date=GETDATE(),login_count=login_count+1 " +
                          "WHERE perid=@1"; 
        object[] parameters = new object[] { Request.ServerVariables.Get("REMOTE_ADDR").ToString(), perId};
        DB.ExecuteSQL(sql, parameters);

    }
}

