﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class wh_tranning : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {


        string sNewsID = Request.QueryString["newsid"] + "";
        Int32 iNewsID;


        if (sNewsID == "")
        {
            LoadData();
            loadDatalist();
        }
        else
        {
            bool b = int.TryParse(sNewsID, out iNewsID);
            if (!b)
            {
                Common.Alert("请输入正确的链接。", this);
                return;
            }
            else
            {
                loadData(iNewsID);
                LoadData();
            }
        }
        
    }

    public void LoadData()
    {
        try
        {
            //培训管理发布
            String sql = "SELECT TOP 36 NewsID, Title, Author, AddDate FROM news_info left join News_Type on News_Type.TypeID = news_info.TypeID " +
                   "WHERE IsActive = 1 AND IsVerified = 1 AND News_Type.TYPEid=2 ORDER BY news_info.newsid DESC";

           
            DataSet dataset = DB.GetDataSet(sql);

            lstTrain.DataSource = dataset.Tables[0].DefaultView;
            lstTrain.DataBind();

    
           
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }


    private void loadData(Int32 newsid)
    {
        try
        {
            ////*防止SQL注入
            //if (!DB.CheckParams(new object[] { newsid }))
            //{
            //    return;
            //}

            String sql = "SELECT a.*,b.typename FROM news_info a LEFT JOIN news_type b ON a.typeid=b.typeid WHERE newsid = @0";
            DataTable news = DB.GetDataSet(sql,newsid).Tables[0];

            if (news.Rows.Count > 0)
            {
                DataRow row = news.Rows[0];
                lblTitle.Text = Convert.ToString(row["title"]);
                lblContent.Text = Convert.ToString(row["Content"]).Replace("\r\n", "<BR>");
              
                lblAuthor.Text = Convert.ToString(row["author"]);
                lblAddDate.Text = Convert.ToString(row["adddate"]);
            }

        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }


    private void loadDatalist()
    {
        try
        {
            
            String sql = "SELECT top 1 a.*,b.typename FROM news_info a LEFT JOIN news_type b ON a.typeid=b.typeid ";
            DataTable news = DB.GetDataSet(sql).Tables[0];

            if (news.Rows.Count > 0)
            {
                DataRow row = news.Rows[0];
                lblTitle.Text = Convert.ToString(row["title"]);
                lblContent.Text = Convert.ToString(row["Content"]).Replace("\r\n", "<BR>");

                lblAuthor.Text = Convert.ToString(row["author"]);
                lblAddDate.Text = Convert.ToString(row["adddate"]);
            }

        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }


    protected string Left(object s, int length)
    {
        try
        {
            string ret;

            if (s.ToString().Trim() == "")
                return "---";
            if (s.ToString().Length > length)
            {
                ret = s.ToString();
                ret = ret.Substring(0, length) + "...";
            }
            else
            {
                return s.ToString();
            }
            return ret;
        }
        catch (Exception ex)
        {
            throw ex;
        }
    }
}
