﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class wh_zixun_view : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {

        string sNewsID = Request.QueryString["newsid"] + "";
        Int32 iNewsID;


        if (sNewsID == "")
        {
            Response.Write("没有相关数据");
        }
        else
        {
            bool b = int.TryParse(sNewsID, out iNewsID);
            if (!b)
            {
                Common.Alert("请输入正确的链接。", this);
                return;
            }
            else
            {
                loadData(iNewsID);
            }
        }
    }

   
    private void loadData(Int32 newsid)
    {
        try
        {
            String sql = "SELECT a.*,b.typename FROM news_info a LEFT JOIN news_type b ON a.typeid=b.typeid WHERE newsid=@0" ;
            object[] parameters = new object[1];
            parameters[0] = newsid;
            DataTable news = DB.GetDataSet(sql, parameters).Tables[0];

            if (news.Rows.Count > 0)
            {
                DataRow row = news.Rows[0];
                lblTitle.Text = Convert.ToString(row["title"]);
                lblContent.Text = Convert.ToString(row["Content"]);

            }

        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }
}