﻿<%@ Page Title="发布新闻" Language="C#" MasterPageFile="~/Masters/Sys.Master" AutoEventWireup="true" CodeBehind="Add.aspx.cs" Inherits="yueyaCMS.Admin.News.Add" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server"></asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
 <ul class="breadcrumb">
<li><i class="icon-tags"></i> 您当前的位置：<a href="/Admin/Site/Default.aspx">系统首页</a></li>
<li><span class="divider">/</span> <a href="/Admin/News/Default.aspx">新闻列表</a></li>
<li><span class="divider">/</span> 发布新闻</li>
</ul>

<form id="form1" runat="server">
<table width="100%" align="center" class="table table-bordered">

<%if(!String.IsNullOrEmpty(errorMsg)){ %>
<tr>
<th>
<div class="alert alert-error">
<p><%=errorMsg %></p>
</div>
</th>
</tr>
<%} %>

<tr>
<td>
<div class="input-prepend">
<span class="add-on"><i class="icon-home"></i> 新闻标题</span><asp:TextBox ID="PTitle" runat="server" required CssClass="friendtip" ToolTip="50个字以内。" Width="580px" onblur="GetKeyWords(this);" />
</div>
</td>
</tr>

<tr>
<td>
<div class="input-prepend">
<span class="add-on"><i class="icon-picture"></i> 新闻图片&nbsp;&nbsp;<font style="font-size:12px;">主图要求为不小于380px*380px的正方形图片，推荐上传600px*600px以上的清晰白底图片。</font></span></div>
<ul id="Pics" class="Pics">
    <li>
        <img width="58" height="58" src="/Images/appendImg.jpg" onclick="selectProductPic()" />
        <a class="addImg" href="javascript:AddPic()">+&nbsp;添加</a>
    </li>
</ul>
<asp:HiddenField ID="HiddenField1" runat="server" />
</td>
</tr>

<tr>
<td>
    <div class="input-prepend input-append">
                        <span class="add-on friendtip" title="支持多选。"><i class="icon-list-alt"></i> 新闻分类</span>
                        <a st="0" onclick="expandAll(this);" class="btn btn-success friendtip" href="javascript:void(0)" title="展开或关闭全部节点">展开</a>
                        <a class="btn btn-success friendtip" href="Types.aspx" target="_blank" title="跳转到新闻分类管理页。">管理</a>
                        </div>

    <ul id="TypeIDs" class="ztree" style="margin-top:0; width:180px;"></ul></td>
</tr>


<tr>
    <td>
<div class="input-prepend">
<span class="add-on"><i class="icon-text-height"></i> 
关键字
</span>
<asp:TextBox ID="KeyWrods" runat="server" Width="580px" required ToolTip="多个关键字用，分割。" CssClass="friendtip" />
    </div>
</td>
</tr>

<tr>
<td>
<asp:TextBox ID="Summary" Width="650px" runat="server" TextMode="MultiLine" required ToolTip="200个字以内。" CssClass="friendtip" />
</td>
</tr>


<tr>
<td>
<asp:TextBox ID="Info" runat="server" TextMode="MultiLine" style="width:700px; height:400px;" />
</td>
</tr>
<tr>
        <td><div class="input-prepend">
<span class="add-on"><i class="icon-map-marker"></i> 显示位置</span>
             <asp:TextBox ID="ShowIndex" runat="server" Text="-1" required ToolTip="-1代表根据默认显示顺序。" CssClass="friendtip" />
            </div>
            </td>
    </tr>
<tr>
        <td><div class="input-prepend">
<span class="add-on"><i class="icon-eye-open"></i> 显示新闻&nbsp;<asp:CheckBox ID="OnSale" runat="server" Checked="true"  />
         </span></div></td>
    </tr>
</table>
<div class="form-actions">
<asp:Button ID="subBtn" runat="server" Text="添加新闻" OnClientClick="return InitTypes();" CssClass="btn btn-primary btn-large" onclick="subBtn_Click" />
       <asp:HiddenField ID="ServerTypeIDs" runat="server" />
</div>

<link href="/Plugins/ZTree/zTreeStyle.css" rel="stylesheet" type="text/css" />
<script src="/Plugins/ZTree/jquery.ztree.all-3.5.min.js" type="text/javascript"></script>
<script src="/Plugins/ueditor/ueditor.config.js"></script>
<script src="/Plugins/ueditor/ueditor.all.min.js"></script>
<script src="/Scripts/yycms_upload.js"></script>
<script type="text/javascript">
    var setting = { check: { enable: true, chkboxType: { "Y": "ps", "N": "ps" } }, data: { simpleData: { enable: true } } }, TypeIDsTree = null;

    /*树形菜单初始化*/
    function InitZNodes(nodes, eleId) {
        var nodeArr = new Array(), ExID = 9999;
        for (var i = 0; i < nodes.length; i++) {
            nodeArr.push({ id: nodes[i].ID, pId: nodes[i].PID, name: nodes[i].Name, open: false, nocheck: false });
        }
        return $.fn.zTree.init($(eleId), setting, nodeArr);
    }
    /*获取分类树*/
    function GetTypeTree(pageIndex) {
        API.News_Type_Get(function (result) {
            TypeIDsTree = InitZNodes(result.dbList, "#TypeIDs");
        }, "{pageIndex:0,showLength:9999}");
    }

    /*收缩展开分类*/
    function expandAll(_ele) {
        if ($(_ele).attr("st") == "0") {
            TypeIDsTree.expandAll(true);
            $(_ele).attr("st", "1");
            $(_ele).text("收起");
        }
        else {
            TypeIDsTree.expandAll(false);
            $(_ele).attr("st", "0");
            $(_ele).text("展开");
        }
    }

    function InitTypes() {
        var TypeIDs = new Array();
        var ckdNodes = TypeIDsTree.getCheckedNodes(true);
        for (var i = 0; i < ckdNodes.length; i++) {
            if (ckdNodes[i].isParent) { continue; }
            TypeIDs.push(ckdNodes[i].id);
        }
        if (TypeIDs.length < 1) { alert("请选择新闻分类！"); return false; }
        $("#<%=ServerTypeIDs.ClientID %>").val(TypeIDs.join(","));

        var ImgIsOK = GlobalImgList_Check("<%=HiddenField1.ClientID %>");
        if (ImgIsOK != "") { alert(ImgIsOK); return false; }

        if (!confirm("是否确认提交？")) { return false; }

        return true;
    }

 
    var editor = null;
    $(function () {
        editor = new UE.ui.Editor();
        editor.render("<%=Info.ClientID %>");
        GetTypeTree(0);
        yycms_upload_Init();
        $(".friendtip").qtip({ position: { my: 'left center', at: 'right center' } });
    });

    function GetKeyWords(_input) {
        if ($(_input).val() == "") { return; }

        var iptString = $(_input).val();

        if (iptString.length > 7 && iptString.toLowerCase().substring(0, 7) == "http://") {
            ShowTip("<img src='/Images/s1.gif' />&nbsp;正在努力抓取内容，请您稍等：）", "自动抓取内容");
            API.Request_Content(function (r) {
                if (r != "") {
                    $("#<%=PTitle.ClientID %>").val(r.Title);
                    $("#<%=KeyWrods.ClientID %>").val(r.Keywords);
                    $("#<%=Summary.ClientID %>").val(r.Desc);
                    editor.setContent(r.Content);
                    if (r.Keywords == "")
                    {
                        API.Keywords_Get(function (r) { $("#<%=KeyWrods.ClientID%>").val(r); }, "{_Input:\"" + $(_input).val() + "\"}");
                    }
                    ShowTip("抓取内容完成：）");
                }
            }, "{RequestUrl:\"" + $(_input).val() + "\"}");
        }
        else {
            API.Keywords_Get(function (r) { $("#<%=KeyWrods.ClientID%>").val(r); }, "{_Input:\"" + $(_input).val() + "\"}");
        }
    }

    </script>
</form>
</asp:Content>
