﻿<%@ Page Title="添加模板" Language="C#" MasterPageFile="~/Masters/Sys.Master" AutoEventWireup="true" CodeBehind="Add.aspx.cs" Inherits="yueyaCMS.Admin.Page.Add" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
<link href="/Plugins/Select2/select2.css" rel="stylesheet" />
<script src="/Plugins/Select2/select2.min.js"></script>
<script src="/Plugins/Select2/select2_locale_zh-CN.js"></script>
<style type="text/css">
    #PageTypes,#PageName,#PageCodeHelp,#PageSummary{ margin-bottom:0px;}
    #PageTypes,#PageCodeHelp,#PageSummary { width:450px;}
</style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
 <ul class="breadcrumb">
<li><i class="icon-tags"></i> 您当前的位置：<a href="/Admin/Site/Default.aspx">系统首页</a></li>
<li><span class="divider">/</span> <a href="/Admin/Page/Default.aspx">模板列表</a></li>
<li><span class="divider">/</span> 添加模板</li>
</ul>

<p>所属分类：<select id="PageTypes"></select></p>
<p>模版名称：<input id="PageName" type="text" size="50" placeholder="请输入模板名称…" required /></p>
<p>模版类型：<select id="PageKinds"></select></p>
<p>抓取源码：<input id="PageCodeHelp" type="text" style="width:370px;" placeholder="请输入网址…" onkeypress="if(event.keyCode==13){RequestUrl();}" />&nbsp;&nbsp;<a href="#" class="btn btn-success" onclick="RequestUrl();">抓取</a>&nbsp;&nbsp;<a href="javascript:;" class="btn btn-warning" onclick="showPreview();">预览页面</a>
</p>
<pre id="editor" style=" margin: 0;min-height:600px;">
&lt;!DOCTYPE html&gt;
&lt;html lang=&quot;cn&quot;&gt;
&lt;head&gt;
&lt;meta charset=&quot;utf-8&quot; /&gt;
&lt;title&gt;&lt;/title&gt;
&lt;meta name=&quot;keywords&quot; content=&quot;&quot; /&gt;
&lt;meta name=&quot;description&quot; content=&quot;&quot; /&gt;
&lt;meta name=&quot;copyright&quot; content=&quot;&quot; /&gt;
&lt;link rel=&quot;icon&quot; href=&quot;/favicon.ico&quot; type=&quot;image/x-icon&quot; /&gt;
&lt;/head&gt;
&lt;body&gt;

&lt;/body&gt;
&lt;/html&gt;
</pre>
<hr />
<p><label>支持生成： <input id="CanBuild" type="checkbox" checked="checked" /> 当前模板是否集成到一键生成</label></p>
<p>生成路径：<input id="SavePath" type="text" size="50" placeholder="请输入生成路径…" value="~/" required /> "~/"代表网站根目录,结尾无需带"/"</p>
<p>名称规则：<input id="ExtensionName" type="text" size="70" placeholder="可在{PageName}左右添加自定义字符..." value="{0}.html" required /> 可在{0}左右添加自定义字符。{0}当前ID，{1}当前时间，{2}当前索引,{3}DataID。</p>
<p><textarea type="text" id="PageSummary" placeholder="模板描述、备注等信息"></textarea></p>
<div class="form-actions">
<a href="#" onclick="AddPage();" class="btn btn-warning btn-large">确认提交</a>
</div>

<script src="/Plugins/ace/ace.js" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript">

 
    var editor = ace.edit("editor");
    editor.setTheme("ace/theme/dreamweaver");
    editor.getSession().setMode("ace/mode/html");

    $(function ()
    {
        API.Page_Type_Get(function (result) {
            var PageTypes_Temp = '{@each dbList as d,index}<option value="${d.ID}" >${d.Name}</option>{@/each}';
            $("#PageTypes").html(juicer(PageTypes_Temp, { dbList: result.dbList })).select2();
        }, "{pageIndex:0,showLength:9999}");

        $("#PageKinds").empty();
        for (var i = 0; i < PageKindList.length; i++)
        { $("#PageKinds").append("<option value='" + i + "'>" + PageKindList[i] + "</option>"); }
        $("#PageKinds").select2();
    });  

    function AddPage()
    {
        var PageName = $("#PageName").val();
        if (PageName == "") { alert("模板名称不得为空。"); return false; }

        var TypeID = $("#PageTypes option:selected").val();
        var PageKind = $("#PageKinds option:selected").val();

        var PageCode = encodeURIComponent(editor.getValue());
        if (PageCode == "") { alert("模板代码不得为空。"); return false; }
        
        var PageSummary = $("#PageSummary").val();

        var SavePath = $("#SavePath").val();
        if (SavePath == "") { alert("生成路径不得为空。"); return false; }

        var ExtensionName = $("#ExtensionName").val();
        if (ExtensionName == "") { alert("名称规则不得为空。"); return false; }

        var CanBuild = $("#CanBuild").attr("checked") == "checked" ? 1 : 0;

        var RequestEntity = "{" +
            "_TypeID:" + TypeID + "," +
            "_PageKind:" + PageKind + "," +
            "_PageName:\"" + PageName + "\"," +
            "_PageCode:\"" + PageCode + "\"," +
            "_Summary:\"" + PageSummary + "\"," +
            "_SavePath:\"" + SavePath + "\"," +
            "_CanBuild:" + CanBuild+","+
            "_ExtensionName:\"" + ExtensionName + "\"" +
          "}";

        API.Page_Add(function (r) {
            if (r == "1") {
                alert("添加成功！");
                window.location.href = "Default.aspx";
            }
            else { alert(r); }
        },RequestEntity);
    }

    /*下载制定网页源码*/
    function RequestUrl() 
    {
        var PageCodeHelp=encodeURI($("#PageCodeHelp").val());
        API.Request(function (r) {
            editor.setValue(r);
        }, '{RequestUrl:\"'+PageCodeHelp+'\"}');
    }

    function showPreview() {
        var b = editor.getValue();
        var a = "<html><head><title></title></head><body>" + b + "</body></html>",
        b = window.screen,
        b = window.open("", "xhePreview", "toolbar=yes,location=no,status=yes,menubar=yes,scrollbars=yes,resizable=yes,width=" + Math.round(0.9 * b.width) + ",height=" + Math.round(0.8 * b.height) + ",left=" + Math.round(0.05 * b.width)),
        e = b.document;
        e.open();
        e.write(a);
        e.close();
        b.focus();
    }
   </script>
</asp:Content>