﻿<%@ Page Title="模板风格" Language="C#" MasterPageFile="~/Masters/Sys.Master" AutoEventWireup="true" CodeBehind="Types.aspx.cs" Inherits="yueyaCMS.Admin.Page.Types" %>
<%@ Import Namespace="System.Linq" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
<style type="text/css">
.ztree li span.button.add {margin-left:2px; margin-right: -1px; background-position:-144px 0; vertical-align:top; *vertical-align:middle}
</style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
 <ul class="breadcrumb">
<li><i class="icon-tags"></i> 您当前的位置：<a href="/Admin/Site/Default.aspx">系统首页</a></li>
<li><span class="divider">/</span> 模板风格</li>
</ul>

<div style="margin-bottom:10px">
        <div class="input-prepend input-append">
        <a href="Types.aspx" class="btn btn-warning">查看全部</a>
        <input type="text" id="SkinName" onkeypress="if(event.keyCode==13){addType();}" class="friendtip"  title="添加一个新的模板。" required /> 
        <a class="btn btn-success" onclick="AddSkin();">添加</a>
        <a href="javascript:;" onclick="showUpload();" title="导入设计好的模板安装包。" class="btn btn-success friendtip">导入</a>
</div>
            
 </div>
    <form id="Form__1" runat="server" style="display:none;">
    <asp:FileUpload ID="FileUpload1" runat="server" style="" onchange="AddSkinPack();" />
        </form>

<table id="PageTable" class="table table-bordered table-hover">
<thead>
<tr>
<th>编号</th>
<th>风格名称</th>
<th>当前版本</th>
<th>模板数量</th>
<th>创建时间</th>
<th>操作</th>
</tr>
</thead>
<tbody>
</tbody>
</table>

<script type="text/javascript">
    /*获取模板风格列表*/
    function GetSkin(pageIndex)
    {
        API.Page_Type_Get(function (result)
        {
            var PageTypes_Temp = '{@each dbList as d,index}<tr><td>${++index}</td><td><a href="Default.aspx?t=${d.ID}">${d.Name}</a></td><td>${d.Version}</td><td>${d.MasterCount}</td><td>${d.CreateDate|DateFormat}</td><td><a href="Default.aspx?t=${d.ID}" class="btn btn-mini">详细</a>&nbsp;&nbsp;<a href="#" class="btn btn-mini" onclick="RemoveSkin(${d.ID})">删除</a></td></tr>{@/each}';
            $("#PageTable tbody").html(juicer(PageTypes_Temp, { dbList: result.dbList }));
        }, "{pageIndex:0,showLength:9999}");
    }

    $(function ()
    {
        GetSkin(0);
        $(".friendtip").qtip({ position: { my: 'left center', at: 'right center' } });
    });

    /*删除风格*/
    function RemoveSkin(_SkinId) {
        if (!confirm("是否确认删除？")) { return false; }
        API.Page_Type_Delete(function (r) { if (r != "1") { alert(r); GetSkin(0); } }, "{typeID:" + _SkinId + "}");
    }


    /*添加风格*/
    function AddSkin() {
        var SkinName = $("#SkinName").val();
        if (SkinName == "" || SkinName.length < 1 || SkinName.length > 20) { ShowTip("名称不能为空。");  return; }
        if (!confirm("是否确认添加？")) { return; }
        API.Page_Type_Add(function (r) {
            if (r != "0") { GetSkin(0); }
        }, "{_Version:0,_Name:\"" + SkinName + "\"}");
    }

    /*选择模板包*/
    function showUpload()
    {
        $("#<%=FileUpload1.ClientID%>").click();
    }

    /*导入模板包*/
    function AddSkinPack()
    {
        if (!confirm("是否确认提交？")) { return; }
        $("#<%=Form__1.ClientID%>").submit();
    }
	</script>
</asp:Content>