﻿<%@ Page Title="产品列表" Language="C#" MasterPageFile="~/Masters/Sys.Master" AutoEventWireup="true" CodeBehind="Default.aspx.cs" Inherits="yueyaCMS.Admin.Product.Default" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <ul class="breadcrumb">
<li><i class="icon-tags"></i> 您当前的位置：<a href="/Admin/Site/Default.aspx">系统首页</a></li>
<li><span class="divider">/</span> <span>产品列表</span></li>
</ul>

<form  runat="server" id="from_1">
<div style="margin-bottom:10px;">
    <div class="btn-group">
    <a class="btn btn-warning" href="Default.aspx">查看全部</a>
    <button class="btn dropdown-toggle  btn-warning" data-toggle="dropdown">
    <span class="caret"></span>
    </button>
    <ul class="dropdown-menu">
     <%=PctTypes.ToString() %>
    </ul>
    </div>      
        &nbsp;
        <a href="Add.aspx" class="btn btn-success">添加产品</a>
    </div>

    <table id="dataTable" class="table table-bordered table-hover" style="margin-bottom:0px;">
        <thead>
            <tr>
                <th width="60px"><label><b>编号</b> <input id="ckAll" type="checkbox" /></label></th>
                <th>产品名称</th>
                <th width="70px">金额</th>
                <th width="70px">是否显示</th>
                <th width="150px">发布时间</th>
                <th width="150px">
                    <ul class="nav" style="margin-bottom:0px;">
                    <li class="dropdown"><a href="#" class="dropdown-toggle" data-toggle="dropdown">批量操作 <i class="caret"></i> </a>
                        <ul class="dropdown-menu">
                            <li><asp:LinkButton ID="LinkButton1" OnClientClick="return DelBySelected();" runat="server" Text="<i class='icon icon-remove icon-right'></i>删除选中" OnClick="Button1_Click1" /></li>
                        </ul>
                    </li>
                    </ul>
                </th>
            </tr>
        </thead>
        <tbody>
            <% Int32 i = 1; foreach (var v in DBList){ %>
            <tr>
                <th><label><%=i %> <input type="checkbox" value="<%=v.ID %>" /></label></th>
                <td><a href="Edit.aspx?id=<%=v.ID %>"><%=v.Title %></a></td>
                <td><%=v.Price %></td>
                <td><%=v.IsShow==0?"<input type='checkbox' disabled />":"<input type='checkbox' disabled checked />" %></td>
                <td><%=v.CreateDate.ToString("yyyy-MM-dd HH:mm:ss") %></td>
                <td>
                    <a href="Edit.aspx?id=<%=v.ID %>" class="btn btn-mini">编辑</a>&nbsp;
                    <a href="Del.aspx?id=<%=v.ID %>" class="btn btn-mini">删除</a>
                </td>
            </tr>
            <% i++;
               } %>
        </tbody>
    </table>
        <asp:HiddenField ID="ProductListIDs" runat="server" />
              <table width="100%">
            <tr><td><div style="float:left;" class="bigPage vm" id="Pagenation"></div></td>
                <td><span style="float:right;">&nbsp;共<%=DataCount %>条数据，当前第<%=PageIndex+1 %>/<%=pageCount%>页。</span></td>
            </tr>
        </table>

<script src="/Scripts/SiteConst.js"></script>
<script type="text/javascript">
        $(function(){
            $("#ckAll").unbind().click(function(){
                var ckd = $(this).attr("checked");
                if(ckd=="checked")
                {
                    $("#dataTable tbody th :checkbox").attr("checked","checked");
                }
                else
                {
                    $("#dataTable tbody th :checkbox").removeAttr("checked");
                }
            });
          });
         
        API.PageBuilder(<%=pageCount%>,<%=PageIndex%>,"#Pagenation", "jumpPage");

        function DelBySelected()
        {
            var ckds=$("#dataTable tbody th :checkbox:checked");
            if(ckds.length<1){ alert("您未选择任何产品，无法提交。");  return false; }
            var ckdIDs=new Array();
            $.each(ckds,function(a,b){ ckdIDs.push($(b).val()); });
            $("#<%=ProductListIDs.ClientID%>").val(ckdIDs.join(","));
            if(!confirm("是否确认提交？")){return false;}
            return true;
        }
    </script>
</form>
</asp:Content>