﻿<%@ Page Title="更新产品" Language="C#" MasterPageFile="~/Masters/Sys.Master" AutoEventWireup="true" CodeBehind="Edit.aspx.cs" Inherits="yueyaCMS.Admin.Product.Edit" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server"></asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
<ul class="breadcrumb">
<li><i class="icon-tags"></i> 您当前的位置：<a href="/Admin/Site/Default.aspx">系统首页</a></li>
<li><span class="divider">/</span> <a href="/Admin/Product/Default.aspx">产品列表</a></li>
<li><span class="divider">/</span> 更新产品</li>
</ul>

<form id="form1" runat="server">
    
<table width="100%" align="center" class="table table-bordered">
    <%if(!String.IsNullOrEmpty(errorMsg)){ %>
<tr>
<th colspan="2">
<div class="alert alert-error">
<p><%=errorMsg %></p>
</div>
</th>
</tr>
<%} %>

<tr>
<td><div class="input-prepend">
<span class="add-on"><i class="icon-home"></i> 产品标题</span><asp:TextBox ID="PTitle" runat="server" Width="580px" onblur="GetKeyWords(this);" required CssClass="friendtip" ToolTip="50个字以内。" /></div></td>
</tr>

<tr>
<td>
<div class="input-prepend">
<span class="add-on"><i class="icon-picture"></i> 产品图片&nbsp;&nbsp;<font style="font-size:12px;">主图要求为不小于380px*380px的正方形图片，推荐上传600px*600px以上的清晰白底图片。</font></span></div>
<ul id="Pics" class="Pics">
<li><img width="58" height="58" src="/Images/appendImg.jpg" onclick="selectProductPic()" /><a class="addImg" href="javascript:AddPic()">+&nbsp;添加</a></li>
</ul>
<asp:HiddenField ID="HiddenField1" runat="server" />
</td>
</tr>

<tr>
<td>
<div class="input-prepend input-append">
<span class="add-on friendtip" title="支持多选。"><i class="icon-list-alt"></i> 产品分类</span>
<a st="1" onclick="expandAll(this);" class="btn btn-success friendtip" href="javascript:void(0)" title="展开或关闭全部节点">收起</a>
<a class="btn btn-success friendtip" href="Types.aspx" target="_blank" title="跳转到产品分类管理页。">管理</a>
</div>
<ul id="TypeIDs" class="ztree" style="margin-top:0; width:180px;"></ul></td>
</tr>

<tr>
<td>
<div class="input-prepend">
<span class="add-on"><i class="icon-shopping-cart"></i> 产品价格</span><asp:TextBox ID="Price" Text="0" Width="50px" runat="server" required />
</div>
</td>
</tr>

<tr>
<td>
<div class="input-prepend">
<span class="add-on"><i class="icon-text-height"></i> 关键字</span><asp:TextBox ID="KeyWords" Width="580px" runat="server" required ToolTip="多个关键字用,分割。" CssClass="friendtip" />
</div>
</td>
</tr>

<tr>
<td>
<asp:TextBox ID="Summary" Width="650px" runat="server" TextMode="MultiLine" required placeholder="200个字以内。" CssClass="friendtip" />
</td>
</tr>

<tr>
<td>
<asp:TextBox ID="Info" runat="server" TextMode="MultiLine" style="width:700px; height:400px;" />
</td>
</tr>

    <tr>
             <td>
        <div class="input-prepend">
<span class="add-on"><i class="icon-map-marker"></i> 显示位置</span><asp:TextBox ID="ShowIndex" runat="server" Text="-1" required ToolTip="-1代表根据默认显示顺序。" CssClass="friendtip" />
            </div></td>
    </tr>
<tr>
        <td><div class="input-prepend">
<span class="add-on"><i class="icon-eye-open"></i> 上架&nbsp;<asp:CheckBox ID="OnSale" runat="server" Checked="true"  /></span>
            </div>
            </td>
    </tr>
</table>
    <div class="form-actions">
    <asp:HiddenField ID="pctid" runat="server" />
<asp:Button ID="subBtn" runat="server" Text="更新产品" CssClass="btn btn-warning btn-large" 
        onclick="subBtn_Click" OnClientClick="return InitTypes();" />
        <asp:HiddenField ID="TypeIDss" runat="server" />
</div>
    </form>

<link href="/Plugins/ZTree/zTreeStyle.css" rel="stylesheet" type="text/css" />
<script src="/Plugins/ZTree/jquery.ztree.all-3.5.min.js" type="text/javascript"></script>
<script src="/Plugins/ueditor/ueditor.config.js"></script>
<script src="/Plugins/ueditor/ueditor.all.min.js"></script>
<script src="/Scripts/yycms_upload.js"></script>
<script type="text/javascript">
    function GetKeyWords(_input) {
        if ($(_input).val() == "") { return; }
        API.Keywords_Get(function (r) {
            $("#<%=KeyWords.ClientID%>").val(r);
        }, "{_Input:\"" + $(_input).val() + "\"}");
    }

    var setting = { check: { enable: true, chkboxType: { "Y": "ps", "N": "ps"} }, data: { simpleData: { enable: true}} }, TypeIDsTree = null;

    /*树形菜单初始化*/
    function InitZNodes(nodes, eleId) {
        var nodeArr = new Array(), ExID = 9999;
        for (var i = 0; i < nodes.length; i++) {
            nodeArr.push({ id: nodes[i].ID, pId: nodes[i].PID, name: nodes[i].Name, open: false, nocheck: false });
        }
        return $.fn.zTree.init($(eleId), setting, nodeArr);
    }

    /*获取分类树*/
    function GetTypeTree(pageIndex) {
        API.Product_Type_Get(function (result) {
            TypeIDsTree = InitZNodes(result.dbList, "#TypeIDs");
            var ckdIds = "<%=TypeIDss.Value %>";
            ckdIds = ckdIds.split(",");
            if (ckdIds.length > 0) {
                for (var i = 0; i < ckdIds.length; i++) {
                    var node = TypeIDsTree.getNodeByParam("id", ckdIds[i], null);
                    if (node == null) { continue; }
                    TypeIDsTree.checkNode(node);
                }
            }
            TypeIDsTree.expandAll(true);
        }, "{pageIndex:0,showLength:9999}");
    }

    /*收缩展开分类*/
    function expandAll(_ele) {
        if ($(_ele).attr("st") == "0") {
            TypeIDsTree.expandAll(true);
            $(_ele).attr("st", "1");
            $(_ele).text("收起");
        }
        else {
            TypeIDsTree.expandAll(false);
            $(_ele).attr("st", "0");
            $(_ele).text("展开");
        }
    }

    function InitTypes() {
        var TypeIDs = new Array();
        var ckdNodes = TypeIDsTree.getCheckedNodes(true);
        for (var i = 0; i < ckdNodes.length; i++) {
            if (ckdNodes[i].isParent) { continue; }
            TypeIDs.push(ckdNodes[i].id);
        }
        if (TypeIDs.length < 1) { alert("Please choose Pct_Type！"); return false; }
        $("#<%=TypeIDss.ClientID %>").val(TypeIDs.join(","));
       
        var ImgIsOK = GlobalImgList_Check("<%=HiddenField1.ClientID %>");
        if (ImgIsOK != "") { alert(ImgIsOK); return false; }

        if (!confirm("是否确认提交？")) { return false;}

        return true;
    }

    $(function () {
        UE.getEditor('<%=Info.ClientID %>');
        GetTypeTree(0);
        $(".friendtip").qtip({ position: { my: 'left center', at: 'right center' } });
        <%if (!IsPostBack)
          {%>
        yycms_upload_Init();
        GlobalImgList.push({ isdefault: true, src: "<%=p != null ? p.DefaultImg : ""%>" });<%if (p != null)
                                                                            {
                                                                                foreach (var v in p.ImgList.Split(','))
                                                                                {
                                                                                    if (String.IsNullOrEmpty(v)) { continue; } %>GlobalImgList.push({ isdefault: false, src: "<%=v%>" });<%} %>
        GlobalImgList_Show();
        <%}
          }%>
    });
    </script>
</asp:Content>