﻿<%@ Page Title="产品分类" Language="C#" MasterPageFile="~/Masters/Sys.Master" AutoEventWireup="true" CodeBehind="Types.aspx.cs" Inherits="yueyaCMS.Admin.Product.Types" %>
<%@ Import Namespace="System.Linq" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
<link href="/Plugins/ZTree/zTreeStyle.css" rel="stylesheet" type="text/css" />
<style type="text/css">
.ztree li span.button.add {margin-left:2px; margin-right: -1px; background-position:-144px 0; vertical-align:top; *vertical-align:middle}
</style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
 <ul class="breadcrumb">
<li><i class="icon-tags"></i> 您当前的位置：<a href="/Admin/Site/Default.aspx">系统首页</a></li>
<li><span class="divider">/</span> 产品分类</li>
</ul>
<div style="margin-bottom:10px">
<div class="input-prepend input-append">
<a class="btn btn-warning" href="Types.aspx">查看全部</a>
<input type="text" id="regionInput" onkeypress="if(event.keyCode==13){addType();}" class="friendtip" title="添加顶级分类。" required /> 
<a class="btn btn-success" onclick="addType();">添加</a>
 </div>
 </div>
<div style="width:590px;margin-bottom:5px;">
<ul id="tree" class="ztree" style="margin-top:0; width:180px;"></ul>
     </div>
<script src="/Plugins/ZTree/jquery.ztree.all-3.5.min.js" type="text/javascript"></script>
<script type="text/javascript">
    var PMSTree = null;
    var setting = {
        view: {
            addHoverDom: addHoverDom,
            removeHoverDom: removeHoverDom,
            selectedMulti: false
        },
        edit: { enable: true, editNameSelectAll: true },
        data: { simpleData: { enable: true} },
        check: { enable: true, chkboxType: { "Y": "ps", "N": "ps"} },
        callback: { beforeRemove: zTreeBeforeRemove, beforeRename: zTreeBeforeRename }
    };

    function InitZNodes(nodes) {
        var nodeArr = new Array(), ExID = 9999;
        for (var i = 0; i < nodes.length; i++) {
            nodeArr.push({ id: nodes[i].ID, pId: nodes[i].PID, name: nodes[i].Name, open: false, nocheck: false });
        }
        PMSTree = $.fn.zTree.init($("#tree"), setting, nodeArr);
    }

    /*获取树*/
    function GetTypeTree(pageIndex) {
        API.Product_Type_Get(function (result) {
            InitZNodes(result.dbList);
        }, "{pageIndex:0,showLength:9999}");
    }

    $(function () { GetTypeTree(0); $(".friendtip").qtip({ position: { my: 'left center', at: 'right center' } }); });

    /*添加分类*/
    function addHoverDom(treeId, treeNode) {
        /*if(treeNode.level>1){return;}*/
        var sObj = $("#" + treeNode.tId + "_span");
        if (treeNode.editNameFlag || $("#addBtn_" + treeNode.id).length > 0) return;
        var addStr = "<span class='button add' id='addBtn_" + treeNode.id + "' onfocus='this.blur();'></span>";
        sObj.after(addStr);
        var btn = $("#addBtn_" + treeNode.id);
        if (btn) btn.bind("click", function () {
            var NewName = prompt("请输入新商品分类的名称：");
            if (NewName && NewName.length > 0 && NewName.length < 20) {
                API.Product_Type_Add(function (r) {
                    if (r != "0") {
                        var zTree = $.fn.zTree.getZTreeObj("tree");
                        zTree.addNodes(treeNode, { id: r, pId: treeNode.id, name: NewName });
                    }
                }, "{pid:" + treeNode.id + ",newName:\"" + NewName + "\"}");
            }
            return false;
        });
    };

    function removeHoverDom(treeId, treeNode) { $("#addBtn_" + treeNode.id).unbind().remove(); };

    /*删除分类*/
    function zTreeBeforeRemove(treeId, treeNode) {
        if (!confirm("是否确认删除？")) { return false; }
        API.Product_Type_Delete(function (r) { if (r != "1") { alert(r); GetTypeTree(0); } }, "{typeID:" + treeNode.id + "}");
    }

    /*更新分类*/
    function zTreeBeforeRename(treeId, treeNode, newName) {
        if (newName.length < 1 || newName.length > 20) { return false; }
        if (newName != treeNode.name) {
            API.Product_Type_Update(function (r) { }, "{typeID:" + treeNode.id + ",newName:\"" + newName + "\"}");
        }
    }

    /*添加顶级分类*/
    function addType() {
        var region = $("#regionInput").val();
        if (region == "" || region.length < 1 || region.length > 20) { return; }
        if (!confirm("是否确认添加？")) { return; }
        API.Product_Type_Add(function (r) {
            if (r != "0") { GetTypeTree(0); }
        }, "{pid:0,newName:\"" + region + "\"}");
    }
	</script>
</asp:Content>