﻿<%@ Page Title="基本设置" Language="C#" MasterPageFile="~/Masters/Sys.Master" AutoEventWireup="true" CodeBehind="Setting.aspx.cs" Inherits="yueyaCMS.Admin.Site.Setting" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

    <ul class="breadcrumb">
        <li><i class="icon-tags"></i> 您当前的位置：<a href="/Admin/Site/Default.aspx">系统首页</a></li>
        <li><span class="divider">/</span> <span>基本设置</span></li>
    </ul>
    <form id="form1" runat="server">
        <%if (!String.IsNullOrEmpty(errorMsg))
          {%>
        <div class="alert alert-info"><%=errorMsg %></div>
        <%} %>
        <table class="table table-bordered">
            <tr>
                <th>网站基本配置</th>
            </tr>
            <tr>
                <td>
                    <div class="input-prepend">
                        <span class="add-on"><i class="icon-home"></i> 网站域名</span>
                        <asp:TextBox ID="Biz_SiteAddress" runat="server" CssClass="firendtip" ToolTip="不要加'http://'直接填写域名即可。" />
                    </div>
                </td>
            </tr>

            <tr>
                <td>
                    <div class="input-prepend input-append">
                        <span class="add-on"><i class="icon-envelope"></i> 站长邮箱</span>
                        <asp:TextBox ID="Biz_AdminEmail" CssClass="firendtip" ToolTip="客户留言或其他信息将同步到站长信箱。" runat="server" />
                        <a href="#" class="btn firendtip" onclick="mailsend();" title="点击后将根据邮件服务器配置的帐号密码发送一封测试邮件到当前邮箱。">测试邮箱</a>
                    </div>
                </td>
            </tr>

            <tr>
                <td>
                    <div class="input-prepend input-append">
                        <span class="add-on"><i class="icon-picture"></i> 图片水印</span>
                        <input type="text" id="watermarkShow" class="firendtip" title="网站上传图片时将自动添加此水印图片。" value="<%=yueyaCMS.Global.Settings["watermark"] %>" />
                        <a id="setwatermarkimg" href="#" onclick="AddPicEx();" class="btn">设置水印</a>
                    </div>
                    &nbsp;<label class="checkbox inline">开启自动加水印功能
                        <asp:CheckBox ID="EnabelWatermark" runat="server" /></label>
                    <asp:HiddenField ID="watermark" runat="server" />
                </td>
            </tr>
            <tr>
                <td>
                    <div class="input-prepend input-append">
                        <span class="add-on firendtip" title="系统最上面的导航连接设置，节点支持拖拽。"><i class="icon-list-alt"></i> 导航菜单</span>
                        <a onclick="addParentType();" href="#" class="btn btn-success firendtip" title="添加一级连接">添加连接</a><a href="#" class="btn btn-success firendtip" onclick="AllTopLinksCtrl(this);" st="0" title="展开或关闭全部节点">展开</a>
                        </div>
                    <ul id="tree" class="ztree" style="margin-top: 0; width: 180px;"></ul>
                    <asp:HiddenField ID="TopLinks" runat="server" />
                </td>
            </tr>

            <tr>
                <th>网站生成配置</th>
            </tr>
            <tr>
                <td>
                    <div class="input-prepend input-append">
                        <span class="add-on"><i class="icon-file"></i> 新闻模板</span>
                        <asp:DropDownList ID="Master_NewsInfo" CssClass="firendtip" ToolTip="添加新闻时，系统自动套用模板ID。" runat="server" />
                        <a href="javascript:void(0)" class="btn firendtip" onclick="$('#setNewsRange').show()" title="生成网站时,将根据输入的起止时间获取新闻数据，为空代表全部。">设置时间</a>
                    </div>
                </td>
            </tr>
            
            <tr id="setNewsRange"<%if(String.IsNullOrEmpty(Master_NewsInfo_StartTime.Text)&&String.IsNullOrEmpty(Master_NewsInfo_EndTime.Text)){ %> style="display:none;"<%} %>>
                <td>
                    <div id="datetimepicker" class="input-prepend input-append">
                        <span class="add-on">新闻生成从</span>
                        <asp:TextBox ID="Master_NewsInfo_StartTime" CssClass="span3" runat="server" />
                        <span class="add-on">至</span>
                        <asp:TextBox ID="Master_NewsInfo_EndTime" CssClass="span3" runat="server" />
                    </div>
                </td>
            </tr>
            
            <tr>
                <td>
                    <div class="input-prepend input-append">
                        <span class="add-on"><i class="icon-file"></i> 产品模板</span>
                        <asp:DropDownList ID="Master_ProductInfo" CssClass="firendtip" ToolTip="添加产品时，系统自动套用模板ID。" runat="server" />
                        <a href="javascript:void(0)" class="btn firendtip" onclick="$('#setPctsRange').show()" title="生成网站时,将根据输入的起止时间获取产品数据，为空代表全部。">设置时间</a>
                    </div>
                </td>
            </tr>

            <tr id="setPctsRange"<%if (String.IsNullOrEmpty(Master_ProductInfo_StartTime.Text) && String.IsNullOrEmpty(Master_ProductInfo_EndTime.Text))
                 { %> style="display:none;"<%} %>>
                <td>
                    <div class="input-prepend input-append">
                        <span class="add-on">产品生成从</span>
                        <asp:TextBox ID="Master_ProductInfo_StartTime" CssClass="span3" runat="server" />
                        <span class="add-on">至</span>
                        <asp:TextBox ID="Master_ProductInfo_EndTime" CssClass="span3" runat="server" />
                    </div>
                </td>
            </tr>

            <tr>
                <th>邮件服务器配置</th>
            </tr>
            <tr>
                <td>
                    <div class="input-prepend">
                        <span class="add-on"><i class="icon-globe"></i> 地址</span>
                        <asp:TextBox ID="MailUrl" CssClass="firendtip" ToolTip="邮件服务器IP地址/域名。" runat="server" />
                    </div>
                </td>
            </tr>
            <tr>
                <td>
                    <div class="input-prepend">
                        <span class="add-on"><i class="icon-screenshot"></i> 端口</span>
                        <asp:TextBox ID="MailPort" CssClass="firendtip" ToolTip="邮件服务器开放的端口号。" runat="server" />
                    </div>
                </td>
            </tr>
            <tr>
                <td>
                    <div class="input-prepend">
                        <span class="add-on"><i class="icon-user"></i> 帐号</span>
                        <asp:TextBox ID="MailAccount" CssClass="firendtip" ToolTip="系统发送邮件使用的账号。" runat="server" />
                    </div>
                </td>
            </tr>
            <tr>
                <td>
                    <div class="input-prepend">
                        <span class="add-on"><i class="icon-lock"></i> 密码</span>
                        <asp:TextBox ID="MailPassword" CssClass="firendtip" ToolTip="系统发送邮件使用的密码。" runat="server" />
                    </div>
                </td>
            </tr>

             <tr>
                <th>服务器配置</th>
            </tr>
            <tr>
                <td>
                    <div class="input-prepend">
                        <span class="add-on"><i class="icon-hdd"></i> 内存大小</span>
                        <asp:TextBox ID="MaxMemory" runat="server" CssClass="firendtip" ToolTip="单位为MB" />
                    </div>
                </td>
            </tr>
            
            <tr>
                <td>
                    <div class="input-prepend">
                        <span class="add-on"><i class="icon-hdd"></i> 数据容量</span>
                        <asp:TextBox ID="MaxDataBase" runat="server" CssClass="firendtip" ToolTip="单位为MB" />
                    </div>
                </td>
            </tr>

            <tr>
                <td>
                    <div class="input-prepend">
                        <span class="add-on"><i class="icon-hdd"></i> 网站大小</span>
                        <asp:TextBox ID="MaxSite" runat="server" CssClass="firendtip" ToolTip="单位为MB" />
                    </div>
                </td>
            </tr>

        </table>
        <div class="form-actions">
            <asp:Button ID="subBtn" runat="server" Text="更新配置" OnClientClick="return checkCtrlValue();" CssClass="btn btn-warning btn-large" OnClick="subBtn_Click" />
        </div>
    </form>

    <div id="myModal" class="modal hide fade" style="width:350px;left:60%;">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            <h3>添加顶部连接</h3>
        </div>
        <div class="modal-body">

            <p>
                <div class="input-prepend">
                <span class="add-on"><i class="icon-home"></i> 连接名称</span>
                <input type="text" id="TopLinkName" maxlength="100" />
                </div>
            </p>

            <p>
                <div class="input-prepend">
                <span class="add-on"><i class="icon-share-alt"></i> 连接网址</span>
                <input type="text" id="TopLinkUrl" maxlength="500" />
                </div>
            </p>

            <p>
                <div class="input-prepend">
                <span class="add-on"><i class="icon-list-alt"></i> 打开方式</span>
                <select id="TopLinkOpenWay">
                            <option value="_self">当前窗口</option>
                            <option value="_blank">新窗口</option>
                        </select>
                </div>
            </p>
        </div>
        <div class="modal-footer">
            <a href="#" class="btn" onclick="showModal(0);">取消</a>
            <a href="#" class="btn btn-primary" onclick="addType();">确认添加</a>
        </div>
    </div>


    <link href="/Plugins/jqueryUI/jquery-ui-1.10.3.custom.min.css" rel="stylesheet" />
    <script src="/Plugins/jqueryUI/jquery-ui-1.10.3.custom.min.js"></script>

    <script src="/Plugins/ueditor/ueditor.config.js"></script>
    <script src="/Plugins/ueditor/ueditor.all.min.js"></script>
    <script src="/Scripts/yycms_upload.js"></script>

    <link href="/Plugins/ZTree/zTreeStyle.css" rel="stylesheet" type="text/css" />
    <script src="/Plugins/ZTree/jquery.ztree.all-3.5.min.js" type="text/javascript"></script>
    <script type="text/javascript">
        function showModal(_s) {
            if (_s == 0) { $("#myModal").modal("hide"); }
            else {
                $("#myModal").modal({ show: true, backdrop: true });
                $("#TopLinkName,#TopLinkUrl,#TopLinkOpenWay").val("");
            }
        }

        var treeNodeTemp=null;

        /*添加分类*/
        function addHoverDom(treeId, treeNode) {
            /*if(treeNode.level>1){return;}*/
            var sObj = $("#" + treeNode.tId + "_span");
            if (treeNode.editNameFlag || $("#addBtn_" + treeNode.id).length > 0) return;
            var addStr = "<span class='button add' id='addBtn_" + treeNode.id + "' onfocus='this.blur();'></span>";
            sObj.after(addStr);
            var btn = $("#addBtn_" + treeNode.id);
            if (btn) btn.bind("click", function () {
                treeNodeTemp=treeNode;
                showModal(1);
                return false;
               
            });
        };

        function removeHoverDom(treeId, treeNode) { $("#addBtn_" + treeNode.id).unbind().remove(); };

        function addParentType()
        {
            treeNodeTemp=null;
            showModal(1);
        }

        /*顶部连接-添加*/
        function addType() 
        {
            var NodeName =$("#TopLinkName").val();
            var Url=$("#TopLinkUrl").val();;
            var Target=$("#TopLinkOpenWay option:selected").val();;

            if(NodeName==""){alert("连接名称不能为空"); return;}
            if(Url==""){alert("连接网址不能为空"); return;}
            showModal(0);
            var zTree = $.fn.zTree.getZTreeObj("tree");
            var timestamp = (new Date()).valueOf(); 
            zTree.addNodes(treeNodeTemp, { id: timestamp, pId: (treeNodeTemp!=null?treeNodeTemp.id:0), name: NodeName,url:Url, target:Target}); 
        }

        var setting = {
            view: {
                addHoverDom: addHoverDom,
                removeHoverDom: removeHoverDom,
                selectedMulti: false
            },
            edit: { enable: true,showRenameBtn: false,drag:{autoExpandTrigger : true,isCopy : true,isMove : true,prev : true,next : true,inner : true,borderMax : 10,borderMin : -5,minMoveSize : 5,maxShowNodeNum : 5,autoOpenTime : 500}},
            data: { simpleData: { enable: true } },
            check: { enable: false}
        };

        function InitZNodes()
        {
            $.fn.zTree.init($("#tree"), setting, <%=TopLinks.Value%>);
        }


        /*全部展开/收缩 顶部连接节点的方法 */
        function AllTopLinksCtrl(_ele)
        {
            var treeObj = $.fn.zTree.getZTreeObj("tree");
            if($(_ele).attr("st")=="0"){
                treeObj.expandAll(true);
                $(_ele).attr("st","1");
                $(_ele).text("收起");
            }
            else{
                treeObj.expandAll(false);
                $(_ele).attr("st","0");
                $(_ele).text("展开");
            }
        }

        function checkCtrlValue()
        {
            if(!confirm('是否确认提交？')){return false;}
            var treeObj = $.fn.zTree.getZTreeObj("tree");
            var nodes = treeObj.transformToArray(treeObj.getNodes());
            var toplinksStr=new Array();
            for(var i=0;i<nodes.length;i++)
            {
                var pnode=nodes[i].getParentNode();
                toplinksStr.push('{ id: '+nodes[i].id+', pId: '+(pnode!=null?pnode.id:0)+', name:"'+ nodes[i].name+'",url:"'+nodes[i].url+'",target:"'+nodes[i].target+'"}');
            }
            
            var _val="["+toplinksStr.join(",")+"]";
            $("#<%=TopLinks.ClientID%>").val(_val);
            return true;
        }

        function AddPicEx() {
            GlobalImgList = new Array();
            AddPic();
        }

        $(function () {
            $("#<%=Master_NewsInfo.ClientID%> option[value='<%=Settings.Where(a=>a.ConfigKey.Equals("Master_NewsInfo")).FirstOrDefault().Value%>']").attr("selected", "selected");
            $("#<%=Master_ProductInfo.ClientID%> option[value='<%=Settings.Where(a=>a.ConfigKey.Equals("Master_ProductInfo")).FirstOrDefault().Value%>']").attr("selected", "selected");
            //$("#<%=Master_NewsInfo.ClientID%>,#<%=Master_ProductInfo.ClientID%>,#TopLinkOpenWay").select2();
            $("#<%=Master_NewsInfo_StartTime.ClientID%>,#<%=Master_NewsInfo_EndTime.ClientID%>,#<%=Master_ProductInfo_StartTime.ClientID%>,#<%=Master_ProductInfo_EndTime.ClientID%>").datepicker({
                dayNames: ["星期天", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"],
                dayNamesMin: ["七", "一", "二", "三", "四", "五", "六"],
                dayNamesShort: ["周日", "周一", "周二", "周三", "周四", "周五", "周六"],
                changeMonth: true,
                changeYear: true,
                monthNames: ["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"],
                monthNamesShort: ["1月", "2月", "3月", "4月", "5月", "6月", "7月", "8月", "9月", "10月", "11月", "12月"],
                //maxDate: "+1y",
                dateFormat: "yy-mm-dd 00:00:00"
            });

            yycms_upload_Init(function (_img) { $("#watermarkShow").attr("src", _img).show(); $("#<%=watermark.ClientID%>").val(_img); });
            InitZNodes();
            $(".firendtip").qtip({position: {my: 'left center',at: 'right center'}});
        });

        function mailsend()
        {
            var _m=$("#<%=Biz_AdminEmail.ClientID%>").val();
            
            if(_m==""){ alert("邮箱地址不能为空！"); return; }

            alert("已发送测试邮件到当前邮箱，请稍等。。");

            API.Mail_Send(function(r){ if(r=="1"){ alert("发送成功。"); } else{ alert(r);} },"{_mail:\""+_m+"\"}");
        }
    </script>
</asp:Content>
