﻿ALTER DATABASE [yueyasoft_CMS] SET ANSI_NULL_DEFAULT OFF

ALTER DATABASE [yueyasoft_CMS] SET ANSI_NULLS OFF

ALTER DATABASE [yueyasoft_CMS] SET ANSI_PADDING OFF

ALTER DATABASE [yueyasoft_CMS] SET ANSI_WARNINGS OFF

ALTER DATABASE [yueyasoft_CMS] SET ARITHABORT OFF

ALTER DATABASE [yueyasoft_CMS] SET AUTO_CLOSE OFF

ALTER DATABASE [yueyasoft_CMS] SET AUTO_CREATE_STATISTICS ON

ALTER DATABASE [yueyasoft_CMS] SET AUTO_SHRINK OFF

ALTER DATABASE [yueyasoft_CMS] SET AUTO_UPDATE_STATISTICS ON

ALTER DATABASE [yueyasoft_CMS] SET CURSOR_CLOSE_ON_COMMIT OFF

ALTER DATABASE [yueyasoft_CMS] SET CURSOR_DEFAULT  GLOBAL

ALTER DATABASE [yueyasoft_CMS] SET CONCAT_NULL_YIELDS_NULL OFF

ALTER DATABASE [yueyasoft_CMS] SET NUMERIC_ROUNDABORT OFF

ALTER DATABASE [yueyasoft_CMS] SET QUOTED_IDENTIFIER OFF

ALTER DATABASE [yueyasoft_CMS] SET RECURSIVE_TRIGGERS OFF

ALTER DATABASE [yueyasoft_CMS] SET  DISABLE_BROKER

ALTER DATABASE [yueyasoft_CMS] SET AUTO_UPDATE_STATISTICS_ASYNC OFF

ALTER DATABASE [yueyasoft_CMS] SET DATE_CORRELATION_OPTIMIZATION OFF

ALTER DATABASE [yueyasoft_CMS] SET TRUSTWORTHY OFF

ALTER DATABASE [yueyasoft_CMS] SET ALLOW_SNAPSHOT_ISOLATION OFF

ALTER DATABASE [yueyasoft_CMS] SET PARAMETERIZATION SIMPLE

ALTER DATABASE [yueyasoft_CMS] SET READ_COMMITTED_SNAPSHOT OFF

ALTER DATABASE [yueyasoft_CMS] SET  READ_WRITE

ALTER DATABASE [yueyasoft_CMS] SET RECOVERY FULL

ALTER DATABASE [yueyasoft_CMS] SET  MULTI_USER

ALTER DATABASE [yueyasoft_CMS] SET PAGE_VERIFY CHECKSUM

ALTER DATABASE [yueyasoft_CMS] SET DB_CHAINING OFF

EXEC sys.sp_db_vardecimal_storage_format N'yueyasoft_CMS', N'ON'

USE [yueyasoft_CMS]

/****** Object:  Table [dbo].[yy_User]    Script Date: 11/23/2013 18:01:41 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[yy_User](
	[ID] [bigint] IDENTITY(1,1) NOT NULL,
	[UserName] [nvarchar](50) NOT NULL,
	[UserPwd] [nvarchar](100) NOT NULL,
 CONSTRAINT [PK_yy_User] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'编号' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_User', @level2type=N'COLUMN',@level2name=N'ID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'用户名称' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_User', @level2type=N'COLUMN',@level2name=N'UserName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'用户密码' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_User', @level2type=N'COLUMN',@level2name=N'UserPwd'
/****** Object:  Table [dbo].[yy_Statistics]    Script Date: 11/23/2013 18:01:41 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[yy_Statistics](
	[ID] [bigint] IDENTITY(1,1) NOT NULL,
	[PID] [bigint] NOT NULL,
	[Type] [int] NOT NULL,
	[CreateTime] [datetime] NOT NULL,
 CONSTRAINT [PK_yy_Statistics] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'唯一标识' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Statistics', @level2type=N'COLUMN',@level2name=N'ID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'新闻/商品ID' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Statistics', @level2type=N'COLUMN',@level2name=N'PID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'日志标示1新闻2商品' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Statistics', @level2type=N'COLUMN',@level2name=N'Type'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'创建时间' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Statistics', @level2type=N'COLUMN',@level2name=N'CreateTime'
/****** Object:  Table [dbo].[yy_SiteSetting]    Script Date: 11/23/2013 18:01:41 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[yy_SiteSetting](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[ConfigKey] [nvarchar](50) NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
	[Value] [nvarchar](max) NOT NULL,
 CONSTRAINT [PK_yy_SiteSetting] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
 CONSTRAINT [Con_unique_yy_SiteSetting_ConfigKey] UNIQUE NONCLUSTERED 
(
	[ConfigKey] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'编号' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_SiteSetting', @level2type=N'COLUMN',@level2name=N'ID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'业务标识' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_SiteSetting', @level2type=N'COLUMN',@level2name=N'ConfigKey'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'业务标示名称' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_SiteSetting', @level2type=N'COLUMN',@level2name=N'Name'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'业务表示值' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_SiteSetting', @level2type=N'COLUMN',@level2name=N'Value'
/****** Object:  Table [dbo].[yy_SinglePage]    Script Date: 11/23/2013 18:01:41 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[yy_SinglePage](
	[ID] [bigint] IDENTITY(1,1) NOT NULL,
	[PageName] [nvarchar](10) NOT NULL,
	[Info] [nvarchar](max) NOT NULL,
	[CreateDate] [datetime] NOT NULL,
 CONSTRAINT [PK_yy_SinglePage] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'编号' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_SinglePage', @level2type=N'COLUMN',@level2name=N'ID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'页面名称' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_SinglePage', @level2type=N'COLUMN',@level2name=N'PageName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'页面详情' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_SinglePage', @level2type=N'COLUMN',@level2name=N'Info'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'创建时间' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_SinglePage', @level2type=N'COLUMN',@level2name=N'CreateDate'
/****** Object:  Table [dbo].[yy_Product_Type]    Script Date: 11/23/2013 18:01:41 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[yy_Product_Type](
	[ID] [bigint] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
	[PID] [bigint] NOT NULL,
	[CreateDate] [datetime] NOT NULL,
 CONSTRAINT [PK_yy_Product_Type] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'编号' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Product_Type', @level2type=N'COLUMN',@level2name=N'ID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'商品类别名称' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Product_Type', @level2type=N'COLUMN',@level2name=N'Name'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'父级编号' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Product_Type', @level2type=N'COLUMN',@level2name=N'PID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'创建时间' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Product_Type', @level2type=N'COLUMN',@level2name=N'CreateDate'
/****** Object:  Table [dbo].[yy_Product]    Script Date: 11/23/2013 18:01:41 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[yy_Product](
	[ID] [bigint] IDENTITY(1,1) NOT NULL,
	[TypeIDs] [nvarchar](500) NOT NULL,
	[Title] [nvarchar](200) NOT NULL,
	[KeyWords] [nvarchar](200) NOT NULL,
	[LookCount] [bigint] NOT NULL,
	[Summary] [nvarchar](200) NOT NULL,
	[DefaultImg] [nvarchar](500) NOT NULL,
	[ImgList] [nvarchar](max) NOT NULL,
	[Price] [decimal](18, 2) NOT NULL,
	[Info] [nvarchar](max) NOT NULL,
	[OnSale] [int] NOT NULL,
	[ShowIndex] [bigint] NOT NULL,
	[CreateDate] [datetime] NOT NULL,
 CONSTRAINT [PK_yy_Product] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'编号' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Product', @level2type=N'COLUMN',@level2name=N'ID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'商品所属分类集合' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Product', @level2type=N'COLUMN',@level2name=N'TypeIDs'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'标题' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Product', @level2type=N'COLUMN',@level2name=N'Title'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'关键字' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Product', @level2type=N'COLUMN',@level2name=N'KeyWords'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'浏览数量' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Product', @level2type=N'COLUMN',@level2name=N'LookCount'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'商品简单描述' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Product', @level2type=N'COLUMN',@level2name=N'Summary'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'默认主图' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Product', @level2type=N'COLUMN',@level2name=N'DefaultImg'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'图片集合列表' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Product', @level2type=N'COLUMN',@level2name=N'ImgList'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'销售价格' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Product', @level2type=N'COLUMN',@level2name=N'Price'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'商品详情' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Product', @level2type=N'COLUMN',@level2name=N'Info'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否上架' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Product', @level2type=N'COLUMN',@level2name=N'OnSale'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'显示位置' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Product', @level2type=N'COLUMN',@level2name=N'ShowIndex'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'创建时间' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Product', @level2type=N'COLUMN',@level2name=N'CreateDate'
/****** Object:  Table [dbo].[yy_Platforms]    Script Date: 11/23/2013 18:01:41 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[yy_Platforms](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
	[Link] [nvarchar](500) NOT NULL,
	[Image] [nvarchar](500) NOT NULL,
	[JSSDK] [nvarchar](max) NOT NULL,
	[Remark] [nvarchar](500) NOT NULL,
	[CreateDate] [datetime] NOT NULL,
 CONSTRAINT [PK_yy_Platforms] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'编号' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Platforms', @level2type=N'COLUMN',@level2name=N'ID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'平台名称' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Platforms', @level2type=N'COLUMN',@level2name=N'Name'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'连接地址' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Platforms', @level2type=N'COLUMN',@level2name=N'Link'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'平台图标' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Platforms', @level2type=N'COLUMN',@level2name=N'Image'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'平台备注' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Platforms', @level2type=N'COLUMN',@level2name=N'Remark'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'创建日期' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Platforms', @level2type=N'COLUMN',@level2name=N'CreateDate'
/****** Object:  Table [dbo].[yy_Page_Type]    Script Date: 11/23/2013 18:01:41 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[yy_Page_Type](
	[ID] [bigint] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
	[Version] [bigint] NOT NULL,
	[CreateDate] [datetime] NOT NULL,
 CONSTRAINT [PK_yy_Page_Type] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'编号' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Page_Type', @level2type=N'COLUMN',@level2name=N'ID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'风格名称' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Page_Type', @level2type=N'COLUMN',@level2name=N'Name'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'当前版本' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Page_Type', @level2type=N'COLUMN',@level2name=N'Version'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'创建日期' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Page_Type', @level2type=N'COLUMN',@level2name=N'CreateDate'
/****** Object:  Table [dbo].[yy_Page_BuildTask]    Script Date: 11/23/2013 18:01:41 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[yy_Page_BuildTask](
	[ID] [bigint] IDENTITY(1,1) NOT NULL,
	[PageID] [bigint] NOT NULL,
	[BuildEntity] [nvarchar](max) NOT NULL,
	[TotalCount] [bigint] NOT NULL,
	[BuildCount] [bigint] NOT NULL,
	[Status] [int] NOT NULL,
	[BuildHistory] [nvarchar](max) NOT NULL,
	[CreateDate] [datetime] NOT NULL,
	[LastUpdateTime] [datetime] NOT NULL,
 CONSTRAINT [PK_yy_Page_BuildLog] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'编号' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Page_BuildTask', @level2type=N'COLUMN',@level2name=N'ID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'要生成的模板名称列表' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Page_BuildTask', @level2type=N'COLUMN',@level2name=N'PageID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'生成模板时用到的实体类，程序自动进行反序列化' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Page_BuildTask', @level2type=N'COLUMN',@level2name=N'BuildEntity'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'总共的生成数量' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Page_BuildTask', @level2type=N'COLUMN',@level2name=N'TotalCount'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'当前已经生成的数量' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Page_BuildTask', @level2type=N'COLUMN',@level2name=N'BuildCount'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'该生成任务的状态0，停止；1，执行中；2，已完成；' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Page_BuildTask', @level2type=N'COLUMN',@level2name=N'Status'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'操作记录' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Page_BuildTask', @level2type=N'COLUMN',@level2name=N'BuildHistory'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'任务的创建日期' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Page_BuildTask', @level2type=N'COLUMN',@level2name=N'CreateDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'更新日期' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Page_BuildTask', @level2type=N'COLUMN',@level2name=N'LastUpdateTime'
/****** Object:  Table [dbo].[yy_Page]    Script Date: 11/23/2013 18:01:41 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[yy_Page](
	[ID] [bigint] IDENTITY(1,1) NOT NULL,
	[PageName] [nvarchar](50) NOT NULL,
	[TypeID] [bigint] NOT NULL,
	[PageKind] [int] NOT NULL,
	[SavePath] [nvarchar](500) NOT NULL,
	[ExtensionName] [nvarchar](200) NOT NULL,
	[Summary] [nvarchar](200) NOT NULL,
	[PageCode] [nvarchar](max) NOT NULL,
	[CanBuild] [int] NOT NULL,
	[CreateDate] [datetime] NOT NULL,
	[LastUpdateTime] [datetime] NOT NULL,
 CONSTRAINT [PK_yy_Page] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'模板名称' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Page', @level2type=N'COLUMN',@level2name=N'PageName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'模板风格' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Page', @level2type=N'COLUMN',@level2name=N'TypeID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'模板类型' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Page', @level2type=N'COLUMN',@level2name=N'PageKind'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'生成时输出的路径' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Page', @level2type=N'COLUMN',@level2name=N'SavePath'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'扩展名称' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Page', @level2type=N'COLUMN',@level2name=N'ExtensionName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'模板备注' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Page', @level2type=N'COLUMN',@level2name=N'Summary'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'模板源代码' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Page', @level2type=N'COLUMN',@level2name=N'PageCode'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否支持一键生成' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Page', @level2type=N'COLUMN',@level2name=N'CanBuild'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'创建日期' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Page', @level2type=N'COLUMN',@level2name=N'CreateDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'更新日期' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Page', @level2type=N'COLUMN',@level2name=N'LastUpdateTime'
/****** Object:  Table [dbo].[yy_News_Type]    Script Date: 11/23/2013 18:01:41 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[yy_News_Type](
	[ID] [bigint] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
	[PID] [bigint] NOT NULL,
	[CreateDate] [datetime] NOT NULL,
 CONSTRAINT [PK_yy_News_Type] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'编号' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_News_Type', @level2type=N'COLUMN',@level2name=N'ID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'名称' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_News_Type', @level2type=N'COLUMN',@level2name=N'Name'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'父级编号' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_News_Type', @level2type=N'COLUMN',@level2name=N'PID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'创建日期' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_News_Type', @level2type=N'COLUMN',@level2name=N'CreateDate'
/****** Object:  Table [dbo].[yy_News]    Script Date: 11/23/2013 18:01:41 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[yy_News](
	[ID] [bigint] IDENTITY(1,1) NOT NULL,
	[TypeIDs] [nvarchar](500) NOT NULL,
	[Title] [nvarchar](100) NOT NULL,
	[KeyWords] [nvarchar](100) NOT NULL,
	[LookCount] [bigint] NOT NULL,
	[Summary] [nvarchar](200) NOT NULL,
	[DefaultImg] [nvarchar](500) NOT NULL,
	[ImgList] [nvarchar](max) NOT NULL,
	[Info] [nvarchar](max) NOT NULL,
	[IsShow] [int] NOT NULL,
	[ShowIndex] [bigint] NOT NULL,
	[CreateDate] [datetime] NOT NULL,
 CONSTRAINT [PK_yy_News] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'编号' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_News', @level2type=N'COLUMN',@level2name=N'ID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'新闻分类ID集合' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_News', @level2type=N'COLUMN',@level2name=N'TypeIDs'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'新闻标题' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_News', @level2type=N'COLUMN',@level2name=N'Title'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'新闻关键字' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_News', @level2type=N'COLUMN',@level2name=N'KeyWords'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'浏览数量' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_News', @level2type=N'COLUMN',@level2name=N'LookCount'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'新闻描述' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_News', @level2type=N'COLUMN',@level2name=N'Summary'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'默认主图' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_News', @level2type=N'COLUMN',@level2name=N'DefaultImg'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'新闻图片集合，以英文逗号拼接连接地址' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_News', @level2type=N'COLUMN',@level2name=N'ImgList'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'新闻详情' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_News', @level2type=N'COLUMN',@level2name=N'Info'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否显示' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_News', @level2type=N'COLUMN',@level2name=N'IsShow'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'显示位置' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_News', @level2type=N'COLUMN',@level2name=N'ShowIndex'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'创建日期' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_News', @level2type=N'COLUMN',@level2name=N'CreateDate'
/****** Object:  Table [dbo].[yy_Message]    Script Date: 11/23/2013 18:01:41 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[yy_Message](
	[ID] [bigint] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
	[Mail] [nvarchar](200) NOT NULL,
	[Mobile] [nvarchar](50) NOT NULL,
	[Message] [nvarchar](max) NOT NULL,
	[CreateDate] [datetime] NOT NULL,
 CONSTRAINT [PK_yy_Message] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'编号' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Message', @level2type=N'COLUMN',@level2name=N'ID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'留言人的姓名' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Message', @level2type=N'COLUMN',@level2name=N'Name'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'联系邮箱' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Message', @level2type=N'COLUMN',@level2name=N'Mail'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'电话或手机号码' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Message', @level2type=N'COLUMN',@level2name=N'Mobile'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'留言详细信息' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Message', @level2type=N'COLUMN',@level2name=N'Message'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'创建时间' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Message', @level2type=N'COLUMN',@level2name=N'CreateDate'
/****** Object:  Table [dbo].[yy_FriendLink]    Script Date: 11/23/2013 18:01:41 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[yy_FriendLink](
	[ID] [bigint] IDENTITY(1,1) NOT NULL,
	[FriendName] [nvarchar](100) NOT NULL,
	[FriendLink] [nvarchar](500) NOT NULL,
	[SiteLogo] [nvarchar](500) NOT NULL,
	[ShowIndex] [bigint] NOT NULL,
 CONSTRAINT [PK_yy_FriendLink] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'编号' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_FriendLink', @level2type=N'COLUMN',@level2name=N'ID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'友情链接站点名称' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_FriendLink', @level2type=N'COLUMN',@level2name=N'FriendName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'站点网址' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_FriendLink', @level2type=N'COLUMN',@level2name=N'FriendLink'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'站点LOGO图标' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_FriendLink', @level2type=N'COLUMN',@level2name=N'SiteLogo'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'显示位置' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_FriendLink', @level2type=N'COLUMN',@level2name=N'ShowIndex'
/****** Object:  Table [dbo].[yy_Banner]    Script Date: 11/23/2013 18:01:41 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[yy_Banner](
	[ID] [bigint] IDENTITY(1,1) NOT NULL,
	[Title] [nvarchar](50) NOT NULL,
	[ImgPath] [nvarchar](500) NOT NULL,
	[Href] [nvarchar](500) NOT NULL,
	[CreateDate] [datetime] NOT NULL,
 CONSTRAINT [PK_yy_Banner] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'序号' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Banner', @level2type=N'COLUMN',@level2name=N'ID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'广告图名称' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Banner', @level2type=N'COLUMN',@level2name=N'Title'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'广告图存放的路径' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Banner', @level2type=N'COLUMN',@level2name=N'ImgPath'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'点击后跳转的连接' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Banner', @level2type=N'COLUMN',@level2name=N'Href'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'创建日期' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'yy_Banner', @level2type=N'COLUMN',@level2name=N'CreateDate'
/****** Object:  Default [DF_yy_News_KeyWords]    Script Date: 11/23/2013 18:01:41 ******/
ALTER TABLE [dbo].[yy_News] ADD  CONSTRAINT [DF_yy_News_KeyWords]  DEFAULT ((0)) FOR [KeyWords]
/****** Object:  Default [DF_yy_News_ShowIndex]    Script Date: 11/23/2013 18:01:41 ******/
ALTER TABLE [dbo].[yy_News] ADD  CONSTRAINT [DF_yy_News_ShowIndex]  DEFAULT ((1)) FOR [ShowIndex]
/****** Object:  Default [DF_yy_Platforms_JSSDK]    Script Date: 11/23/2013 18:01:41 ******/
ALTER TABLE [dbo].[yy_Platforms] ADD  CONSTRAINT [DF_yy_Platforms_JSSDK]  DEFAULT ((0)) FOR [JSSDK]
/****** Object:  Default [DF_yy_SinglePage_CreateDate]    Script Date: 11/23/2013 18:01:41 ******/
ALTER TABLE [dbo].[yy_SinglePage] ADD  CONSTRAINT [DF_yy_SinglePage_CreateDate]  DEFAULT (getdate()) FOR [CreateDate]
/****** Object:  Default [DF_yy_Statistics_CreateTime]    Script Date: 11/23/2013 18:01:41 ******/
ALTER TABLE [dbo].[yy_Statistics] ADD  CONSTRAINT [DF_yy_Statistics_CreateTime]  DEFAULT (getdate()) FOR [CreateTime]
