﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Models;
using LoveDAL;

namespace LoveBLL
{
    public static class InvitationManager
    {
        //增加
        public static Boolean AddInvi(Invitation invi)
        {
            return InvitationService.AddInvi(invi);
        }
        //删除
        public static void DelInve(Invitation invi)
        {
            InvitationService.DelInvi(invi);
        }
        //修改
        public static void UpdateInvi(Invitation invi)
        {
            InvitationService.UpdateInvi(invi);
        }
        //获取所有
        public static IList<Invitation> GetAllInvi()
        {
            return InvitationService.GetInviAll();
        }
        //截取字段
        public static string GetPartString(string invi_contents, int num)
        {
            return InvitationService.GetPartString(invi_contents, num);
        }
        //通过id获取帖子,返回List
        public static IList<Invitation> GetInviById(int id)
        {
            return InvitationService.GetInviById(id);
        }
        //获取帖子总数
        public static int GetInviNum()
        {
            return InvitationService.GetInviNum();
        }
        //通过帖子编号获取回复总数
        public static int GetReviewNumByInviNum(int invi_id)
        {
            return InvitationService.GetReviewByInviNum(invi_id);
        }
        //增加点击
        public static void UpInvi_click(Invitation invi)
        {
            InvitationService.UpInvi_click(invi);
        }
        //返回实体类

        public static Invitation GetInvitationByid(int id)
        {
            return InvitationService.GetInvitationById(id);
        }
        //通过用户编号查帖子
        public static IList<Invitation> GetInviByUserId(int id)
        {
            return InvitationService.GetInviByUserId(id);
        }
        //查询部分帖子
        public static IList<Invitation> GetInviPart()
        {
            return InvitationService.GetInviPart();
        }
        //根据帖子点击最高查询
        public static IList<Invitation> GetInviClick()
        {
            return InvitationService.GetInviClick();
        }
        //搜索条数
        public static int GetSouInviNum(string str)
        {
            return InvitationService.GetSouInviNum(str);

        }
        //搜索到的帖子
        public static IList<Invitation> GetSouInvi(string str)
        {
            return InvitationService.GetSouInvi(str);
        }
    }
}
