﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Models;
using LoveDAL;

namespace LoveBLL
{
    public static class UserManager
    {
        ///用户登录验证
        public static bool UserLogin(User user, out User userExist)
        {
            User vuser = UserService.QueryUser(user);
            if (vuser == null)
            {
                userExist = null;
                return false;

            }
            else
            {
                userExist = vuser;
                return true;
            }
        }
        public static bool CheckLogin(User user)
        {
            User vuser = UserService.QueryUser(user);
            if (vuser == null)
            {
                return false;
            }
            else
            {
                return true;
            }
        }

        //用户注册
        public static bool UserRegister(User inUser)
        {
            if (UserService.QueryUserName(inUser))
            {
                return false;
            }
            else
            {
                UserService.AddUser(inUser);
                return true;
            }
        }

        

        public static User GetUserById(int userid)
        {
            return UserService.GetUserByUserId(userid);
        }
        public static IList<User> GetUserAll()
        {
            return UserService.GetUserAll();
        }
        public static User GetIdByUsername(string username)
        {
            return UserService.GetIdByUsername(username);
        }
        public static void DelUser(User user)
        {
            UserService.Del(user);
        }
        public static void UpUser(User user)
        {
            UserService.UpUser(user);
        }
        public static bool UpPwd(User user)
        {
            return UserService.UpPwd(user);
        }
        public static bool UpUserImage(User user)
        {
            return UserService.UpUserImage(user);
        }
    }

    }

