﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Models;
using System.Data.SqlClient;

namespace LoveDAL
{
    public static class ArticleService
    {
        private static string strcon = System.Configuration.ConfigurationManager.ConnectionStrings["strCon"].ConnectionString;
       //添加文章
        public static Boolean AddArticle(Article article)
        {
            bool check = false;
            string sql = "insert into article(arti_title,arti_contents,arti_time,arti_coteid,userid) values(@arti_title,@arti_contents,@arti_time,@arti_coteid,@userid)";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand(sql, con);

                cm.Parameters.AddWithValue("@arti_title", article.Arti_title);
                cm.Parameters.AddWithValue("@arti_contents", article.Arti_contents);
                cm.Parameters.AddWithValue("@arti_time", article.Arti_time);
                cm.Parameters.AddWithValue("@arti_coteid", article.Arti_codeid);
                cm.Parameters.AddWithValue("@userid", article.Userid);

                int checkAdd= cm.ExecuteNonQuery();
                if (checkAdd == 1)
                {
                    check = true;
                }
            }
            return check;
        }
        //更新文章
        public static void UpdateArticle(Article article)
        {
            string sql = "update article set arti_title=@arti_title,arti_contents=@arti_contents,arti_time=@arti_time where arti_id=@arti_id";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand();
                cm.Connection = con;
                cm.CommandText = sql;
                cm.Parameters.AddWithValue("@arti_id", article.Arti_id);
                cm.Parameters.AddWithValue("@arti_title", article.Arti_title);
                cm.Parameters.AddWithValue("@arti_contents", article.Arti_contents);
                cm.Parameters.AddWithValue("@arti_time", article.Arti_time);
                cm.ExecuteNonQuery();

            }
        }
         //查询所有的文章
        public static IList<Article> GetArticleAll()
        {
            string sql = "select * from article order by arti_time desc";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand();
                cm.Connection = con;
                cm.CommandText = sql;
                SqlDataReader dr = cm.ExecuteReader();
                List<Article> list = new List<Article>();
                while (dr.Read())
                {
                    Article article = new Article();
                    for (int i = 0; i < dr.FieldCount; i++)
                    {
                        string fieldName = dr.GetName(i);
                        if (fieldName == "arti_id")
                        {
                            article.Arti_id = (int)dr["arti_id"];

                        }
                        if (fieldName == "arti_title")
                        {
                            article.Arti_title = (string)dr["arti_title"];
                        }
                        if (fieldName == "arti_contents")
                        {
                            article.Arti_contents = (string)dr["arti_contents"];
                        }
                        if (fieldName == "arti_time")
                        {
                            article.Arti_time = (DateTime)dr["arti_time"];
                        }
                        if (fieldName == "userid")
                        {
                            article.Userid = (int)dr["userid"];
                            article.Username = UserService.GetUserByUserId((int)dr["userid"]).Username ;
                        }

                    }
                    list.Add(article);
                }
                dr.Close();
                return list;
            }
        }


        //查询所有的文章
        public static IList<Article> GetArticlePart()
        {
            string sql = "select top 7 * from article order by arti_time desc";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand();
                cm.Connection = con;
                cm.CommandText = sql;
                SqlDataReader dr = cm.ExecuteReader();
                List<Article> list = new List<Article>();
                while (dr.Read())
                {
                    Article article = new Article();
                    for (int i = 0; i < dr.FieldCount; i++)
                    {
                        string fieldName = dr.GetName(i);
                        if (fieldName == "arti_id")
                        {
                            article.Arti_id = (int)dr["arti_id"];

                        }
                        if (fieldName == "arti_title")
                        {
                            article.Arti_title = (string)dr["arti_title"];
                        }
                        if (fieldName == "arti_contents")
                        {
                            article.Arti_contents = (string)dr["arti_contents"];
                        }
                        if (fieldName == "arti_time")
                        {
                            article.Arti_time = (DateTime)dr["arti_time"];
                        }
                        if (fieldName == "userid")
                        {
                            article.Userid = (int)dr["userid"];
                            article.Username = UserService.GetUserByUserId((int)dr["userid"]).Username;
                        }

                    }
                    list.Add(article);
                }
                dr.Close();
                return list;
            }
        }

        //查询所有的感动故事
        public static IList<Article> GetStroyPart()
        {
            string sql = "select top 7 * from article where arti_coteid=8 order by arti_time desc";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand();
                cm.Connection = con;
                cm.CommandText = sql;
                SqlDataReader dr = cm.ExecuteReader();
                List<Article> list = new List<Article>();
                while (dr.Read())
                {
                    Article article = new Article();
                    for (int i = 0; i < dr.FieldCount; i++)
                    {
                        string fieldName = dr.GetName(i);
                        if (fieldName == "arti_id")
                        {
                            article.Arti_id = (int)dr["arti_id"];

                        }
                        if (fieldName == "arti_title")
                        {
                            article.Arti_title = (string)dr["arti_title"];
                        }
                        if (fieldName == "arti_contents")
                        {
                            article.Arti_contents = (string)dr["arti_contents"];
                        }
                        if (fieldName == "arti_time")
                        {
                            article.Arti_time = (DateTime)dr["arti_time"];
                        }
                        if (fieldName == "userid")
                        {
                            article.Userid = (int)dr["userid"];
                            article.Username = UserService.GetUserByUserId((int)dr["userid"]).Username;
                        }

                    }
                    list.Add(article);
                }
                dr.Close();
                return list;
            }
        }

        //通过作者查询文章
        public static IList<Article> GetArticleByUserId(int userid)
        {
            string sql = "select * from article where userid='" + userid+"'";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand();
                cm.Connection = con;
                cm.CommandText = sql;
                SqlDataReader dr = cm.ExecuteReader();
                List<Article> list = new List<Article>();
                while (dr.Read())
                {
                    Article article = new Article();
                    for (int i = 0; i < dr.FieldCount; i++)
                    {
                        string fieldName = dr.GetName(i);
                        if (fieldName == "arti_id")
                        {
                            article.Arti_id = (int)dr["arti_id"];
                           
                        }
                        if (fieldName == "userid")
                        {
                            article.Userid = (int)dr["userid"];
                            article.Username = UserService.GetUserByUserId((int)dr["userid"]).Username;

                           
                        }
                        if (fieldName == "arti_title")
                        {
                            article.Arti_title = (string)dr["arti_title"];
                        }
                        if (fieldName == "arti_text")
                        {
                            article.Arti_contents = (string)dr["arti_contents"];
                        }
                        if (fieldName == "arti_time")
                        {
                            article.Arti_time = (DateTime)dr["arti_time"];
                        }
                        if (fieldName == "arti_coteid")
                        {
                            article.Arti_cotename = ArticleCoteService.GetAriCoteById((int)dr["arti_coteid"]).Arti_cotename;
                        }

                    }
                    list.Add(article);
                }
                dr.Close();
                return list;
            }

        }
        //通过文章编号查文章
        public static IList<Article> GetAriById(int id)
        {
            string sql = "select * from article where arti_id=" + id;

            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand(sql, con);
                SqlDataReader dr = cm.ExecuteReader();
                List<Article> list = new List<Article>();
                while (dr.Read())
                {
                    Article article = new Article();
                    for (int i = 0; i < dr.FieldCount; i++)
                    {
                        string fieldName = dr.GetName(i);
                        if (fieldName == "arti_id")
                        {
                            article.Arti_id = (int)dr["arti_id"];

                        }
                        if (fieldName == "arti_title")
                        {
                            article.Arti_title = (string)dr["arti_title"];
                        }
                        if (fieldName == "arti_contents")
                        {
                            article.Arti_contents = (string)dr["arti_contents"];
                        }
                        if (fieldName == "arti_time")
                        {
                            article.Arti_time = (DateTime)dr["arti_time"];
                        }
                        if (fieldName == "userid")
                        {
                            article.Userid = (int)dr["userid"];
                            article.Username = UserService.GetUserByUserId((int)dr["userid"]).Username;
                        }
                        if (fieldName == "arti_coteid")
                        {
                            article.Arti_codeid = (int)dr["arti_coteid"];
                            article.Arti_cotename = ArticleCoteService.GetAriCoteById((int)dr["arti_coteid"]).Arti_cotename;
                        }

                    }
                    list.Add(article);
                }
                dr.Close();
                return list;
            }
        }

            
        
        //删除文章
        public static void DeleteArticle(Article article)
        {
            string sql = "delete from article where arti_id=@arti_id";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand();
                cm.Connection = con;
                cm.CommandText = sql;
                cm.Parameters.AddWithValue("@arti_id", article.Arti_id);
                cm.ExecuteNonQuery();
            }
        }
        //统计文章数目
        public static int GetArticleNumber()
        {
            string sql = "select count(*) from article";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand(sql, con);
                int article_num = Convert.ToInt32(cm.ExecuteScalar());
                return article_num;
            }

        }
        //截取字段
        public static string GetPartString(string article_contents, int n)
        {
            if (article_contents.ToString().Length > n - 2)
            {
                return article_contents.ToString().Substring(0, n - 2) + "...";

            }
            else
            {
                return article_contents.ToString();

            }
        }
       


    }
}
