﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Configuration;
using System.Data.SqlClient;
using Models;
namespace LoveDAL
{
    public static class GoodsService
    {
        private static string strcon = System.Configuration.ConfigurationManager.ConnectionStrings["strCon"].ConnectionString;
        //删除物品
        public static void DelGoods(Goods goods)
        {
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                string sql = "delete from Goods where goodsid=@goodsid";
                SqlCommand cm = new SqlCommand(sql, con);
                cm.Parameters.AddWithValue("@goodsid", goods.Goodsid);
                cm.ExecuteNonQuery();
            }
        }
        //添加物品
        public static void AddGoods(Goods goods)
        {
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                string sql = "insert into Goods(goodsname,introduce,author,goodstime,goodsImage) values(@goodsname,@introduce,@author,@goodstime,@goodsImage)";

                SqlCommand cm = new SqlCommand(sql, con);
                cm.Parameters.AddWithValue("@goodsname", goods.Goodsname);
                cm.Parameters.AddWithValue("@introduce", goods.Introduce);
                cm.Parameters.AddWithValue("@goodstime", System.DateTime.Now);
                cm.Parameters.AddWithValue("@author", goods.Author);
                cm.Parameters.AddWithValue("@goodsImage", goods.GoodsImage);
                cm.ExecuteNonQuery();
            }
        }
        //修改物品
        public static void UpdateGoods(Goods goods)
        {
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                string sql = "Update Goods set goodsname=@goodsname,introduce=@introduce,author=@author,goodstime=@goodstime where goodsid=@id";
                SqlCommand cm = new SqlCommand(sql, con);
                cm.Parameters.AddWithValue("@goodsname", goods.Goodsname);
                cm.Parameters.AddWithValue("@introduce", goods.Introduce);
                cm.Parameters.AddWithValue("@goodstime", System.DateTime.Now);
                cm.Parameters.AddWithValue("@author", goods.Author);
                cm.Parameters.AddWithValue("@id", goods.Goodsid);
                cm.ExecuteNonQuery();
            }
        }
        //查询所有物品
        public static IList<Goods> GetGoodsAll()
        {
            string sql = "select * from Goods order by goodstime desc";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand();
                cm.Connection = con;
                cm.CommandText = sql;
                SqlDataReader dr = cm.ExecuteReader();
                List<Goods> list = new List<Goods>();
                while (dr.Read())
                {
                    Goods goods = new Goods();
                    for (int i = 0; i < dr.FieldCount; i++)
                    {
                        string fieldName = dr.GetName(i);
                        if (fieldName == "goodsid")
                        {
                            goods.Goodsid = (int)dr["goodsid"];

                        }
                        if (fieldName == "goodsname")
                        {
                            goods.Goodsname = (string)dr["goodsname"];
                        }
                        if (fieldName == "introduce")
                        {
                            goods.Introduce = (string)dr["introduce"];
                        }
                        if (fieldName == "goodstime")
                        {
                            goods.Goodstime = (DateTime)dr["goodstime"];
                        }
                        if (fieldName == "author")
                        {
                            goods.Author = (string)dr["author"];
                        }
                        if (fieldName == "goodsImage")
                        {
                            goods.GoodsImage = (string)dr["goodsImage"];
                        }

                    }
                    list.Add(goods);
                }
                dr.Close();
                return list;
            }
        }
        //通过物品编号查详细
        public static IList<Goods> GetGoodsById(int id)
        {
            string sql = "select * from Goods where goodsid=" + id;

            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand(sql, con);
                SqlDataReader dr = cm.ExecuteReader();
                List<Goods> list = new List<Goods>();
                while (dr.Read())
                {
                    Goods goods = new Goods();
                    for (int i = 0; i < dr.FieldCount; i++)
                    {
                        string fieldName = dr.GetName(i);
                        if (fieldName == "goodsid")
                        {
                             goods.Goodsid= (int)dr["goodsid"];

                        }
                        if (fieldName == "goodsname")
                        {
                           goods.Goodsname = (string)dr["goodsname"];
                        }
                        if (fieldName == "introduce")
                        {
                            goods.Introduce = (string)dr["introduce"];
                        }
                        if (fieldName == "goodstime")
                        {
                           goods.Goodstime = (DateTime)dr["goodstime"];
                        }
                        if (fieldName == "author")
                        {
                            goods.Author = (string)dr["author"]; 
                        }
                        if (fieldName == "goodsImage")
                        {
                            goods.GoodsImage = (string)dr["goodsImage"];
                        }
                    }
                    list.Add(goods);
                }
                dr.Close();
                return list;
            }
        }
        public static int GetGoodsNum()
        {
            string sql = "select count(*) from Goods ";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand(sql, con);
                int goods_num = Convert.ToInt32(cm.ExecuteScalar());
                return goods_num;
            }
        }


        //截取字段
        public static string GetPartString(string introduce, int n)
        {
            if (introduce.ToString().Length > n - 2)
            {
                return introduce.ToString().Substring(0, n - 2) + "...";

            }
            else
            {
                return introduce.ToString();

            }
        }
    }
}
