﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Models;
using System.Configuration;
using System.Data.SqlClient;
namespace LoveDAL
{
    public static class NewsCoteService
    {
        private static string connectionString = ConfigurationManager.ConnectionStrings["strCon"].ConnectionString;
      //添加新闻类别
        public static bool AddNewsCote(NewsCote newscote)
        {
             bool checkAdd = false;
             using (SqlConnection cn = new SqlConnection(connectionString))
             {
                 cn.Open();
                 string sql = "insert into newscote(news_cotename) values(@newscotename)";
                 SqlCommand cm = new SqlCommand(sql, cn);
                 cm.Parameters.AddWithValue("@newscotename", newscote.News_cotename);
                 int check = cm.ExecuteNonQuery();
                 if (check == 1)
                 {
                     checkAdd = true;
                 }
             }
             return checkAdd;
        }
        //删除新闻类别
        public static void DeleteNewsCategory(NewsCote newsCategory)
        {
            using (SqlConnection cn = new SqlConnection(connectionString))
            {
                cn.Open();
                SqlCommand cm = new SqlCommand();
                cm.Connection = cn;
                string sql = "delete from newscote where news_coteid=@Id";
                cm.CommandText = sql;
                cm.Parameters.AddWithValue("@Id", newsCategory.News_coteid);
                cm.ExecuteNonQuery();
            }
        }
        //修改新闻类别
        public static void UpNewsCategory(NewsCote newsCategory)
        {
            using (SqlConnection cn = new SqlConnection(connectionString))
            {
                cn.Open();
                SqlCommand cm = new SqlCommand();
                cm.Connection = cn;
                string sql = "update newscote set news_cotename=@Name where news_coteid=@id";
                cm.CommandText = sql;
                cm.Parameters.AddWithValue("@Id", newsCategory.News_coteid);
                cm.Parameters.AddWithValue("@Name", newsCategory.News_cotename);
                cm.ExecuteNonQuery();
            }

        }
        //将所有的新闻类别查出
        public static IList<NewsCote> GetNewsCoteAll()
        {
            using (SqlConnection cn = new SqlConnection(connectionString))
            {
                cn.Open();
                SqlCommand cm = new SqlCommand();
                cm.Connection = cn;
                string sql = "select * from newscote";
                cm.CommandText = sql;
                SqlDataReader dr = cm.ExecuteReader();
                List<NewsCote> list = new List<NewsCote>();
                while (dr.Read())
                {
                    NewsCote newsCategory = new NewsCote();
                    newsCategory.News_coteid = (int)dr["news_coteid"];
                    newsCategory.News_cotename = (string)dr["news_cotename"];
                    list.Add(newsCategory);
                }
                dr.Close();
                return list;
            }
        }
        //通过新闻类别ID查新闻类别
        public static NewsCote GetNewsCategoryById(int id)
        {
            using (SqlConnection cn = new SqlConnection(connectionString))
            {
                cn.Open();
                SqlCommand cm = new SqlCommand();
                cm.Connection = cn;
                string sql = "select * from newscote where news_coteid=@Id";
                cm.CommandText = sql;
                cm.Parameters.AddWithValue("@Id", id);
                SqlDataReader dr = cm.ExecuteReader();
                if (dr.Read())
                {
                    NewsCote newsCategory = new NewsCote();
                    newsCategory.News_coteid = (int)dr["news_coteid"];
                    newsCategory.News_cotename = (string)dr["news_cotename"];
                    dr.Close();
                    return newsCategory;
                }
                else
                {
                    dr.Close();
                    return null;
                }
            }
        }
    }
}
