﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Models;
using System.Data;
using System.Configuration;
using System.Data.SqlClient;

namespace LoveDAL
{
    public static class VoteService
    {
        private static string strcon = System.Configuration.ConfigurationManager.ConnectionStrings["strCon"].ConnectionString;
        /* 添加问题*/
        public static Boolean InsertQuestion(Qest qest_tb, int id, int quesid)
        {
            bool check = false;
            int n = id % 3;
            string sql = "update ques set answer_"+n+"=@answer_"+n+"  where quesid= "+quesid;
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cmd = new SqlCommand(sql, con);
                if (n == 1)
                {
                    cmd.Parameters.AddWithValue("@answer_1", qest_tb.Answer_1);
                }
                else if (n == 2)
                {
                    cmd.Parameters.AddWithValue("@answer_2", qest_tb.Answer_2);
                }
                else
                {
                    cmd.Parameters.AddWithValue("@answer_3", qest_tb.Answer_3);
                }

                int checkAdd = cmd.ExecuteNonQuery();
                if (checkAdd == 1)
                {
                    check = true;
                }
            }
            return check;
        }

       

    //    public static void UpadateQuest(Qest qest_tb)
    //    {
    //        string sql = "update qest_tb set answer_1=@answer_1,answer_2=@answer_2,answer_3=@answer_3 where id=@id";
    //        using (SqlConnection con = new SqlConnection(strcon))
    //        {
    //            con.Open();
    //            SqlCommand cmd = new SqlCommand();
    //            cmd.Connection = con;
    //            cmd.CommandText = sql;
    //            cmd.Parameters.AddWithValue("@id", qest_tb.Id);
    //            cmd.Parameters.AddWithValue("@answer_1", qest_tb.Answer_1);
    //            cmd.Parameters.AddWithValue("@answer_2", qest_tb.Answer_2);
    //            cmd.Parameters.AddWithValue("@answer_3", qest_tb.Answer_3);
    //            cmd.ExecuteNonQuery();

    //        }
    //    }



        //查询问题和答案选项
        public static IList<Qest> GetQestAndAnswerAll()
        {
            using (SqlConnection cn = new SqlConnection(strcon))
            {
                cn.Open();
                SqlCommand cm = new SqlCommand();
                cm.Connection = cn;
                string sql = "select * from ques";
                cm.CommandText = sql;
                SqlDataReader dr = cm.ExecuteReader();
                List<Qest> list = new List<Qest>();
                while (dr.Read())
                {
                    Qest q = new Qest();
                    q.Quesid = (int)dr["quesid"];
                    q.Question = (string)dr["question"];
                    q.Answer_1 = (int)dr["answer_1"];
                    q.Answer_2 = (int)dr["answer_2"];
                    q.Answer_3 = (int)dr["answer_3"];
                    list.Add(q);
                }
                dr.Close();
                return list;
            }
        }


        public static Qest GetQestById(int quesid)
        {
            string sql = "select * from ques where quesid=@quesid";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cmd = new SqlCommand();
                cmd.Connection = con;
                cmd.CommandText = sql;
                cmd.Parameters.AddWithValue("@quesid", quesid);
                SqlDataReader dr = cmd.ExecuteReader();
                Qest q = new Qest();
                if (dr.Read())
                {

                    q.Quesid = (int)dr["quesid"];
                    q.Question = (string)dr["question"];
                    q.Answer_1 = (int)dr["answer_1"];
                    q.Answer_2 = (int)dr["answer_2"];
                    q.Answer_3 = (int)dr["answer_3"];

                    dr.Close();


                }
                return q;

            }

        }

        public static IList<Qest> GetQestAll()
        {
            string sql = "select * from ques ";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cmd = new SqlCommand();
                cmd.Connection = con;
                cmd.CommandText = sql;
                SqlDataReader dr = cmd.ExecuteReader();
                List<Qest> list = new List<Qest>();
                while (dr.Read())
                {
                    Qest qest = new Qest();
                    for (int i = 0; i < dr.FieldCount; i++)
                    {
                        string fieldName = dr.GetName(i);
                        if (fieldName == "quesid")
                        {
                            qest.Quesid = (int)dr["quesid"];
                        }
                        if (fieldName == "question")
                        {
                            qest.Question = (string)dr["question"];
                        }
                       
                    }
                    list.Add(qest);
                }
                dr.Close();
                return list;
            }

        }

        public static IList<Answer> GetAnswerByQestId(int quesid)
        {
            string sql = "select * from answer where quesid=@quesid";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cmd = new SqlCommand();
                cmd.Connection = con;
                cmd.CommandText = sql;
                cmd.Parameters.AddWithValue("@quesid", quesid);
                
                SqlDataReader dr = cmd.ExecuteReader();
                List<Answer> list = new List<Answer>();
                while (dr.Read())
                {
                    Answer a = new Answer();
                    for (int i = 0; i < dr.FieldCount; i++)
                    {
                        string fieldName = dr.GetName(i);
                        if (fieldName == "answerid")
                        {
                            a.Answerid = (int)dr["answerid"];
                        
                        }
                        if (fieldName == "answername")
                        {
                            a.Answername = (string)dr["answername"];
                        }
                    }
                    list.Add(a);
                }
                dr.Close();
                return list;
            }

        }

    }
}
