﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using Models;
using LoveBLL;

namespace LoveWeb
{
    public partial class ForumView : System.Web.UI.Page
    {
        
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                if (Request.QueryString["id"] != null)
                {
                    int id = Convert.ToInt32(Request.QueryString["id"]);

                    //点击帖子次数加1
                    Invitation invi = InvitationManager.GetInvitationByid(id);
                    invi.Invi_click += 1;
                    InvitationManager.UpInvi_click(invi);


                    Session["revi_id"] = id;
                    //详细帖子
                    InviBind(id);
                    //回复显示
                    ReviBind(id);

                }
                else if (Session["revi_id"] != null)
                {
                    int back_id = Convert.ToInt32(Session["revi_id"].ToString());
                    Session["revi_id"] = back_id;
                    InviBind(back_id);
                    ReviBind(back_id);
                    string username = Session["username"].ToString();
                    Label1.Text = username;
                    Session["username"] = username;

                }
            }
            else
            {
                int back_id = Convert.ToInt32(Session["revi_id"].ToString());
                InviBind(back_id);
                ReviBind(back_id);
            }

           
            
        }
        public void InviBind(int id)
        {
            PagedDataSource pds = new PagedDataSource();
            pds.DataSource = InvitationManager.GetInviById(id);
            DataList1.DataSource = pds;
            DataList1.DataBind();
        }
        public void ReviBind(int id)
        {
      
            PagedDataSource pds = new PagedDataSource();
            pds.DataSource = ReviewManager.GetReviewByInviId(id);
            pds.AllowPaging = true;//设置PagedDataSource允许分页
            pds.PageSize = AspNetPager1.PageSize;//将PagedDataSource分页设置成ASPNetPaging的分页
            pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
            AspNetPager1.RecordCount = ReviewManager.GetReviewNumber(id);//获取所有的新闻记录条数
            DataList2.DataSource = pds;
            DataList2.DataBind();

        }
        
        protected void Button1_Click(object sender, EventArgs e)
        {

            int id = (int)Session["revi_id"];
            if (Label1.Text!="")
            {
                Reviews r = new Reviews();
                r.Revi_contents = FCK_invi.Value;
               // r.Username = Session["username"].ToString();
                r.Submit_date = System.DateTime.Now;
                r.Userid = UserManager.GetIdByUsername(Label1.Text).Userid;
                ReviewManager.AddReview(r,id);
                
                Response.Redirect("ForumView.aspx");
            }
            else
            {
                Session["sort"] = "ForumView";
                Response.Write(" <script language=javascript> if  (window.confirm( '确认登录？ ')){window.location.href='Login/Login.aspx';}</script>");
                //Response.Write("<script>alert('请先登录！')</script>");
                //Response.Redirect("~/Login/Login.aspx");
            }
        }

        protected void Button2_Click(object sender, EventArgs e)
        {
            Response.Redirect("~/Forum_add.aspx");
        }

        protected void AspNetPager1_PageChanged(object sender, EventArgs e)
        {
            int back_id = Convert.ToInt32(Session["revi_id"].ToString());
            Session["revi_id"] = back_id;
            InviBind(back_id);
            ReviBind(back_id);
        }

        protected void Button3_Click(object sender, EventArgs e)
        {
            Response.Redirect("~/Forum.aspx");
        }

        protected void ImageButton1_Click(object sender, ImageClickEventArgs e)
        {
            Response.Redirect("~/Forum_add.aspx");
        }

        protected void ImageButton2_Click(object sender, ImageClickEventArgs e)
        {
            
            int id = (int)Session["revi_id"];
            if (Label1.Text != "")
            {

                Reviews r = new Reviews();
                r.Revi_contents = FCK_invi.Value;
                // r.Username = Session["username"].ToString();
                r.Submit_date = System.DateTime.Now;
                r.Userid = UserManager.GetIdByUsername(Label1.Text).Userid;
                ReviewManager.AddReview(r, id);

                Response.Redirect("ForumView.aspx");
            }
            else
            {
                Session["sort"] = "ForumView";
                Response.Write(" <script language=javascript> if  (window.confirm( '确认登录？ ')){window.location.href='Login/Login.aspx';}</script>");
                //Response.Redirect("~/Login/Login.aspx");
            }
        }

        protected void ImageButton3_Click(object sender, ImageClickEventArgs e)
        {
            Response.Redirect("~/Forum.aspx");
        }
    }
}
