﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Text;
using DAL;
namespace BLL
{
   public class AccountBiz
    {
       AccountDao accountDao = new AccountDao();

       #region 公用
       public bool Update(string tableName, SortedDictionary<string, string> sdList)
       {
           return new BuiltSQL().UpdateTable(tableName, sdList);
       }
       public bool Insert(string tableName, SortedDictionary<string, string> sdList)
       {
           return new BuiltSQL().InsertTable(tableName, sdList);
       }

       #endregion

       public bool IsExist(String account)
       {
           DataTable dt=GetOneInfo(account);
           if (dt == null) return false;
           if (dt.Rows.Count < 1) return false;
           else return true;
       }
       public bool ExecSQL(string strSQL)
       {
           return accountDao.ExecSQL(strSQL);
       }
       public bool UpdateStatu(string account, string statu)
       {
           return accountDao.UpdateStatu( account, statu);
       }
       public bool DeleteOneInfo(string account)
       {
           return accountDao.DeleteOneInfo(account);
       }
       public DataTable GetOneInfo(string account)
       {
           return accountDao.GetOneInfo(account);
       }

       public DataTable GetOneInfo(string account,string pwd)
       {
           return accountDao.GetOneInfo(account,pwd);
       }
       //获取账号列表，用来绑定dll，用在权限拷贝时使用
       public DataTable GetLists(string statu)
       {
           return accountDao.GetLists(statu);
       }
       public DataTable GetLists(string serWord, string deptID, string statu)
       {
           return accountDao.GetLists(serWord, deptID,statu);
       }
       //获取一个工号的所有账号
       public DataTable GetAllInfo(string empCode)
       {
           return accountDao.GetAllInfo(empCode);
       }
       public DataTable GetMenuByAccount(string account)
       {
           return accountDao.GetMenuByAccount(account);
       }
       public bool CopyRightsTo(string sourceAccount, string receiveAccount, bool copyType)
       {
           return accountDao.CopyRightsTo(sourceAccount, receiveAccount,copyType);
       }
       public bool SetMenuRight(ArrayList menuArray, string strRight, string rangeLimit)
       {
           return accountDao.SetMenuRight(menuArray, strRight, rangeLimit);
       }
       public static bool CheckRight(string account, string menuUrl, RightChar rightChar)
       {
           return AccountDao.CheckRight(account, menuUrl, rightChar);
       }
       public static bool IsSuperGroup(string account)
       {
           return AccountDao.IsSuperGroup(account);
       }
       public static RangeChar GetRange(string account, string menuUrl)
       {
           return AccountDao.GetRange(account, menuUrl);
       }
       //获取一个部门下 的账号列表  客户管理界面的下拉列表使用
       public DataTable GetListByDeptID(string deptID)
       {return accountDao.GetListByDeptID(deptID);
       }
      
    }
}
