﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using DAL;
//检查按钮操作权限
namespace BLL
{
    public  class CheckRight
    {
        MenuBiz menuBiz = new MenuBiz();

        #region 不传递account检查菜单具有的权限
        //
        // 在BIZ/UI使用范例 if (!checkRight.Check("Update")) return "无操作权限";
        public  bool Check(string actionType)
        {
            bool flag = true;           
          
            switch (actionType)
            {
                case "Insert":
                    flag = CheckUrl(RightChar.Add);
                    break;
                case "Update":
                    flag = CheckUrl(RightChar.Mod);
                    break;
                case "Delete":
                    flag = CheckUrl(RightChar.Del);
                    break;
                case "Search":
                    flag = CheckUrl(RightChar.Ser);
                    break;
                case "Import":
                    flag = CheckUrl(RightChar.In);
                    break;
                case "Export":
                    flag = CheckUrl(RightChar.Out);
                    break;
                case "Print":
                    flag = CheckUrl(RightChar.Print);
                    break;
                case "Check":
                    flag = CheckUrl(RightChar.Check);
                    break;
                case "CancelCheck":
                    flag = CheckUrl(RightChar.CancelCheck);
                    break;
                case "Approve":
                    flag = CheckUrl(RightChar.Approve);
                    break;
                case "CancelApprove":
                    flag = CheckUrl(RightChar.CancelApprove);
                    break;
                case "Fei":
                    flag = CheckUrl(RightChar.Fei);
                    break;
                case "CancelFei":
                    flag = CheckUrl(RightChar.CancelFei);
                    break;
                case "Config":
                    flag = CheckUrl(RightChar.Set);//设置
                    break;
                
                default:
                    break;
            }
           
            return flag;
        }
        //检测菜单权限 设置按钮功能
        public  bool CheckUrl(RightChar rightChar)
        {
            string account = "";
            if (HttpContext.Current.Session["user"] != null)
            {
                User user = HttpContext.Current.Session["user"] as User;
                account = user.Account;
            }
            else
            {               
                return false;
            }
            string url = GetRightUrl(account);
   
            return AccountBiz.CheckRight(account, url, rightChar);
        }


        #endregion
        #region 传递account检测
        //判断各个按钮 界面层或，业务逻辑层的执行
        // if (!checkRight.Check("Search", account)) 
        //    { lbAmount.Text = "没有查询权限"; }
        public bool Check(string actionType,string account)
        {
            bool flag = true;

            switch (actionType)
            {
                case "Insert":
                    flag = CheckUrl(RightChar.Add, account);
                    break;
                case "Update":
                    flag = CheckUrl(RightChar.Mod, account);
                    break;
                case "Delete":
                    flag = CheckUrl(RightChar.Del, account);
                    break;
                case "Search":
                    flag = CheckUrl(RightChar.Ser, account);
                    break;
                case "Import":
                    flag = CheckUrl(RightChar.In, account);
                    break;
                case "Export":
                    flag = CheckUrl(RightChar.Out, account);
                    break;
                case "Print":
                    flag = CheckUrl(RightChar.Print, account);
                    break;
                case "Check":
                    flag = CheckUrl(RightChar.Check, account);
                    break;
                case "Approve":
                    flag = CheckUrl(RightChar.Approve, account);
                    break;
                case "Fei":
                    flag = CheckUrl(RightChar.Fei, account);
                    break;
                case "Config":
                    flag = CheckUrl(RightChar.Set,account);//设置
                    break;
              
                default:
                    break;
            }

            return flag;
        }
        //判断URL是否赋予了权限
        private bool CheckUrl(RightChar rightChar,string account)
        {           
            string url = GetRightUrl(account);
            return AccountBiz.CheckRight(account, url, rightChar);
        }
        #endregion

        //判断add是否在 自己的设定菜单里面
        public string GetRightUrl(string account)
        {
            string url = HttpContext.Current.Request.Url.AbsolutePath;
            url = "~" + url;
            if (!menuBiz.GetOneInfoByUrl(url,account))
            {
                url = url.Replace("Add.aspx", "List.aspx");
            }
            return url;
        }
    
    }
}
