﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Text;
using System.Web.UI.WebControls;
using DAL;
using Utils;
//定义各类字典
//字典结构必须为：ID，NAME,MEMO
namespace BLL
{
    public class DefDicBiz
    {
        BuiltSQL builtSQL = new BuiltSQL();
        DefDicDao defDicDao = new DefDicDao();
        public bool ExecSQL(string strSQL)
        {
            return defDicDao.ExecSQL(strSQL);
        }
        //存在 true 不存在是 false
        public bool IsExistOneInfo(string tableName, string name)
        {
            bool flag = true;
            string count = defDicDao.GetNumber(tableName,"[NAME]", name);
            try
            {
                if (Int32.Parse(count) <= 0) flag = false;
            }
            catch
            {
                flag = false;
            }
            return flag;
        }
        //根据ID获取一条记录
        public DataTable GetOneInfo(string tableName, string id)
        {
            return defDicDao.GetOneInfo(tableName, id);
        }
        //根据名字获取一条记录
        public DataTable GetOneInfo(string tableName, string name, string statu)
        {
            return defDicDao.GetOneInfo(tableName, name, statu);
        }
        public bool Update(string tableName, SortedDictionary<string, string> sdList)
        {
            return builtSQL.UpdateTable(tableName, sdList);
        }
        /// <summary>
        /// 插入字典数据
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="sdList"></param>
        public void Insert(string tableName, SortedDictionary<string, string> sdList)
        {
            builtSQL.InsertTable(tableName, sdList);
        }

        public string Delete(string tableName, string[] primaryKey)
        {
            return builtSQL.DeleteTable(tableName, primaryKey);
        }

        /// <summary>
        /// 检索数据显示在gridview，包含：ID,NAME，MEMO
        /// </summary>
        /// <param name="tableName"></param>
        /// <returns></returns>
        public DataTable GetLists(string tableName, string statu)
        {
            return defDicDao.GetLists(tableName, statu);
        }
        public DataTable GetLists(string tableName, string serWord, string statu)
        {
            return defDicDao.GetLists(tableName, serWord,statu);
        }
       
        /// <summary>
        /// 自动完成使用
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="key">不完全显示时的参数</param>
        /// <param name="isFull">是否完全显示</param>
        /// <returns></returns>
        public string AutoComplete(string tableName, string key, bool isFull)
        {
            DataTable dt = defDicDao.GetLists(tableName, key, isFull);
            StringBuilder items = new StringBuilder();
            for (int r = 0; r < dt.Rows.Count; r++)
            {
                items.Append(dt.Rows[r]["Name"] + "\n");
            }
            return items.ToString();
        }

        //绑定DT
        public void InitDropDownList(DataTable dt, DropDownList dropDownList)
        {
            dropDownList.Items.Clear();
            //DataRow dr = dt.NewRow();
            //dr["ID"] = "0";
            //dr["Name"] = "请选择";
            //dt.Rows.InsertAt(dr, 0);
            //dropDownList.DataSource = dt;
            //dropDownList.DataTextField = "Name";
            //dropDownList.DataValueField = "ID";
            //dropDownList.DataBind();
            dropDownList.Items.Add(new ListItem("请选择", "0"));
            for (int r = 0; r < dt.Rows.Count; r++)
            {
                dropDownList.Items.Add(new ListItem(dt.Rows[r]["Name"].ToString(), dt.Rows[r]["ID"].ToString()));
            }
        }
        public void InitDropDownList(DataTable dt, DropDownList dropDownList, string defaultSelectItem)
        {
            if (string.IsNullOrWhiteSpace(defaultSelectItem)) defaultSelectItem = "0";
            dropDownList.Items.Clear();
            //DataRow dr = dt.NewRow();
            //dr["ID"] = "0";
            //dr["Name"] = "请选择";
            //dt.Rows.InsertAt(dr, 0);

            //dropDownList.DataSource = dt;
            //dropDownList.DataTextField = "Name";
            //dropDownList.DataValueField = "ID";
            //dropDownList.DataBind();
            //if (RegexRule.IsInt(defaultSelectItem))
            //    dropDownList.Items.FindByValue(defaultSelectItem).Selected = true;
            //else
            //    dropDownList.Items.FindByText(defaultSelectItem).Selected = true;

            dropDownList.Items.Add(new ListItem("请选择", "0"));
            for (int r = 0; r < dt.Rows.Count; r++)
            {
                dropDownList.Items.Add(new ListItem(dt.Rows[r]["Name"].ToString(), dt.Rows[r]["ID"].ToString()));
                if (defaultSelectItem == "0" || string.IsNullOrWhiteSpace(defaultSelectItem))
                    dropDownList.SelectedValue = "0";
                else
                {
                    if (RegexRule.IsInt(defaultSelectItem))
                    {
                        if (defaultSelectItem == dt.Rows[r]["ID"].ToString())
                        {
                            dropDownList.ClearSelection();
                            for (int i = 0; i < dropDownList.Items.Count; i++)
                            {
                                if (dropDownList.Items[i].Value == defaultSelectItem)
                                {
                                    dropDownList.Items[i].Selected = true;
                                }
                            }

                        }
                        // dropDownList.SelectedValue = defaultSelectItem;
                    }
                    else
                    {
                        if (defaultSelectItem == dt.Rows[r]["Name"].ToString())
                        // dropDownList.SelectedItem.Text = defaultSelectItem;
                        {
                            dropDownList.ClearSelection();
                            for (int i = 0; i < dropDownList.Items.Count; i++)
                            {
                                if (dropDownList.Items[i].Text == defaultSelectItem)
                                {
                                    dropDownList.Items[i].Selected = true;
                                }
                            }
                        }

                    }
                }
            }
        }
        /// <summary>
        /// 初始化dropDownList
        /// </summary>
        /// <param name="tableName">表名</param>
        /// <param name="dropDownList">下拉列表ID</param>
        public void InitDropDownList(string tableName, DropDownList dropDownList, string defaultSelectItem)
        {
            if (string.IsNullOrWhiteSpace(defaultSelectItem)) defaultSelectItem = "0";
            dropDownList.Items.Clear();
            DataTable dt = defDicDao.GetInItLists(tableName);
            //DataRow dr = dt.NewRow();
            //dr["ID"] = "0";
            //dr["Name"] = "请选择";
            //dt.Rows.InsertAt(dr, 0);
            //dropDownList.DataSource = dt;
            //dropDownList.DataTextField = "Name";
            //dropDownList.DataValueField = "ID";
            //dropDownList.DataBind();
            //if (RegexRule.IsInt(defaultSelectItem))
            //    dropDownList.Items.FindByValue(defaultSelectItem).Selected = true;
            //else
            //    dropDownList.Items.FindByText(defaultSelectItem).Selected = true;


            dropDownList.Items.Add(new ListItem("请选择", "0"));

            for (int r = 0; r < dt.Rows.Count; r++)
            {
                dropDownList.Items.Add(new ListItem(dt.Rows[r]["Name"].ToString(), dt.Rows[r]["ID"].ToString().Trim()));

                if (defaultSelectItem == "0" || string.IsNullOrWhiteSpace(defaultSelectItem))
                    dropDownList.SelectedValue = "0";
                else
                {
                    if (RegexRule.IsInt(defaultSelectItem))
                    {
                        if (defaultSelectItem == dt.Rows[r]["ID"].ToString())
                        {
                            dropDownList.ClearSelection();
                            for (int i = 0; i < dropDownList.Items.Count; i++)
                            {
                                if (dropDownList.Items[i].Value == defaultSelectItem)
                                {
                                    dropDownList.Items[i].Selected = true;
                                }
                            }

                        }
                        // dropDownList.SelectedValue = defaultSelectItem;
                    }
                    else
                    {
                        if (defaultSelectItem == dt.Rows[r]["Name"].ToString().Trim())
                        // dropDownList.SelectedItem.Text = defaultSelectItem;
                        {
                            dropDownList.ClearSelection();
                            for (int i = 0; i < dropDownList.Items.Count; i++)
                            {
                                if (dropDownList.Items[i].Text == defaultSelectItem)
                                {
                                    dropDownList.Items[i].Selected = true;
                                }
                            }
                        }

                    }
                }
            }
        }
        /// <summary>
        /// 绑定常量ddl id和name一样
        /// </summary>
        /// <param name="dropDownList"></param>
        /// <param name="defaultSelectItem"></param> 
        public void InitDropDownList(DropDownList dropDownList, string defaultSelectItem)
        {
            if (string.IsNullOrWhiteSpace(defaultSelectItem)) defaultSelectItem = "0";
            dropDownList.ClearSelection();
            //if (RegexRule.IsInt(defaultSelectItem))
            //    dropDownList.Items.FindByValue(defaultSelectItem).Selected = true;
            //else
            //    dropDownList.Items.FindByText(defaultSelectItem).Selected = true;

            if (RegexRule.IsInt(defaultSelectItem))
            {
                for (int i = 0; i < dropDownList.Items.Count; i++)
                {
                    if (dropDownList.Items[i].Value.Trim() == defaultSelectItem)
                    {

                        dropDownList.Items[i].Selected = true;
                    }
                }
            }
            else
            {
                for (int i = 0; i < dropDownList.Items.Count; i++)
                {
                    if (dropDownList.Items[i].Text == defaultSelectItem)
                    {
                        dropDownList.Items[i].Selected = true;
                    }
                }
            }

        }
        /// <summary>
        /// 表定义的不标准的时候
        /// 初始化下拉列表
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="dropDownList"></param>
        /// <param name="defaultSelectItem"></param>
        /// <param name="fields">field1,field2</param>
        public void InitDropDownList(string tableName, DropDownList dropDownList, string defaultSelectItem, string fields)
        {
            string[] item = fields.Split(',');
            if (item.Length < 2) return;
            DataTable dt = GetItems(tableName, fields);
            if (dt == null) return;
            dropDownList.DataTextField = item[0].Trim();
            dropDownList.DataValueField = item[1].Trim();            
            dropDownList.DataSource = dt;
            dropDownList.DataBind();
            if (!string.IsNullOrWhiteSpace(defaultSelectItem))
                dropDownList.SelectedValue = defaultSelectItem;
           
        }
        /// <summary>
        /// 绑定常量ddl id和name 不一样 且只认name
        /// </summary>
        /// <param name="dropDownList"></param>
        /// <param name="defaultSelectItem"></param>
        public void InitSynDropDownList(DropDownList dropDownList, string defaultSelectItem)
        {
            if (string.IsNullOrWhiteSpace(defaultSelectItem)) defaultSelectItem = "0";
            dropDownList.ClearSelection();
           // dropDownList.Items.FindByText(defaultSelectItem).Selected = true;
            for (int i = 0; i < dropDownList.Items.Count; i++)
            {
                if (dropDownList.Items[i].Text == defaultSelectItem)
                {
                    dropDownList.Items[i].Selected = true;
                }
            }
        }
        //绑定值为字符时
        public void InitSynDropDownList2(DropDownList dropDownList, string defaultSelectItem)
        {
            if (string.IsNullOrWhiteSpace(defaultSelectItem)) defaultSelectItem = "0";
            dropDownList.ClearSelection();
            //dropDownList.Items.FindByValue(defaultSelectItem).Selected = true;
            for (int i = 0; i < dropDownList.Items.Count; i++)
            {
                if (dropDownList.Items[i].Value == defaultSelectItem)
                {
                    dropDownList.Items[i].Selected = true;
                }
            }
        }

        public void InitXMLDropDownList(DropDownList dropDownList, string fileName, string defaultItem)
        {
            XmlUtility.InitXMLDropDownList(dropDownList, fileName, defaultItem);
            dropDownList.SelectedValue = defaultItem;
        }

        public DataTable GetItems(string tableName, string fields)
        {
            return defDicDao.GetItems(tableName, fields);
        }

    }
}
