﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using DAL;
namespace BLL
{
    public class BizSQL : IBizSQL
    {
        IBuiltSQL ibs = new BuiltSQL();
        //获取一条信息
        public DataTable GetOneInfo(string tableName, string[] primaryKey)
        { return ibs.GetOneInfo(tableName, primaryKey); }
        public DataTable GetList(string tableName, string filter)
        { return ibs.GetList(tableName, filter); }
        public bool ExecSQL(string strSQL)
        { return ibs.ExecSQL(strSQL); }

        public DataSet ExecSQL2(string strSQL)
        { return ibs.ExecSQL2(strSQL); }


        #region Delete
        public string Delete(string tableName, string[] primaryKey)
        {
            return ibs.DeleteTable(tableName, primaryKey);// string[] sdList = new string[] { "SalId",salId, "N" };
        }
        public string Delete(string tableName, string[] primaryKey, ArrayList arrayList)
        {
            return ibs.DeleteTable(tableName, primaryKey, arrayList);
        }
        #endregion

        #region Insert
        /// <summary>
        /// 插入一条记录 自动获取UI数据
        /// </summary>
        /// <param name="tableName">表名</param>
        /// <param name="PageOrUserControl">UI</param>
        /// <returns></returns>
        public bool Insert(string tableName, object PageOrUserControl)
        {
            //可以增加判断
            SortedDictionary<string, string> sdList = GetCtlValue(PageOrUserControl);
            return ibs.InsertTable(tableName, sdList);
        }
        /// <summary>
        /// 插入一条记录 手工获取UI数据
        /// </summary>
        /// <param name="tableName">表名</param>
        /// <param name="sdList">封装好的数据</param>
        /// <returns></returns>
        public bool Insert(string tableName, SortedDictionary<string, string> sdList)
        {
            return ibs.InsertTable(tableName, sdList);
        }
        //自动+其它SQL
        public bool Insert(string tableName, object PageOrUserControl, ArrayList arrayList)
        {
            SortedDictionary<string, string> sdList = GetCtlValue(PageOrUserControl);
            return ibs.InsertTable(tableName, sdList, arrayList);
        }
        //手工+其它SQL
        public bool Insert(string tableName, SortedDictionary<string, string> sdList, ArrayList arrayList)
        {
            return ibs.InsertTable(tableName, sdList, arrayList);
        }
        #endregion

        #region Update
        public bool Update(string tableName, object PageOrUserControl)
        {
            SortedDictionary<string, string> sdList = GetCtlValue(PageOrUserControl);
            return ibs.UpdateTable(tableName, sdList);
        }
        public bool Update(string tableName, SortedDictionary<string, string> sdList)
        {
            return ibs.UpdateTable(tableName, sdList);
        }
        public bool Update(string tableName, object PageOrUserControl, ArrayList arrayList)
        {
            SortedDictionary<string, string> sdList = GetCtlValue(PageOrUserControl);
            return ibs.UpdateTable(tableName, sdList, arrayList);
        }
        public bool Update(string tableName, SortedDictionary<string, string> sdList, ArrayList arrayList)
        {
            return ibs.UpdateTable(tableName, sdList, arrayList);
        }
        #endregion
        //插入多表的数据
        public string InsertMultiTable(List<String[,]> detailList)
        { return ibs.InsertMultiTable(detailList); }

        //后三个方法是同事对主表和明细表操作
        public string InsertMainAndDetail(string mainTable, SortedDictionary<string, string> mainList, string detailTable, List<SortedDictionary<string, string>> detailList)
        {
            return ibs.InsertMainAndDetail(mainTable, mainList, detailTable, detailList);
        }
        public string UpdateMainAndDetail(string mainTable, SortedDictionary<string, string> mainList, string[] primaryKey, string detailTable, List<SortedDictionary<string, string>>  detailList)
        {
            return ibs.UpdateMainAndDetail(mainTable, mainList, primaryKey, detailTable, detailList);
        }
        public string InsertMainAndDetail(string mainTable, List<String[]> mainList, string detailTable, string fCode, List<String[]> detailList)
        {
            return ibs.InsertMainAndDetail(mainTable, mainList, detailTable, fCode, detailList);
        }
        /// <summary>
        /// 获取UI数据
        /// </summary>
        /// <param name="PageOrUserControl"></param>
        /// <returns></returns>
        public SortedDictionary<string, string> GetCtlValue(object PageOrUserControl)
        {
            SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
            foreach (Control ctr in (PageOrUserControl as System.Web.UI.Page).Controls)
            {
                GetValue(ctr, sdList);
            }
            return sdList;
        }
        private void GetValue(Control ctr, SortedDictionary<string, string> sdList)
        {
            foreach (Control c in ctr.Controls)
            {
                Type ctrType = c.GetType();
                switch (ctrType.ToString())
                {
                    case "System.Web.UI.WebControls.TextBox":
                        TextBox ctbo = (TextBox)c;
                        sdList.Add(ctbo.ID, ctbo.Text);
                        break;
                    case "System.Web.UI.WebControls.DropDownList":
                        DropDownList ddl = (DropDownList)c;
                        sdList.Add(ddl.ID, (ddl.SelectedValue.Trim() == "") ? "0" : ddl.SelectedValue.Trim());
                        break;
                    case "System.Web.UI.WebControls.HiddenField":
                        HiddenField hf = (HiddenField)c;
                        if (!string.IsNullOrWhiteSpace(hf.Value))
                            sdList.Add(hf.ID, hf.Value);
                        break;
                }
            }
        }

    }
}
