﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Text;
using DAL;
using Utils;
namespace BLL
{
   public class EmpChangeBiz
    {
       EmpChangeDao empChangeDao = new EmpChangeDao();
       public string Insert(SortedDictionary<string, string> sdList, SortedDictionary<string, string>  hList)
       {
           string str = "";
           ArrayList validationErrors = ValidateSave(sdList, hList, "INSERT");
           if (validationErrors.Count > 0)
           {
               string resultInfo = "";
               foreach (string message in validationErrors)
               {
                   resultInfo += message + "\n";
               }
               return resultInfo;
           }

           if (empChangeDao.Insert(sdList, hList)) str = "插入信息成功";
           else str = "插入信息失败";

           return str;
           
       }


       public string Update(SortedDictionary<string, string> sdList, SortedDictionary<string, string> hList)
       {
           string str = "";
           ArrayList validationErrors = ValidateSave(sdList, hList,"UPDATE");
           if (validationErrors.Count > 0)
           {
               string resultInfo = "";
               foreach (string message in validationErrors)
               {
                   resultInfo += message + "\n";
               }
               return resultInfo;
           }

           if (empChangeDao.Update(sdList, hList)) str = "更新信息成功";
           else str = "更新信息失败";

           return str;
       }

       /// <summary>
       /// 验证输入数据是否合符规则
       /// </summary>
       /// <param name="sdList"></param>
       /// <returns></returns>
       private ArrayList ValidateSave(SortedDictionary<string, string> sdList, SortedDictionary<string, string> hList,string operType)
       {
           ArrayList validationErrors = new ArrayList();
           if (sdList["EmpCode"] == "") validationErrors.Add("员工工号不能为空");
           int len = XmlUtility.GetNumFormConfig("EmpCodeLength");
           if (sdList["EmpCode"].Length != len) validationErrors.Add("员工编码长度不等于预设长度:" + len.ToString());
           
               if (!new EmployeeBiz().IsExistEmpCode(sdList["EmpCode"])) validationErrors.Add("员工编号不存在");
          
           if (!RegexRule.IsInt(sdList["TestTimeLong"])) validationErrors.Add("试用时长必须为整数");

           if (hList["DeptID"] == "" || hList["DeptID"] == "0") validationErrors.Add("所属部门必选");
           if (hList["DutyID"] == "" || hList["DutyID"] == "0") validationErrors.Add("员工职务必选");
           if (hList["AreaID"] == "" || hList["AreaID"] == "0") validationErrors.Add("区域必选");
           if (hList["StateID"] == "" ||hList["StateID"] == "0") validationErrors.Add("状态必选");

           if (operType != "Update")
           {
               if (hList["StateID"] == "1" && sdList["TestTimeLong"] != "0") validationErrors.Add("修改为正式员工，试用期必须为0月");
           }
           if (hList["StateID"] == "3") validationErrors.Add("不能选择离职状态，来让员工离职");
           if (hList["StateID"] == "2" && sdList["TestTimeLong"] == "0") validationErrors.Add("试用员工，试用期不能为0月");

           if (string.IsNullOrWhiteSpace(sdList["EmpName"])) validationErrors.Add("员工姓名不能为空");
           if (!RegexRule.IsDate(sdList["ChangeTime"])) validationErrors.Add("变动时间应该输入正确格式日期：2018-01-01");
           return validationErrors;
       }


       public bool DeleteOneInfo(string changeID)
       {
           return empChangeDao.DeleteOneInfo(changeID);
       }
       //获取一条记录
       public DataTable GetOneInfo(string changeID)
       {
           return empChangeDao.GetOneInfo(changeID);
       }

       public string GetSQL(string serWord, string bTime, string eTime, string changeTypeName, string deptID)
       {
           return empChangeDao.GetSQL(serWord, bTime, eTime, changeTypeName, deptID);
       }
       public DataTable GetLists(string serWord, string bTime, string eTime, string changeTypeName, string deptID)
       {
           return empChangeDao.GetLists(serWord, bTime, eTime, changeTypeName, deptID);       
       }
       public DataTable GetStatuByType(string bTime, string eTime)
       {
           return empChangeDao.GetStatuByType(bTime, eTime);
       }
    }
}
