﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Text;
using DAL;
using Utils;
namespace BLL
{

    public class EmpInsuranceBiz
    {
        EmpInsuranceDao empInsuranceDao = new EmpInsuranceDao();
        EmployeeBiz employeeBiz = new EmployeeBiz();
        string tableName = "Admin_Insurance";
        public string Insert(SortedDictionary<string, string> sdList)
        {
            string info = "";
            if (empInsuranceDao.Insert(tableName, sdList))
            {
                if (XmlUtility.GetWebParam("SynInsurance") == "N")
                    info = "增加保险信息成功\n" + UpdateEmpInfo(sdList["EmpCode"], "1");
                else if (XmlUtility.GetWebParam("SynInsurance") == "Y")
                    info = "增加保险信息成功\n" + UpdateEmpInfo(sdList["EmpCode"], sdList["EmpPay"]);
                else //不使用
                    info = "增加保险信息成功";
            }
            else
                info = "增加保险信息失败";
            return info;
        }


        public string Update(SortedDictionary<string, string> sdList, int initValue)
        {

            string info = "";
            if (empInsuranceDao.Update(tableName, sdList))
            {
                if (initValue == 0)
                    info = "保险信息更新成功\n" + UpdateEmpInfo(sdList["EmpCode"], "0"); //关闭
                //else if (initValue == 1) //不操作基本信息资料
                 //   info = "保险信息更新成功\n";
                else //更新保险信息到基本资料
                {
                   // info = "保险信息更新成功\n" + UpdateEmpInfo(sdList["EmpCode"], "1");
                    if (XmlUtility.GetWebParam("SynInsurance") == "N")//不同步
                        info = "保险信息更新成功\n" + UpdateEmpInfo(sdList["EmpCode"], "1");
                    else if (XmlUtility.GetWebParam("SynInsurance") == "Y") //同步
                        info = "保险信息更新成功\n" + UpdateEmpInfo(sdList["EmpCode"], sdList["EmpPay"]);
                    else //不使用
                        info = "保险信息更新成功";
                }
            }
            else info = "保险信息更新失败\n";

            return info;
        }

        public string DeleteOneInfo(string insuranceID, string empCode)
        {
            string info = "";
            if (empInsuranceDao.DeleteOneInfo(insuranceID))
                info = "删除保险信息成功\n" + UpdateEmpInfo(empCode, "0");
            else
                info = "删除失败";
            return info;
        }
        //配合录入保险使用
        public string UpdateEmpInfo(string empCode, string empPay)
        {
            if (employeeBiz.UpdateInsuranceInfo(empCode, empPay))
                return "更新了员工基本信息：保险金额为" + empPay;
            else
                return "更新员工保险金额失败";
        }
        public DataTable GetOneInfo(string insuranceID)
        {
            return empInsuranceDao.GetOneInfo(insuranceID);
        }

        public string GetIdByEmpcode(string empcode)
        {
            return empInsuranceDao.GetIdByEmpcode(empcode);
        }

        public string GetSQL(string serWord, string bTime, string eTime, string statu, string timeType)
        {
            return empInsuranceDao.GetSQL(serWord, bTime, eTime, statu, timeType);
        }

        public DataTable GetLists(string serWord, string bTime, string eTime, string statu, string timeType)
        {
            return empInsuranceDao.GetLists(serWord, bTime, eTime, statu, timeType);
        }
        public bool UpdateToEnd()
        {
            return empInsuranceDao.UpdateToEnd();
        }
        public bool UpdateToEnd(string empCode, string endTime, string statu)
        { return empInsuranceDao.UpdateToEnd(empCode, endTime, statu); }
    }
}
