﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Text;
using DAL;
namespace BLL
{
    public class EmpLeaveBiz
    {
        EmpLeaveDao empLeaveDao = new EmpLeaveDao();
        EmpInsuranceBiz empInsuranceBiz = new EmpInsuranceBiz();
        EmployeeBiz employeeBiz = new EmployeeBiz();
        AccountBiz accountBiz = new AccountBiz();
        public string Insert(string tableName, SortedDictionary<string, string> sdList)
        {
            //首先判断最近有没有该人员的离职信息
            DataTable leaveDT = empLeaveDao.GetOneInfo(sdList["EmpCode"], "Y");
            if (leaveDT.Rows.Count > 0)
            {
                return "已经存在该工号的可用离职信息，不能再添加";
            }
            //如果员工已经离职，也不能再增加离职信息
            if (employeeBiz.IsState(sdList["EmpCode"], 3)) return "该工号已经离职，不能再修改为离职状态";


            //然后进行下面实际业务操作
            StringBuilder info = new StringBuilder();
            //1 更改员工基本信息
            SortedDictionary<string, string> hList = new SortedDictionary<string, string>();
            hList.Add("EmpCode", sdList["EmpCode"]);
            if (sdList["LeaveType"] == "请长假")//雇员表中同样映射为请长假   
            {
                hList.Add("StateID", "4");//字典中的ID
                hList.Add("AskForLeave", sdList["Memo"]);
                hList.Add("LeaveTime", sdList["LeaveTime"]);//离职时间
            }
            else//其它状态在雇员表中，映射为离职
            {
                hList.Add("StateID", "3");//字典中的ID
                hList.Add("AskForLeave", sdList["Memo"]);
                hList.Add("LeaveTime", sdList["LeaveTime"]);//离职时间
            }
            if (empLeaveDao.Insert(tableName, sdList, hList))
                info.Append("1：增加离职信息成功\n");
            else info.Append("1：更改员工信息失败\n");
            return info.ToString();
        }
        //按照员工编号更新离职信息
        public bool UpdateStatuToN(string empCode)
        {
            return empLeaveDao.UpdateStatuToN(empCode);
        }
        //单纯更新离职信息
        public bool Update(SortedDictionary<string, string> sdList)
        {
            return empLeaveDao.Update("Admin_Emp_Leave", sdList);
        }
        //带业务逻辑更新
        public string Update(string tableName, SortedDictionary<string, string> sdList)
        {
            string info = "";

            if (empLeaveDao.Update(tableName, sdList))
                info = "2：更新离职信息成功\n";
            else
                info = "2：更新离职信息失败\n";
            return info.ToString();

        }

        public string DeleteOneInfo(string leaveID)
        {
            string info = "员工信息不存在";

            //录入超过30天的离职信息不能删除
            DataTable dt = empLeaveDao.GetOneInfo(leaveID);
            if (dt.Rows.Count > 0)
            {
                DateTime dateTime = DateTime.Parse(dt.Rows[0]["InputTime"].ToString());
                string empCode = dt.Rows[0]["EmpCode"].ToString().Trim();

                if (dateTime < System.DateTime.Now.AddDays(-30))//不能删除
                    info = "录入该信息已经超过30天，不能删除";
                else
                {
                    info = "成功删除离职信息";
                    //删除离职信息的话，必须把把员工档案还原为正常状态
                    SortedDictionary<string, string> hList = new SortedDictionary<string, string>();
                    hList.Add("EmpCode", empCode);
                    hList.Add("StateID", dt.Rows[0]["HisStateID"].ToString());
                    hList.Add("LeaveTime", "null");
                    if (empLeaveDao.DeleteOneInfo(leaveID, hList))
                    {
                        info = "删除成功";
                    }
                    else
                        info = "删除失败";
                }
            }

            return info;
        }
        public string DeleteOneInfo(string leaveID, string delType)
        {
            string info = "员工信息不存在";
            if (empLeaveDao.DeleteOneInfo(leaveID))
                info = "成功删除离职信息(不修改基本资料)";
            else
                info = "删除失败";
            return info;
        }
        public DataTable GetOneInfo(string leaveID)
        {
            return empLeaveDao.GetOneInfo(leaveID);
        }

        public string GetSQL(string serWord, string bTime, string eTime, string deptID, string leaveType, string leaveState)
        {
            return empLeaveDao.GetSQL(serWord, bTime, eTime, deptID, leaveType, leaveState);
        }
        public DataTable GetLists(string serWord, string bTime, string eTime, string deptID, string leaveType, string leaveState)
        {
            return empLeaveDao.GetLists(serWord, bTime, eTime, deptID, leaveType, leaveState);
        }
        public DataTable GetOutLists(string serWord, string bTime, string eTime, string deptID, string leaveType, string leaveState)
        {
            return empLeaveDao.GetOutLists(serWord, bTime, eTime, deptID, leaveType, leaveState);
        }
    }
}
