﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using DAL;
using Utils;

//员工业务规则层
namespace BLL
{
    public class EmployeeBiz
    {

        EmployeeDao employeeDao = new EmployeeDao();
        DepartmentBiz departmentBiz = new DepartmentBiz();
        BankAccountBiz bankAccountBiz = new BankAccountBiz();

        public bool Update(string tableName, SortedDictionary<string, string> sdList)
        {
            return employeeDao.Update(tableName, sdList);
        }
        public string Update(SortedDictionary<string, string> sdList, SortedDictionary<string, string>  hList)
        {
            string str="";
            ArrayList validationErrors = ValidateSave(sdList, "Update");

            if (validationErrors.Count > 0)
            {
                string resultInfo = "";
                foreach (string message in validationErrors)
                {
                    resultInfo += message + "\n";
                }
                return resultInfo;
            }
            //更新银行账号
           // if (bankAccountBiz.Update(hList))
            //{
                //更新员工基本信息
                if (employeeDao.Update("Admin_Employee", sdList)) str = "更新员工信息成功，更新银行账号成功";
                else
                    str = "更新员工信息失败，更新银行账号成功";
           // }
           // else
            //    str = "更新员工信息失败，更新银行账号失败";
            return str;
        }
        public string  Insert(SortedDictionary<string, string> sdList, SortedDictionary<string, string> hList)
        {
            string str = "";
            ArrayList validationErrors = ValidateSave(sdList, "INSERT");
             if (validationErrors.Count>0){
                string resultInfo = "";
                foreach (string message in validationErrors)
                {
                    resultInfo += message + "\n";
                }
                return resultInfo;
            }

            //if (bankAccountBiz.Insert(hList))
            //{
                if (employeeDao.Insert("Admin_Employee", sdList))
                    str = "成功员工信息成功";
                else
                    str = "插入员工信息失败2";
            //}
            //else
            //    str = "插入银行账号失败1";
            return str;
        }
        //更新保险信息
        public bool UpdateInsuranceInfo(string empCode, string empPay)
        {
            return employeeDao.UpdateInsuranceInfo( empCode,  empPay);
        }
        /// <summary>
        /// 验证输入数据是否合符规则
        /// </summary>
        /// <param name="sdList"></param>
        /// <returns></returns>
        private ArrayList ValidateSave(SortedDictionary<string, string> sdList, string operType)
        {
            ArrayList validationErrors = new ArrayList();
            if (sdList["EmpCode"] == "") validationErrors.Add("员工编码不能为空");
            int len = XmlUtility.GetNumFormConfig("EmpCodeLength");
            if (sdList["EmpCode"].Length != len) validationErrors.Add("员工编码长度不等于预设长度:" + len.ToString());
            if (operType == "INSERT")
            {
                if (new EmployeeBiz().IsExistEmpCode(sdList["EmpCode"])) validationErrors.Add("员工编码已经被使用");
            }


            if (sdList["DeptID"] == "" || sdList["DeptID"] == "0") validationErrors.Add("所属部门必选");
            if (sdList["DutyID"] == "" || sdList["DutyID"] == "0") validationErrors.Add("员工职务必选");
            if (sdList["AreaID"] == "" || sdList["AreaID"] == "0") validationErrors.Add("区域必选");
            if (sdList["StateID"] == "" || sdList["StateID"] == "0") validationErrors.Add("状态必选");

            if (operType != "Update")
            {
                if (sdList["StateID"] == "1" && sdList["TestTimeLong"] != "0") validationErrors.Add("入职为正式员工，试用期必须为0月");
            }
            if (sdList["StateID"] == "3") validationErrors.Add("输入的员工信息，不能为离职员工");
            if (sdList["StateID"] == "2" && sdList["TestTimeLong"] == "0") validationErrors.Add("试用员工，试用期不能为0月");

            if (sdList["EmpName"] == "") validationErrors.Add("员工姓名不能为空");
            if (!RegexRule.IsDecimal(sdList["SafetyAmount"])) validationErrors.Add("社保基金应该输入数字");
            if (sdList["Birthday"] != "")
            {
                if (!RegexRule.IsDate(sdList["Birthday"])) validationErrors.Add("员工生日应该输入正确格式日期：2010-01-01");
            }
            if (!RegexRule.IsDate(sdList["JoinTime"])) validationErrors.Add("员工入职日期应该输入正确格式日期：2010-01-01");
            if (!RegexRule.IsInt(sdList["TestTimeLong"])) validationErrors.Add("试用时间长度应该输入数字");

            return validationErrors;
        }
        public DataTable GetOneInfo(string empCode)
        {
            return employeeDao.GetOneInfo(empCode);
        }
        public bool DeleteOneInfo(string empCode)
        {
            return employeeDao.DeleteOneInfo(empCode);
        }

        public DataTable GetOneInfoByName(string empName)
        {
            return employeeDao.GetOneInfoByName(empName);
        }

        public bool IsExistEmpCode(string empCode)
        {
            return employeeDao.IsExistEmpCode(empCode);
        }
        public bool IsExistEmpCode(string empCode,string statu)
        {
            return employeeDao.IsExistEmpCode(empCode, statu);
        }
        public bool ChangeDept(string oldDeptID, string newDeptID)
        {
            return employeeDao.ChangeDept(oldDeptID, newDeptID);
        }
        public bool ModiEmpCode(string oldCode, string newCode, string codeType)
        {
            return employeeDao.ModiEmpCode(oldCode, newCode, codeType);
        }
  
        //更改雇员工资卡号
        public bool ModiEmpBankAccount(string empCode,string bankName,string bankAccount)
        {
            return employeeDao.ModiEmpBankAccount(empCode, bankName, bankAccount);
        }
      
        #region 根据部门操作
        /// <summary>
        /// 根据部门 显示某部门下的所有员工
        /// </summary>
        /// <param name="account"></param>
        /// <param name="empCode"></param>
        /// <param name="deptID"></param>
        /// <returns></returns>
        public DataTable GetLists(string account,string empCode, int deptID)
        {            
            DataSet ds = departmentBiz.GetDataSet("NOR");
            string deptIDArray = "";
            if (deptID!=0)
                deptIDArray=departmentBiz.GetSubID(ds, deptID);
            return employeeDao.GetLists(account,empCode, deptIDArray, "");
        }
        //员工信息导出使用
        public DataTable GetOutLists(string account, string empCode, int deptID)
        {            
            DataSet ds = departmentBiz.GetDataSet("NOR");
            string deptIDArray = "";
            if (deptID != 0)
                deptIDArray = departmentBiz.GetSubID(ds, deptID);
            return employeeDao.GetOutLists(account, empCode, deptIDArray, "");
        }
        #endregion

        //员工信息主界面，显示使用
        public DataTable GetLists(string empCode, string bTime, string eTime, string deptID, string stateID, string timeType)
        {
            return employeeDao.GetLists(empCode, bTime, eTime, deptID, stateID, timeType);
        }
        public DataTable GetLists(string deptPropertie)
        {
            return employeeDao.GetLists(deptPropertie);
        }
        //员工信息导出使用
        public DataTable GetOutLists(string empCode, string bTime, string eTime, string deptID, string stateID, string timeType)
        {          
            DataSet ds = departmentBiz.GetDataSet("NOR");
            string deptIDArray = "";
            if (deptID!="0")
                deptIDArray=departmentBiz.GetSubID(ds, Int32.Parse(deptID));
            return employeeDao.GetOutLists(empCode, bTime, eTime, deptIDArray, stateID, timeType);
        }

        public DataTable GetOneInfo(string empCode, string empName, string empDept, string empDuty, string empArea)
        {
            return employeeDao.GetOneInfo(empCode, empName, empDept, empDuty, empArea);
        }

        //上岗通知书
        public DataTable GetLists(string serWord, string deptID, string bTime, string eTime, string timeType)
        {
            return employeeDao.GetLists(serWord, deptID, bTime, eTime, timeType);
        }

        //入职汇总
        public DataTable GetLists(string bTime, string eTime)
        {
            return employeeDao.GetLists(bTime, eTime);
        }
        #region
        //生成员工编号
        public string CreateEmpCode(string strHead)
        {
            return employeeDao.CreateEmpCode(strHead);
        }
        //获取未使用员工编号
        public DataTable GetCodeList(string deptID, string strHead)
        {
            return employeeDao.GetCodeList(deptID,strHead);
        }
         //生成工号字典
        public bool CreateCodeDict(string len)
        {
            return  employeeDao.CreateCodeDict(len);
        }
        //设置工号状态
        public bool SetCodeStatu(string strCode, string deptID,string empName,string statu)
        {
            return employeeDao.SetCodeStatu(strCode, deptID, empName, statu);
        }
        public DataTable GetCodeStatu(string strCode)
        { return employeeDao.GetCodeStatu(strCode);
        }
        #endregion
        //根据部门统计
        public DataTable GetListByDept(string stateID, string dutyID)
        {
            return employeeDao.GetListByDept(stateID, dutyID);
        }
        //根据部门 统计在职员工 （包括正式的和试用的）
        public DataTable GetListActiveEmp()
        {
            return employeeDao.GetListActiveEmp();
        }
        //按照学历统计
        public DataTable GetListByEdu(string stateID, string dutyID)
        {
            return employeeDao.GetListByEdu(stateID, dutyID);
        }

        //根据职位统计
        public DataTable GetListByDuty(string stateID, string deptID)
        {
            return employeeDao.GetListByDuty(stateID, deptID);
        }

        //根据区域显示
        public DataTable GetListByArea(string empCode, string deptID, string areaID)
        {
            return employeeDao.GetListByArea(empCode, deptID, areaID);
        }   //根据区域统计
        public DataTable GetListByArea(string stateID, string deptID)
        {
            return employeeDao.GetListByArea(stateID, deptID);
        }
        public DataTable GetStaticDetail(string gvCaption, string searchParam, string stateID, string dutyID, string stateID0, string deptID, bool flag, string getType)
        {
            return employeeDao.GetStaticDetail(gvCaption, searchParam, stateID, dutyID, stateID0, deptID, flag, getType);
        }
        //获取人员列表，带有下限
        public DataSet GetLimitList(string theYear, string theMonth)
        {
            return employeeDao.GetLimitList(theYear, theMonth);
        }
        public DataTable GetMonthJoinList(int iYear, int iMonth, string getType)
        {
            return employeeDao.GetMonthJoinList(iYear, iMonth, getType);
        }
        public DataTable GetMonthLeaveList(int iYear, int iMonth, string getType)
        {
            return employeeDao.GetMonthLeaveList(iYear, iMonth, getType);
        }
        public DataTable GetMonthNowList(int iYear, int iMonth, string getType)
        {
            return employeeDao.GetMonthNowList(iYear, iMonth, getType);
        }
        public DataSet GetMonthNowNum(int iYear, int iMonth)
        {
            return employeeDao.GetMonthNowNum(iYear, iMonth);
        }
        //无工资账号员工
        public DataTable GetNoBankAccountList()
        {
            return employeeDao.GetNoBankAccountList();
        }
        //判断一个员工的状态
        public bool IsState(string empCode, int stateID)
        {
            return employeeDao.IsState(empCode, stateID);
        }

    }
}
