﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Text;
using DAL;
using Utils;

namespace BLL
{
    public class SalesmanBiz
    {
        SalesmanDao salesmanDao = new SalesmanDao();
        #region  售货员
        public bool Insert(string tableName, SortedDictionary<string, string> sdList)
        {
            return salesmanDao.Insert(tableName, sdList);
        }
        public bool Update(string tableName, SortedDictionary<string, string> sdList)
        {
            return salesmanDao.Update(tableName, sdList);
        }
        //根据ID删除
        public bool DeleteOneInfo(string saleManID)
        {
            return salesmanDao.DeleteOneInfo(saleManID);
        }
        //根据工号和状态来删除
        public bool DeleteOneInfo(string empCode, string stateName)
        {
            return salesmanDao.DeleteOneInfo(empCode, stateName);
        }
        //根据ID获取一条记录
        public DataTable GetOneInfo(string saleManID)
        {
            return salesmanDao.GetOneInfo(saleManID);
        }
        //根据工号和状态，获取一条记录(在职状态只有一条记录，离职状态可能有多条记录)
        public DataTable GetOneInfo(string empCode, string stateName)
        {
            return salesmanDao.GetOneInfo(empCode, stateName);
        }
        //根据含有汉字的名字，获取个人详细信息
        public DataTable GetOneInfoByName(string empName, string stateName)
        {
            return salesmanDao.GetOneInfoByName(empName, stateName);
        }
        /// <summary>
        /// 验证工号是否存在，区分状态
        /// </summary>
        /// <param name="empCode"></param>
        /// <returns>bool</returns>
        public bool IsExistEmpCode(string empCode, string stateName)
        {
            return salesmanDao.IsExistEmpCode(empCode, stateName);
        }
        //列表SQL
        public string GetSQL(string serWord, string bTime, string eTime, string stateName, string timeType)
        {
            return salesmanDao.GetSQL(serWord, bTime, eTime, stateName, timeType);
        }
        //促销员列表
        public DataTable GetLists(string serWord, string bTime, string eTime, string stateName, string timeType)
        {
            return salesmanDao.GetLists(serWord, bTime, eTime, stateName, timeType);
        }
        #endregion


        #region 职位变动
        public DataTable GetChangeLists(string saleManID)
        { return salesmanDao.GetChangeLists(saleManID); }
        public DataTable GetChangeLists(string empCode, string bTm, string eTm)
        {
            return salesmanDao.GetChangeLists(empCode, bTm, eTm);
        }
        public DataTable GetChangeOneInfo(string changeID)
        {
            return salesmanDao.GetChangeOneInfo(changeID);

        }
        public bool DeleteChangeOneInfo(string changeID)
        {
            return salesmanDao.DeleteChangeOneInfo(changeID);
        }
        //促销员职位变动列表SQL
        public string GetSQL(string empCode, string bTime, string eTime)
        {
            return salesmanDao.GetSQL(empCode, bTime, eTime);
        }

        #endregion

        #region 离职信息
        public DataTable GetLeaveOneInfo(string leaveID)
        {
            return salesmanDao.GetLeaveOneInfo(leaveID);

        }
        public bool DeleteLeaveOneInfo(string leaveID)
        {
            return salesmanDao.DeleteLeaveOneInfo(leaveID);
        }
        public DataTable GetLeaveLists(string saleManID)
        {
            return salesmanDao.GetLeaveLists(saleManID);

        }
        public DataTable GetLeaveLists(string empCode, string bTime, string eTime, string timeType)
        {
            return salesmanDao.GetLeaveLists(empCode, bTime, eTime, timeType);

        }
        public string GetLeaveSQL(string empCode, string bTime, string eTime, string timeType)
        {
            return salesmanDao.GetLeaveSQL(empCode, bTime, eTime, timeType);
        }

        #endregion

        #region 奖惩

        public bool DeleteRewardsOneInfo(string rewardsID)
        {
            return salesmanDao.DeleteRewardsOneInfo(rewardsID);
        }
        //获取一条记录
        public DataTable GetRewardsOneInfo(string rewardsID)
        {
            return salesmanDao.GetRewardsOneInfo(rewardsID);
        }
        public DataTable GetRewardsLists(string saleManID)
        {
            return salesmanDao.GetRewardsLists(saleManID);
        }
        public DataTable GetRewardsLists(string deptID, string serWord, string bTime, string eTime, string type)
        {
            //if (dataSet.Tables[0].Rows.Count <= 0)
            //{               
            //        DataRow dr = dataSet.Tables[0].NewRow();
            //        dataSet.Tables[0].Rows.Add(dr);
            //}
            return salesmanDao.GetRewardsLists(deptID, serWord, bTime, eTime, type);
        }
        //SQL
        public string GetRewardsSQL(string deptID, string serWord, string bTime, string eTime, string type)
        {
            return salesmanDao.GetRewardsSQL(deptID, serWord, bTime, eTime, type);
        }
        #endregion

        #region 统计
        public DataTable GetStatisticBySalesmen(string typeName, string bTime, string eTime)
        {
            return salesmanDao.GetStatisticBySalesmen(typeName, bTime, eTime);
        }

        public DataTable GetStatisticByDept(string typeName, string bTime, string eTime)
        {
            return salesmanDao.GetStatisticByDept(typeName, bTime, eTime);
        }
        #endregion
        #region 促销员进场
        public DataTable GetInOneInfo(string InID)
        {
            return salesmanDao.GetInOneInfo(InID);
        }
        public DataTable GetInOneInfo(string statu, string empCode)
        {
            return salesmanDao.GetInOneInfo(statu, empCode);
        }
        public bool DeleteInOneInfo(string InID)
        {
            return salesmanDao.DeleteInOneInfo(InID);
        }
        public bool IsExistInInfo(string empCode)
        {
            return salesmanDao.IsExistInInfo(empCode);
        }
        public bool UpdateInStatu(string saleManID, string statu)
        {
            return salesmanDao.UpdateInStatu(saleManID, statu);
        }
        public DataTable GetInLists(string saleManID)
        {
            return salesmanDao.GetInLists(saleManID);
        }
        public DataTable GetInLists(string empCode, string deptName, string bTime, string eTime, string timeType)
        {
            return salesmanDao.GetInLists(empCode, deptName, bTime, eTime, timeType);

        }
        public string GetInSQL(string empCode, string deptName, string bTime, string eTime, string timeType)
        {
            return salesmanDao.GetInSQL(empCode, deptName, bTime, eTime, timeType);
        }
        #endregion
    }
}
