﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Data;
using System.Web.UI.WebControls;
using DataHelper;
using Utils;
namespace DAL
{
    public class CodeConfigDao
    {
        DepartmentDao departmentDao = new DepartmentDao();
        public DataTable GetOneInfo(int codeID)
        {
            return SQLHelper.ExecuteSqlGetDrToDt("Select * from Sys_CodeConfig  Where CodeID=" + codeID);
        }
        public DataTable GetOneInfo(string codeName)
        {
            return SQLHelper.ExecuteSqlGetDrToDt("Select * from Sys_CodeConfig  Where CodeName='" + codeName + "'");
        }
        public DataTable GetLists(string serWord)
        {
            return SQLHelper.ExecuteSqlGetDrToDt("Select * from Sys_CodeConfig  Where CodeName like '%" + serWord + "%'");
        }

        public string CreateCode(string codeName, string tableName)
        {
            DataTable dt = GetOneInfo(codeName);
            if (dt.Rows.Count > 0)
            {

                string strPreStr = dt.Rows[0]["PreStr"].ToString();
                string strFirObj = dt.Rows[0]["FirObj"].ToString();
                string strHavYear = dt.Rows[0]["HavYear"].ToString();
                string strHavMonth = dt.Rows[0]["HavMonth"].ToString();
                string strHavDay = dt.Rows[0]["HavDay"].ToString();
                int iFlowBitNum = Int32.Parse(dt.Rows[0]["FlowBitNum"].ToString());
                string strLastStr = dt.Rows[0]["LastStr"].ToString();

                string code = strPreStr;
                if (HttpContext.Current.Session["user"] != null)
                {
                    User user = HttpContext.Current.Session["user"] as User;
                    switch (strFirObj)
                    {
                        case "登录账号"://来自于session
                            code += user.Account;
                            break;
                        case "公司ID":
                            code += user.CompanyID.ToString();
                            break;
                        case "部门ID":
                            code += user.DepartemntID.ToString();
                            break;
                        case "公司简码":
                            code += departmentDao.GetDeptPinSnByID(user.CompanyID.ToString());
                            break;
                        case "部门简码":
                            code += departmentDao.GetDeptPinSnByID(user.DepartemntID.ToString());
                            break;
                        default:

                            break;
                    }
                }


                string ymd = System.DateTime.Now.ToString("yyMMdd");
                if (strHavYear == "Y") code += ymd.Substring(0, 2);
                if (strHavMonth == "Y") code += ymd.Substring(2, 2);
                if (strHavDay == "Y") code += ymd.Substring(4, 2);


                string dateType = "";
                if (strHavYear == "Y" && strHavMonth == "N") dateType = "yy";
                if (strHavYear == "Y" && strHavMonth == "Y") dateType = "mm";
                if (strHavYear == "N" && strHavMonth == "Y") dateType = "mm";
                //只有日期无意义
                string num = GetNumber(tableName, dateType);
                code += StringUtility.LeftAppend((Int32.Parse(num) + 1).ToString(), iFlowBitNum);

                code += strLastStr;
                return code;
            }
            else
                return "";
        }


      
        //获取指定表的所有的行数
        public string GetNumber(string tableName, string dateType)
        {
            string sql = "Select count(*) from " + tableName + " Where ";
            switch (dateType)
            {
                case "dd"://日
                    sql += " datediff(day,InputTime,'" + System.DateTime.Now.ToString("yyyy-MM-dd") + "')=0 ";
                    break;
                case "mm"://月
                    sql += " datediff(month,InputTime,'" + System.DateTime.Now.ToString("yyyy-MM-dd") + "')=0 ";
                    break;
                case "yy"://年
                    sql += " datediff(year,InputTime,'" + System.DateTime.Now.ToString("yyyy-MM-dd") + "')=0 ";
                    break;
                case "qq"://季度
                    sql += " datediff(quarter,InputTime,'" + System.DateTime.Now.ToString("yyyy-MM-dd") + "')=0 ";
                    break;
                case "ww"://周
                    sql += " datediff(week,InputTime,'" + System.DateTime.Now.ToString("yyyy-MM-dd") + "')=0 ";
                    break;
                default:
                    sql = "Select count(*) from " + tableName;
                    break;
            }

            return SQLHelper.ExecuteSqlGetNumber(sql);

        }


    }
}
