﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Collections.Generic;
using System.Text;
using DataHelper;
namespace DAL
{
    public class MenuDao
    {
       
        /// <summary>
        /// 删除一个菜单
        /// </summary>
        /// <param name="mainMenuID">菜单ID</param>
        /// <returns></returns>
        public bool DeleteOneInfo(string mainMenuID)
        {
            SqlParameter para = new SqlParameter("@ParentID", SqlDbType.Int);
            para.Value = mainMenuID;
            SqlParameter[] spList = { para };
            //获取菜单本身和所有子菜单的MainMenuID
            string subID = SQLHelper.ExecutePorcedureGetNumber("sp_JimProc_GetAllChildID", spList);
            //Sys_AccountMenu
            StringBuilder builder = new StringBuilder("delete from Sys_SysRoleMenu where MainMenuID in (" + subID+")");
            //Sys_SysRoleMenu
            builder.Append(";delete from Sys_AccountMenu where MainMenuID in (" + subID + ")");
            //Sys_MainMenu
            builder.Append(";delete from Sys_MainMenu where MainMenuID in (" + subID + ")");
            return SQLHelper.ExecuteSql(builder.ToString());
        }
        /// <summary>
        /// 获取一个账号的菜单  为账号设置指定菜单时使用
        /// </summary>
        /// <param name="account"></param>
        /// <returns></returns>
        public DataTable GetOneInfo(string account)
        {
            string strSQL = "SELECT MainMenuID from Sys_AccountMenu WHERE  Account ='" + account + "'";
            return SQLHelper.ExecuteSqlGetDrToDt(strSQL);
        }
        /// <summary>
        /// 获取一个账号的菜单，account 和 role 的菜单
        /// </summary>
        /// <param name="account"></param>
        /// <returns></returns>
        public DataSet GetAccountMenu(string account)
        {
            SqlParameter para0 = new SqlParameter("@Account", SqlDbType.VarChar);
            para0.Value = account;
            SqlParameter[] spList = { para0 };
            return SQLHelper.ExecutePorcedureGetDataSet("sp_JimProc_GetAccountMenu", spList);

        }

        /// <summary>
        /// 获取账号account 定义了menuUrl菜单 的datatable
        /// </summary>
        /// <param name="menuUrl"></param>
        /// <param name="account"></param>
        /// <returns></returns>
        public bool GetOneInfoByUrl(string menuUrl, string account)
        {
            string str = " select count(*) as Num from ( ";

            str += "select MainMenuID from JimView_Role_Menu ";
            str += "where SysRoleID in (select SysRoleID  from Sys_Account_Role where Account='" + account + "') ";
            str += "And LinkUrl like '%" + menuUrl + "%' and State='Y' ";
            str += "union ";
            str += "select MainMenuID from JimView_Account_Menu where Account='" + account + "' And LinkUrl like '%" + menuUrl + "%' and State='Y'";
            str += ") menuTb";

            string num = SQLHelper.ExecuteSqlGetNumber(str);
            if (Int32.Parse(num) < 1) return false;
            else return true;

        }
    }
}
