﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Text;
using Utils;
using DataHelper;

namespace DAL
{
  public  class EmpContractDao
    {

        public bool Insert(string tableName, SortedDictionary<string, string> sdList)
        {
            return new BuiltSQL().InsertTable(tableName, sdList);
        }


        public bool Update(string tableName, SortedDictionary<string, string> sdList)
        {
            return new BuiltSQL().UpdateTable(tableName, sdList);
        }

        #region 合同信息
        public bool DeleteOneInfo(string contractID)
        {
            return SQLHelper.ExecuteSqlWithTransaction("Delete from Admin_Contract Where  ContractID=" + contractID);
        }

        public DataTable GetOneInfo(string contractID)
        {
            return SQLHelper.ExecuteSqlGetDrToDt("Select * from View_Contract Where  ContractID=" + contractID);
        }

        public bool IsExistContractNo(string contractNo)
        {
            DataTable dt = SQLHelper.ExecuteSqlGetDrToDt("Select * from Admin_Contract Where  ContractNo='" + contractNo + "'");
            if (dt.Rows.Count == 1)//如果存在该用户编号
                return true;
            else//否则
                return false;
        }

        public string GetSQL(string serWord, string bTime, string eTime, string statu, string timeType)
        {
            StringBuilder strSQL = new StringBuilder("Select * From View_Contract Where 1=1 ");
            if (!string.IsNullOrWhiteSpace(serWord))
                strSQL.Append(" And (EmpCode='" + serWord + "' Or EmpName Like '%" + serWord + "%')");
            else
            {
                if (statu == "")
                    strSQL.Append(" and Statu ='Y' ");
                else
                {
                    if (statu != "A")
                        strSQL.Append(" and Statu ='" + statu + "' ");
                }
                switch (timeType)
                {
                    case "CheckTime":
                        if (RegexRule.IsDate(bTime))
                            strSQL.Append(" And CheckTime>='" + bTime + "'");
                        if (RegexRule.IsDate(eTime))
                            strSQL.Append(" And CheckTime<='" + eTime + "'");
                        break;
                    case "BeginTime":
                        if (RegexRule.IsDate(bTime))
                            strSQL.Append(" And BeginTime>='" + bTime + "'");
                        if (RegexRule.IsDate(eTime))
                            strSQL.Append(" And BeginTime<='" + eTime + "'");
                        break;
                    case "EndTime":
                        if (RegexRule.IsDate(bTime))
                            strSQL.Append(" And EndTime>='" + bTime + "'");
                        if (RegexRule.IsDate(eTime))
                            strSQL.Append(" And EndTime<='" + eTime + "'");
                        break;
                    case "InputTime":
                        if (RegexRule.IsDate(bTime))
                            strSQL.Append(" And InputTime>='" + bTime + "'");
                        if (RegexRule.IsDate(eTime))
                            strSQL.Append(" And InputTime<='" + eTime + "'");
                        break;
                    case "MakeTime":
                        if (RegexRule.IsDate(bTime))
                            strSQL.Append(" And MakeTime>='" + bTime + "'");
                        if (RegexRule.IsDate(eTime))
                            strSQL.Append(" And MakeTime<='" + eTime + "'");
                        break;
                }
            }

            return strSQL.ToString();
        }
        public DataTable GetLists(string serWord, string bTime, string eTime, string statu, string timeType)
        {
            DataTable
                dt = SQLHelper.ExecuteSqlGetDrToDt(GetSQL(serWord, bTime, eTime, statu, timeType));
            return dt;
        }

        public bool UpdateToEnd()
        {
            //终止自动到期的合同信息
            StringBuilder strSQL = new StringBuilder("Update Admin_Contract Set Statu='N' Where EndTime<='" + System.DateTime.Now.AddDays(-10).ToString("yyyy-MM-dd") + "';");
            // 终止提前离职人员的合同信息
            // strSQL.Append("");

            return SQLHelper.ExecuteSqlWithTransaction(strSQL.ToString());
        }

        #endregion
    }
}
