﻿using System;
using System.Text;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using Utils;
using DataHelper;
namespace DAL
{
  public   class EmpPassedDao
    {

     EmployeeDao employeeDao= new EmployeeDao();
        #region 转正信息

     public bool Insert( SortedDictionary<string, string> sdList, SortedDictionary<string, string>  hList)
        {
            StringBuilder strSQL = new StringBuilder();
            strSQL.Append( "insert Admin_Emp_Passed (EmpCode,EmpName,OldDutyName,OldDeptName,OldAreaName,NewDutyName,PassedTypeName,JoinTime,PassedTime,InfoTypeName,Memo,Account) values ");
            strSQL.Append("('"+sdList["EmpCode"]+"','"+sdList["EmpName"]+"','"+sdList["OldDutyName"]+"','"+sdList["OldDeptName"]+"','"+sdList["OldAreaName"]+"','"+sdList["NewDutyName"]+"','"+sdList["PassedTypeName"]+"','"+sdList["JoinTime"]+"','"+sdList["PassedTime"]+"','"+sdList["InfoTypeName"]+"','"+sdList["Memo"]+"','"+sdList["Account"]+"');");
            strSQL.Append("Update Admin_Employee Set ");
            strSQL.Append("DutyID=" + hList["DutyID"]);
            strSQL.Append(",StateID=" + hList["StateID"]);
            if (hList.ContainsKey("TestEndTime")) strSQL.Append(",TestEndTime='" + hList["TestEndTime"]+"'");
            if (hList.ContainsKey("TestEndTime2")) strSQL.Append(",TestEndTime2='" + hList["TestEndTime2"] + "'");
            strSQL.Append(" Where EmpCode='" + hList["EmpCode"] + "'");

            return SQLHelper.ExecuteSqlWithTransaction(strSQL.ToString());
        }


        public bool Update(string tableName, SortedDictionary<string, string> sdList)
        {
            return new BuiltSQL().UpdateTable(tableName, sdList);
        }

        public bool DeleteOneInfo(string passedID)
        {
            return SQLHelper.ExecuteSqlWithTransaction("Delete from Admin_Emp_Passed Where PassedID=" + passedID);
        }
        //获取一条转正记录
        public DataTable GetOneInfo(string passedID)
        {
            return SQLHelper.ExecuteSqlGetDrToDt("Select * from Admin_Emp_Passed Where PassedID=" + passedID);
        }

        //转正列表SQL
        public string GetSQL(string serWord, string bTime, string eTime, string passedTypeName, string infoType)
        {
            StringBuilder strSQL = new StringBuilder("Select * From Admin_Emp_Passed Where OldDutyName<>'售货员' ");
            if (!string.IsNullOrWhiteSpace(serWord))
                strSQL.Append(" And (EmpCode='" + serWord + "' Or EmpName Like '%" + serWord + "%')");
            else
            {
                if (infoType != "请选择") strSQL.Append(" and InfoTypeName like '%" + infoType + "%' ");
                if (passedTypeName != "")
                    strSQL.Append(" and PassedTypeName ='" + passedTypeName + "' ");

                if (RegexRule.IsDate(bTime))
                    strSQL.Append(" And PassedTime>='" + bTime + "'");
                if (RegexRule.IsDate(eTime))
                    strSQL.Append(" And PassedTime<='" + eTime + "'");
            }
            strSQL.Append(" order by OldDeptName,OldDutyName,EmpCode");
            return strSQL.ToString();
        }
        //转正列表
        public DataTable GetLists(string serWord, string bTime, string eTime, string passedTypeName, string infoType)
        {
            DataTable dt = SQLHelper.ExecuteSqlGetDrToDt(GetSQL(serWord, bTime, eTime, passedTypeName, infoType));
            return dt;
        }

        #endregion
      //查询，无转正信息，却是正式员工
        public DataTable GetNoPassed()
        {
            DataTable dt = SQLHelper.ExecuteSqlGetDrToDt("Select * from Admin_Employee where Stateid=1 and EmpCode not in (Select EmpCode from Admin_Emp_Passed)");
            return dt;       
        
        }
        //显示一组人,需要如期转正的
        public DataTable GetLists()
        {
            DataTable dt = SQLHelper.ExecuteSqlGetDrToDt("Select *,dateadd(month, TestTimeLong, JoinTime) as ruqiDate From view_emp Where  StateID=2 and month(dateadd(month, TestTimeLong, JoinTime) )=month(getdate())");
            return dt;
        }
        //给一组人设置 需要如期转正的
        public bool ConfigSets(ArrayList empCodeArray, string account)
        {
            bool flag = true;
            if (empCodeArray.Count > 0)
            {
                StringBuilder stringBuilder = new StringBuilder("(");
                
                foreach (object empCode in empCodeArray)
                {
                    string code = empCode.ToString();
                    if (employeeDao.IsExistEmpCode(code))
                    {
                        stringBuilder.Append("'" + code + "',");         
                    }
                    else
                        continue;
                }
                stringBuilder.Append("'0')");                
                string codeArray = stringBuilder.ToString();

                StringBuilder str = new StringBuilder("insert into Admin_Emp_Passed (EmpCode,EmpName,InfoTypeName,PassedTypeName,OldDeptName,OldDutyName,OldAreaName,JoinTime,PassedTime,NewDutyName,account) select EmpCode,EmpName,'入职','如期',DeptName,DutyName,AreaName,JoinTime, dateadd(month, TestTimeLong, JoinTime) as TestEndTime,DutyName,'" + account + "' from view_emp where EmpCode in " + codeArray + " and StateID=2 and month(dateadd(month, TestTimeLong, JoinTime) )=month(getdate());");
                str.Append("Update Admin_Employee set StateID=1,TestEndTime=dateadd(month, TestTimeLong, JoinTime) where EmpCode in " + codeArray + " and StateID=2;");
                
                string strSQL = str.ToString();
                flag = SQLHelper.ExecuteSql(strSQL);
               
            }
            else
            {
                flag = false;

            }
            return flag;
        }
    }
}
