using System;
using System.Collections;
using System.Data;
using System.Data.SqlClient;

using Utils;
namespace DataHelper
{
    /// <summary>
    /// SQL SERVERݿ
    /// </summary>
    public static class SQLHelper //
    {
     

        //ȡַ
        static string conString = XmlUtility.GetConnFormConfig("JIMConn");

     
        //3: ִУӣѣ䣬޷ֵinsert,update,delete䶼ԣ
        ////string sqlstr ΪҪģӣѣ
        public static bool ExecuteSql(string sqlstr)
        {
            bool flag = true;
            try
            {

                int r = ExecuteNonQuery(conString, CommandType.Text, sqlstr);
                 flag= true;
               
            }
            catch
            {
                flag=false;
            }
            return flag;
           
        }
        public static bool ExecuteSqlWithTransaction(string sqlstr)
        {
            bool flag = true;
            try
            {
                using (SqlConnection conn = new SqlConnection(conString))
                {
                    conn.Open();
                    using (SqlCommand objCommand = new SqlCommand(sqlstr, conn))
                    {

                        using (SqlTransaction trans = conn.BeginTransaction())
                        {
                            objCommand.Transaction = trans;
                            objCommand.ExecuteNonQuery();
                            trans.Commit();
                        }
                    }
                }
            }
            catch
            {
                flag = false;

            }

            return flag;

           
        }

        /// <summary>
        /// ִSQLȡ֣IDcount(),sum()
        /// </summary>
        /// <param name="sqlstr">ҪִеSQL</param>
        /// <returns>string aNumberʹõʱҪParse</returns>
        public static string ExecuteSqlGetNumber(string sqlstr)
        {

            string aNumber = "0";
            object obj = ExecuteScalar(conString, CommandType.Text, sqlstr);
            if (obj == null)
                aNumber = "0";
            else
                aNumber = (obj).ToString();
            return aNumber;
           

        }


        /// <summary>
        /// ִУӣѣ䣬ָSqlDataSet
        /// </summary>
        /// <param name="sqlstr">ҪִеSQL</param>
        /// <returns>DataSet ds</returns>

        public static DataSet ExecuteSqlGetDataSet(string sqlstr)
        {
            DataSet ds = ExecuteDataset(conString, CommandType.Text, sqlstr);
            if (ds.Tables.Count == 0)
                return null;
            return ds;
           
        }

        /// <summary>
        /// ִд洢,
        /// </summary>
        /// <param name="procName">洢</param>
        /// <param name="coll">SqlParameter[]</param>
        public static bool ExecutePorcedure(string procName, SqlParameter[] coll)
        {
            int r = ExecuteNonQuery(conString, procName, coll);
            if (r > 0)
                return true;
            else
                return false;
           
        }

         /// <summary>
        /// ִָݿַ,ؽеĵһеһ.
        /// </summary>
        /// <remarks>
        /// ʾ: 
        /// int orderCount = (int)ExecuteScalar(connString, CommandType.StoredProcedure, "GetOrderCount",coll);
        /// </remarks>
        /// <param name="connectionString">һЧݿַ</param>
        /// <param name="commandType"> (洢,ı)</param>
        /// <param name="commandText">洢ƻT-SQL</param>
        /// <returns>ؽеĵһеһ</returns>
        public static string ExecutePorcedureGetNumber( string commandText, SqlParameter[] coll)

        {
            return ExecuteScalar(conString, CommandType.StoredProcedure, commandText, coll).ToString();
        }
        /// <summary>
        /// ִд洢̣ DataSet
        /// </summary>
        /// <param name="procName"> 洢</param>
        /// <param name="coll">SqlParameter[]б</param>
        /// <returns>DataSet ds</returns>
        public static DataSet ExecutePorcedureGetDataSet(string procName, SqlParameter[] coll)
        {
            DataSet ds = ExecuteDataset(conString, procName, coll);
            return ds;
           
        }

        /// <summary>
        /// ִSQLȡDataTable(drת)
        /// </summary>
        /// <param name="sqlstr"></param>
        /// <returns>dt</returns>
        public static DataTable ExecuteSqlGetDrToDt(string sqlstr)
        {
            DataSet ds = ExecuteSqlGetDataSet(sqlstr);
            if (ds == null) return null;
            if (ds.Tables.Count == 0)
                return null;
            return ds.Tables[0];
           
        }
        //ִд洢̣صǰ¼ԶID
        public static object ExecutePorcedureGetID(string procName, SqlParameter[] parameters)
        {
            SqlConnection conn = new SqlConnection(conString);
            SqlCommand cmd = new SqlCommand();
            cmd.Connection = conn;
            cmd.CommandType = CommandType.StoredProcedure;
            cmd.CommandText = procName;
            for (int i = 0; i < parameters.Length; i++)
            {
                cmd.Parameters.Add(parameters[i]);
            }
            conn.Open();
            int n = cmd.ExecuteNonQuery();
            object o = cmd.Parameters["@RETURN_VALUE"].Value;
            conn.Close();
            return o;

        }
        
        
        //12: ִд洢̣  DataTable ͬʱ
        //public static DataTable ExecutePorcedureGetDataTable(string procName, SqlParameter[] coll, out Int32 allRows)
        //{
        //    DataTable dt = new DataTable();
        //    try
        //    {
        //        openDataBase();
        //        for (int i = 0; i < coll.Length; i++)
        //        {
        //            comm.Parameters.Add(coll[i]);
        //        }

        //        comm.CommandType = CommandType.StoredProcedure;
        //        comm.CommandText = procName;
        //        SqlDataAdapter da = new SqlDataAdapter();
        //        da.SelectCommand = comm;
        //        da.Fill(dt);

        //        allRows = (Int32)comm.Parameters["@HowManyRows"].Value;
        //    }
        //    catch (Exception e)
        //    {
        //        throw new Exception(e.Message);
        //    }
        //    finally
        //    {
        //        comm.Parameters.Clear();
        //        closeDataBase();
        //    }
        //    return dt;
        //}

        #region ExecuteNonQuery

        /// <summary>
        /// ִַָ,͵SqlCommand.
        /// </summary>
        /// <remarks>
        /// ʾ:  
        /// int result = ExecuteNonQuery(connString, CommandType.StoredProcedure, "PublishOrders");
        /// </remarks>
        /// <param name="connectionString">һЧݿַ</param>
        /// <param name="commandType"> (洢,ı, .)</param>
        /// <param name="commandText">洢ƻSQL</param>
        /// <returns>Ӱ</returns>
        private static int ExecuteNonQuery(string connectionString, CommandType commandType, string commandText)
        {
            // ExecuteNonQuery #1
            return ExecuteNonQuery(connectionString, commandType, commandText, (SqlParameter[])null);
        }

        /// <summary>
        /// ִַָ,͵SqlCommand.ûṩ,ؽ
        /// </summary>
        /// <remarks>
        /// ʾ:  
        /// int result = ExecuteNonQuery(connString, CommandType.StoredProcedure, "PublishOrders", new SqlParameter("@prodid", 24));
        /// </remarks>
        /// <param name="connectionString">һЧݿַ</param>
        /// <param name="commandType"> (洢,ı, .)</param>
        /// <param name="commandText">洢ƻSQL</param>
        /// <param name="commandParameters">SqlParameter</param>
        /// <returns>Ӱ</returns>
        private static int ExecuteNonQuery(string connectionString, CommandType commandType, string commandText, params SqlParameter[] commandParameters)
        {
            // ExecuteNonQuery #2
            if (connectionString == null || connectionString.Length == 0) throw new ArgumentNullException("connectionString");

            using (SqlConnection connection = new SqlConnection(connectionString))
            {
                connection.Open();
                return ExecuteNonQuery(connection, commandType, commandText, commandParameters);
            }
        }

        /// <summary>
        /// ִַָĴ洢,ֵ洢̲.
        /// ˷Ҫڲ淽̽ɲ.
        /// </summary>
        /// <remarks>
        /// ûṩͷֵ.
        /// ʾ:  
        /// int result = ExecuteNonQuery(connString, "PublishOrders", 24, 36);
        /// </remarks>
        /// <param name="connectionString">һЧݿַ</param>
        /// <param name="spName">洢</param>
        /// <param name="parameterValues">䵽洢Ķ</param>
        /// <returns>Ӱ</returns>
        private static int ExecuteNonQuery(string connectionString, string spName, params object[] parameterValues)
        {
            // ExecuteNonQuery #3
            if (connectionString == null || connectionString.Length == 0) throw new ArgumentNullException("connectionString");
            if (spName == null || spName.Length == 0) throw new ArgumentNullException("spName");

            // ڲֵҪȥ
            if ((parameterValues != null) && (parameterValues.Length > 0))
            {
                // ̽洢̲(ص)洢̲.
                SqlParameter[] commandParameters = GetSpParameterSet(connectionString, spName);

                // 洢ֵ̲
                AssignParameterValues(commandParameters, parameterValues);

                return ExecuteNonQuery(connectionString, CommandType.StoredProcedure, spName, commandParameters);
            }
            else
            {
                // ûв
                return ExecuteNonQuery(connectionString, CommandType.StoredProcedure, spName);
            }
        }

        /// <summary>
        /// ִָݿӶ. 
        /// </summary>
        /// <remarks>
        /// ʾ:  
        /// int result = ExecuteNonQuery(conn, CommandType.StoredProcedure, "PublishOrders");
        /// </remarks>
        /// <param name="connection">һЧݿӶ</param>
        /// <param name="commandType">(洢,ı.)</param>
        /// <param name="commandText">洢ƻT-SQL</param>
        /// <returns>Ӱ</returns>
        private static int ExecuteNonQuery(SqlConnection connection, CommandType commandType, string commandText)
        {
            // ExecuteNonQuery #4
            return ExecuteNonQuery(connection, commandType, commandText, (SqlParameter[])null);
        }

        /// <summary>
        /// ִָݿӶ
        /// </summary>
        /// <remarks>
        /// ʾ:  
        /// int result = ExecuteNonQuery(conn, CommandType.StoredProcedure, "PublishOrders", new SqlParameter("@prodid", 24));
        /// </remarks>
        /// <param name="connection">һЧݿӶ</param>
        /// <param name="commandType">(洢,ı.)</param>
        /// <param name="commandText">T洢ƻT-SQL</param>
        /// <param name="commandParameters">SqlParamter</param>
        /// <returns>Ӱ</returns>
        private static int ExecuteNonQuery(SqlConnection connection, CommandType commandType, string commandText, params SqlParameter[] commandParameters)
        {
            // ExecuteNonQuery #5
            if (connection == null) throw new ArgumentNullException("connection");

            SqlCommand cmd = new SqlCommand();
            bool mustCloseConnection = false;
            PrepareCommand(cmd, connection, (SqlTransaction)null, commandType, commandText, commandParameters, out mustCloseConnection);

            int retval = cmd.ExecuteNonQuery();

            cmd.Parameters.Clear();
            if (mustCloseConnection)
                connection.Close();
            return retval;
        }

        /// <summary>
        /// ִָݿӶ,ֵ洢̲.
        /// </summary>
        /// <remarks>
        /// ˷ṩʴ洢ͷֵ
        /// ʾ:  
        /// int result = ExecuteNonQuery(conn, "PublishOrders", 24, 36);
        /// </remarks>
        /// <param name="connection">һЧݿӶ</param>
        /// <param name="spName">洢</param>
        /// <param name="parameterValues">洢Ķ</param>
        /// <returns>Ӱ</returns>
        private static int ExecuteNonQuery(SqlConnection connection, string spName, params object[] parameterValues)
        {
            // ExecuteNonQuery #6
            if (connection == null) throw new ArgumentNullException("connection");
            if (spName == null || spName.Length == 0) throw new ArgumentNullException("spName");

            // вֵ
            if ((parameterValues != null) && (parameterValues.Length > 0))
            {
                // ӻмش洢̲
                SqlParameter[] commandParameters = GetSpParameterSet(connection, spName);

                // 洢̷ֵ
                AssignParameterValues(commandParameters, parameterValues);

                return ExecuteNonQuery(connection, CommandType.StoredProcedure, spName, commandParameters);
            }
            else
            {
                return ExecuteNonQuery(connection, CommandType.StoredProcedure, spName);
            }
        }

        /// <summary>
        /// ִдSqlCommand. 
        /// </summary>
        /// <remarks>
        /// ʾ:  
        /// int result = ExecuteNonQuery(trans, CommandType.StoredProcedure, "PublishOrders");
        /// </remarks>
        /// <param name="transaction">һЧ</param>
        /// <param name="commandType">(洢,ı.)</param>
        /// <param name="commandText">洢ƻT-SQL</param>
        /// <returns>Ӱ</returns>
        private static int ExecuteNonQuery(SqlTransaction transaction, CommandType commandType, string commandText)
        {
            // ExecuteNonQuery #7
            return ExecuteNonQuery(transaction, commandType, commandText, (SqlParameter[])null);
        }

        /// <summary>
        /// ִдSqlCommand(ָ).
        /// </summary>
        /// <remarks>
        /// ʾ:  
        /// int result = ExecuteNonQuery(trans, CommandType.StoredProcedure, "GetOrders", new SqlParameter("@prodid", 24));
        /// </remarks>
        /// <param name="transaction">һЧݿ</param>
        /// <param name="commandType">(洢,ı.)</param>
        /// <param name="commandText">洢ƻT-SQL</param>
        /// <param name="commandParameters">SqlParamter</param>
        /// <returns>Ӱ</returns>
        private static int ExecuteNonQuery(SqlTransaction transaction, CommandType commandType, string commandText, params SqlParameter[] commandParameters)
        {
            // ExecuteNonQuery #8
            if (transaction == null) throw new ArgumentNullException("transaction");
            if (transaction != null && transaction.Connection == null) throw new ArgumentException("The transaction was rollbacked or commited, please provide an open transaction.", "transaction");

            //Ԥ
            SqlCommand cmd = new SqlCommand();
            bool mustCloseConnection = false;
            PrepareCommand(cmd, transaction.Connection, transaction, commandType, commandText, commandParameters, out mustCloseConnection);

            // ִ
            int retval = cmd.ExecuteNonQuery();

            // ,Աٴʹ
            cmd.Parameters.Clear();
            return retval;
        }

        /// <summary>
        /// ִдSqlCommand(ֵָ).
        /// </summary>
        /// <remarks>
        /// ˷ṩʴ洢ͷֵ
        /// ʾ:  
        /// int result = ExecuteNonQuery(conn, trans, "PublishOrders", 24, 36);
        /// </remarks>
        /// <param name="transaction">һЧݿӶ</param>
        /// <param name="spName">洢</param>
        /// <param name="parameterValues">洢Ķ</param>
        /// <returns>Ӱ</returns>
        private static int ExecuteNonQuery(SqlTransaction transaction, string spName, params object[] parameterValues)
        {
            // ExecuteNonQuery #9
            if (transaction == null) throw new ArgumentNullException("transaction");
            if (transaction != null && transaction.Connection == null) throw new ArgumentException("The transaction was rollbacked or commited, please provide an open transaction.", "transaction");
            if (spName == null || spName.Length == 0) throw new ArgumentNullException("spName");

            // вֵ
            if ((parameterValues != null) && (parameterValues.Length > 0))
            {
                // ӻмش洢̲,вݿмϢص.
                SqlParameter[] commandParameters = GetSpParameterSet(transaction.Connection, spName);

                // 洢ֵ̲
                AssignParameterValues(commandParameters, parameterValues);

                // ط
                return ExecuteNonQuery(transaction, CommandType.StoredProcedure, spName, commandParameters);
            }
            else
            {
                // ûвֵ
                return ExecuteNonQuery(transaction, CommandType.StoredProcedure, spName);
            }
        }

        #endregion ExecuteNonQuery



        #region ExecuteDataset

        /// <summary>
        /// ִָݿַ,DataSet. 
        /// </summary>
        /// <remarks>
        /// ʾ:  
        /// DataSet ds = ExecuteDataset(connString, CommandType.StoredProcedure, "GetOrders");
        /// </remarks>
        /// <param name="connectionString">һЧݿַ</param>
        /// <param name="commandType">(洢,ı)</param>
        /// <param name="commandText">洢ƻT-SQL</param>
        /// <returns>һDataSet</returns>
        public static DataSet ExecuteDataset(string connectionString, CommandType commandType, string commandText)
        {
            // ExecuteDataset #1
            return ExecuteDataset(connectionString, commandType, commandText, (SqlParameter[])null);
        }

        /// <summary>
        /// ִָݿַ,DataSet.
        /// </summary>
        /// <remarks>
        /// ʾ:  
        /// DataSet ds = ExecuteDataset(connString, CommandType.StoredProcedure, "GetOrders", new SqlParameter("@prodid", 24));
        /// </remarks>
        /// <param name="connectionString">һЧݿַ</param>
        /// <param name="commandType">(洢,ı)</param>
        /// <param name="commandText">洢ƻT-SQL</param>
        /// <param name="commandParameters">SqlParamters</param>
        /// <returns>һDataSet</returns>
        public static DataSet ExecuteDataset(string connectionString, CommandType commandType, string commandText, params SqlParameter[] commandParameters)
        {
            // ExecuteDataset #2
            if (connectionString == null || connectionString.Length == 0) throw new ArgumentNullException("connectionString");

            using (SqlConnection connection = new SqlConnection(connectionString))
            {
                connection.Open();
                return ExecuteDataset(connection, commandType, commandText, commandParameters);
            }
        }

        /// <summary>
        /// ִָݿַ,ֱṩֵ,DataSet.
        /// </summary>
        /// <remarks>
        /// ˷ṩʴ洢ͷֵ.
        /// ʾ:  
        /// DataSet ds = ExecuteDataset(connString, "GetOrders", 24, 36);
        /// </remarks>
        /// <param name="connectionString">һЧݿַ</param>
        /// <param name="spName">洢</param>
        /// <param name="parameterValues">洢Ķ</param>
        /// <returns>һDataSet</returns>
        public static DataSet ExecuteDataset(string connectionString, string spName, params object[] parameterValues)
        {
            // ExecuteDataset #3
            if (connectionString == null || connectionString.Length == 0) throw new ArgumentNullException("connectionString");
            if (spName == null || spName.Length == 0) throw new ArgumentNullException("spName");

            if ((parameterValues != null) && (parameterValues.Length > 0))
            {
                // ӻм洢̲
                SqlParameter[] commandParameters = GetSpParameterSet(connectionString, spName);

                // 洢ֵ̲
                AssignParameterValues(commandParameters, parameterValues);
                return ExecuteDataset(connectionString, CommandType.StoredProcedure, spName, commandParameters);
            }
            else
            {
                return ExecuteDataset(connectionString, CommandType.StoredProcedure, spName);
            }
        }

        /// <summary>
        /// ִָݿӶ,DataSet. 
        /// </summary>
        /// <remarks>
        /// ʾ:  
        /// DataSet ds = ExecuteDataset(conn, CommandType.StoredProcedure, "GetOrders");
        /// </remarks>
        /// <param name="connection">һЧݿӶ</param>
        /// <param name="commandType"> (洢,ı)</param>
        /// <param name="commandText">洢T-SQL</param>
        /// <returns>һDataSet</returns>
        public static DataSet ExecuteDataset(SqlConnection connection, CommandType commandType, string commandText)
        {
            // ExecuteDataset #4
            return ExecuteDataset(connection, commandType, commandText, (SqlParameter[])null);
        }

        /// <summary>
        /// ִָݿӶ,ָ洢̲,DataSet.
        /// </summary>
        /// <remarks>
        /// ʾ:  
        /// DataSet ds = ExecuteDataset(conn, CommandType.StoredProcedure, "GetOrders", new SqlParameter("@prodid", 24));
        /// </remarks>
        /// <param name="connection">һЧݿӶ</param>
        /// <param name="commandType"> (洢,ı)</param>
        /// <param name="commandText">洢T-SQL</param>
        /// <param name="commandParameters">SqlParamter</param>
        /// <returns>һDataSet</returns>
        public static DataSet ExecuteDataset(SqlConnection connection, CommandType commandType, string commandText, params SqlParameter[] commandParameters)
        {
            // ExecuteDataset #5
            if (connection == null) throw new ArgumentNullException("connection");

            // Ԥ
            SqlCommand cmd = new SqlCommand();
            bool mustCloseConnection = false;
            PrepareCommand(cmd, connection, (SqlTransaction)null, commandType, commandText, commandParameters, out mustCloseConnection);

            // SqlDataAdapterDataSet.
            using (SqlDataAdapter da = new SqlDataAdapter(cmd))
            {
                DataSet ds = new DataSet();
                // DataSet.
                da.Fill(ds);
                cmd.Parameters.Clear();
                if (mustCloseConnection)
                    connection.Close();
                return ds;
            }
        }

        /// <summary>
        /// ִָݿӶ,ֵָ,DataSet.
        /// </summary>
        /// <remarks>
        /// ˷ṩʴ洢ͷֵ.
        /// ʾ.: 
        ///  DataSet ds = ExecuteDataset(conn, "GetOrders", 24, 36);
        /// </remarks>
        /// <param name="connection">һЧݿӶ</param>
        /// <param name="spName">洢</param>
        /// <param name="parameterValues">洢Ķ</param>
        /// <returns>һDataSet</returns>
        public static DataSet ExecuteDataset(SqlConnection connection, string spName, params object[] parameterValues)
        {
            // ExecuteDataset #6
            if (connection == null) throw new ArgumentNullException("connection");
            if (spName == null || spName.Length == 0) throw new ArgumentNullException("spName");
            if ((parameterValues != null) && (parameterValues.Length > 0))
            {
                // Ȼмش洢̲
                SqlParameter[] commandParameters = GetSpParameterSet(connection, spName);
                // 洢ֵ̲
                AssignParameterValues(commandParameters, parameterValues);
                return ExecuteDataset(connection, CommandType.StoredProcedure, spName, commandParameters);
            }
            else
            {
                return ExecuteDataset(connection, CommandType.StoredProcedure, spName);
            }
        }

        /// <summary>
        /// ִָ,DataSet.
        /// </summary>
        /// <remarks>
        /// ʾ: 
        /// DataSet ds = ExecuteDataset(trans, CommandType.StoredProcedure, "GetOrders");
        /// </remarks>
        /// <param name="transaction"></param>
        /// <param name="commandType"> (洢,ı)</param>
        /// <param name="commandText">洢T-SQL</param>
        /// <returns>һDataSet</returns>
        public static DataSet ExecuteDataset(SqlTransaction transaction, CommandType commandType, string commandText)
        {
            // ExecuteDataset #7
            return ExecuteDataset(transaction, commandType, commandText, (SqlParameter[])null);
        }

        /// <summary>
        /// ִָ,ָ,DataSet.
        /// </summary>
        /// <remarks>
        /// ʾ: 
        /// DataSet ds = ExecuteDataset(trans, CommandType.StoredProcedure, "GetOrders", new SqlParameter("@prodid", 24));
        /// </remarks>
        /// <param name="transaction"></param>
        /// <param name="commandType"> (洢,ı)</param>
        /// <param name="commandText">洢T-SQL</param>
        /// <param name="commandParameters">SqlParamter</param>
        /// <returns>һDataSet</returns>
        public static DataSet ExecuteDataset(SqlTransaction transaction, CommandType commandType, string commandText, params SqlParameter[] commandParameters)
        {
            // ExecuteDataset #8
            if (transaction == null) throw new ArgumentNullException("transaction");
            if (transaction != null && transaction.Connection == null) throw new ArgumentException("The transaction was rollbacked or commited, please provide an open transaction.", "transaction");
            // Ԥ
            SqlCommand cmd = new SqlCommand();
            bool mustCloseConnection = false;
            PrepareCommand(cmd, transaction.Connection, transaction, commandType, commandText, commandParameters, out mustCloseConnection);

            //  DataAdapter & DataSet
            using (SqlDataAdapter da = new SqlDataAdapter(cmd))
            {
                DataSet ds = new DataSet();
                da.Fill(ds);
                cmd.Parameters.Clear();
                return ds;
            }
        }

        /// <summary>
        /// ִָ,ֵָ,DataSet.
        /// </summary>
        /// <remarks>
        /// ˷ṩʴ洢ͷֵ.
        /// ʾ.: 
        ///  DataSet ds = ExecuteDataset(trans, "GetOrders", 24, 36);
        /// </remarks>
        /// <param name="transaction"></param>
        /// <param name="spName">洢</param>
        /// <param name="parameterValues">洢Ķ</param>
        /// <returns>һDataSet</returns>
        public static DataSet ExecuteDataset(SqlTransaction transaction, string spName, params object[] parameterValues)
        {
            // ExecuteDataset #9
            if (transaction == null) throw new ArgumentNullException("transaction");
            if (transaction != null && transaction.Connection == null) throw new ArgumentException("The transaction was rollbacked or commited, please provide an open transaction.", "transaction");
            if (spName == null || spName.Length == 0) throw new ArgumentNullException("spName");

            if ((parameterValues != null) && (parameterValues.Length > 0))
            {
                // ӻмش洢̲
                SqlParameter[] commandParameters = GetSpParameterSet(transaction.Connection, spName);
                // 洢ֵ̲
                AssignParameterValues(commandParameters, parameterValues);
                return ExecuteDataset(transaction, CommandType.StoredProcedure, spName, commandParameters);
            }
            else
            {
                return ExecuteDataset(transaction, CommandType.StoredProcedure, spName);
            }
        }

        #endregion ExecuteDataset



        #region ExecuteScalar ؽеĵһеһ

        /// <summary>
        /// ִָݿַ,ؽеĵһеһ.
        /// </summary>
        /// <remarks>
        /// ʾ: 
        /// int orderCount = (int)ExecuteScalar(connString, CommandType.StoredProcedure, "GetOrderCount");
        /// </remarks>
        /// <param name="connectionString">һЧݿַ</param>
        /// <param name="commandType"> (洢,ı)</param>
        /// <param name="commandText">洢ƻT-SQL</param>
        /// <returns>ؽеĵһеһ</returns>
        private static object ExecuteScalar(string connectionString, CommandType commandType, string commandText)
        {
            // ExecuteScalar #1
            // ִвΪյķ
            return ExecuteScalar(connectionString, commandType, commandText, (SqlParameter[])null);
        }

        /// <summary>
        /// ִָݿַ,ָ,ؽеĵһеһ.
        /// </summary>
        /// <remarks>
        /// ʾ: 
        /// int orderCount = (int)ExecuteScalar(connString, CommandType.StoredProcedure, "GetOrderCount", new SqlParameter("@prodid", 24));
        /// </remarks>
        /// <param name="connectionString">һЧݿַ</param>
        /// <param name="commandType"> (洢,ı)</param>
        /// <param name="commandText">洢ƻT-SQL</param>
        /// <param name="commandParameters">SqlParamter</param>
        /// <returns>ؽеĵһеһ</returns>
        private static object ExecuteScalar(string connectionString, CommandType commandType, string commandText, params SqlParameter[] commandParameters)
        {
            // ExecuteScalar #2
            if (connectionString == null || connectionString.Length == 0) throw new ArgumentNullException("connectionString");
            // ݿӶ,ͷŶ.
            using (SqlConnection connection = new SqlConnection(connectionString))
            {
                connection.Open();
                // ָݿַط.
                return ExecuteScalar(connection, commandType, commandText, commandParameters);
            }
        }

        /// <summary>
        /// ִָݿַ,ֵָ,ؽеĵһеһ.
        /// </summary>
        /// <remarks>
        /// ˷ṩʴ洢ͷֵ.
        /// ʾ: 
        /// int orderCount = (int)ExecuteScalar(connString, "GetOrderCount", 24, 36);
        /// </remarks>
        /// <param name="connectionString">һЧݿַ</param>
        /// <param name="spName">洢</param>
        /// <param name="parameterValues">洢Ķ</param>
        /// <returns>ؽеĵһеһ</returns>
        private static object ExecuteScalar(string connectionString, string spName, params object[] parameterValues)
        {
            // ExecuteScalar #3
            if (connectionString == null || connectionString.Length == 0) throw new ArgumentNullException("connectionString");
            if (spName == null || spName.Length == 0) throw new ArgumentNullException("spName");
            // вֵ
            if ((parameterValues != null) && (parameterValues.Length > 0))
            {
                // ӻмش洢̲,вݿмϢص. ()
                SqlParameter[] commandParameters = GetSpParameterSet(connectionString, spName);
                // 洢ֵ̲
                AssignParameterValues(commandParameters, parameterValues);
                // ط
                return ExecuteScalar(connectionString, CommandType.StoredProcedure, spName, commandParameters);
            }
            else
            {
                // ûвֵ
                return ExecuteScalar(connectionString, CommandType.StoredProcedure, spName);
            }
        }
        /// <summary>
        /// ִָݿӶ,ؽеĵһеһ.
        /// </summary>
        /// <remarks>
        /// ʾ: 
        /// int orderCount = (int)ExecuteScalar(conn, CommandType.StoredProcedure, "GetOrderCount");
        /// </remarks>
        /// <param name="connection">һЧݿӶ</param>
        /// <param name="commandType"> (洢,ı)</param>
        /// <param name="commandText">洢ƻT-SQL</param>
        /// <returns>ؽеĵһеһ</returns>
        private static object ExecuteScalar(SqlConnection connection, CommandType commandType, string commandText)
        {
            // ExecuteScalar #4
            // ִвΪյķ
            return ExecuteScalar(connection, commandType, commandText, (SqlParameter[])null);
        }

        /// <summary>
        /// ִָݿӶ,ָ,ؽеĵһеһ.
        /// </summary>
        /// <remarks>
        /// ʾ: 
        /// int orderCount = (int)ExecuteScalar(conn, CommandType.StoredProcedure, "GetOrderCount", new SqlParameter("@prodid", 24));
        /// </remarks>
        /// <param name="connection">һЧݿӶ</param>
        /// <param name="commandType"> (洢,ı)</param>
        /// <param name="commandText">洢ƻT-SQL</param>
        /// <param name="commandParameters">SqlParamter</param>
        /// <returns>ؽеĵһеһ</returns>
        private static object ExecuteScalar(SqlConnection connection, CommandType commandType, string commandText, params SqlParameter[] commandParameters)
        {
            // ExecuteScalar #5
            if (connection == null) throw new ArgumentNullException("connection");
            // SqlCommand,Ԥ
            SqlCommand cmd = new SqlCommand();
            bool mustCloseConnection = false;
            PrepareCommand(cmd, connection, (SqlTransaction)null, commandType, commandText, commandParameters, out mustCloseConnection);
            // ִSqlCommand,ؽ.
            object retval = cmd.ExecuteScalar();
            // ,Աٴʹ.
            cmd.Parameters.Clear();
            if (mustCloseConnection)
                connection.Close();
            return retval;
        }
        /// <summary>
        /// ִָݿӶ,ֵָ,ؽеĵһеһ.
        /// </summary>
        /// <remarks>
        /// ˷ṩʴ洢ͷֵ.
        /// ʾ: 
        /// int orderCount = (int)ExecuteScalar(conn, "GetOrderCount", 24, 36);
        /// </remarks>
        /// <param name="connection">һЧݿӶ</param>
        /// <param name="spName">洢</param>
        /// <param name="parameterValues">洢Ķ</param>
        /// <returns>ؽеĵһеһ</returns>
        private static object ExecuteScalar(SqlConnection connection, string spName, params object[] parameterValues)
        {
            // ExecuteScalar #6
            if (connection == null) throw new ArgumentNullException("connection");
            if (spName == null || spName.Length == 0) throw new ArgumentNullException("spName");
            // вֵ
            if ((parameterValues != null) && (parameterValues.Length > 0))
            {
                // ӻмش洢̲,вݿмϢص. ()
                SqlParameter[] commandParameters = GetSpParameterSet(connection, spName);
                // 洢ֵ̲
                AssignParameterValues(commandParameters, parameterValues);
                // ط
                return ExecuteScalar(connection, CommandType.StoredProcedure, spName, commandParameters);
            }
            else
            {
                // ûвֵ
                return ExecuteScalar(connection, CommandType.StoredProcedure, spName);
            }
        }

        /// <summary>
        /// ִָݿ,ؽеĵһеһ.
        /// </summary>
        /// <remarks>
        /// ʾ: 
        /// int orderCount = (int)ExecuteScalar(trans, CommandType.StoredProcedure, "GetOrderCount");
        /// </remarks>
        /// <param name="transaction">һЧ</param>
        /// <param name="commandType"> (洢,ı)</param>
        /// <param name="commandText">洢ƻT-SQL</param>
        /// <returns>ؽеĵһеһ</returns>
        private static object ExecuteScalar(SqlTransaction transaction, CommandType commandType, string commandText)
        {
            // ExecuteScalar #7
            // ִвΪյķ
            return ExecuteScalar(transaction, commandType, commandText, (SqlParameter[])null);
        }

        /// <summary>
        /// ִָݿ,ָ,ؽеĵһеһ.
        /// </summary>
        /// <remarks>
        /// ʾ: 
        /// int orderCount = (int)ExecuteScalar(trans, CommandType.StoredProcedure, "GetOrderCount", new SqlParameter("@prodid", 24));
        /// </remarks>
        /// <param name="transaction">һЧ</param>
        /// <param name="commandType"> (洢,ı)</param>
        /// <param name="commandText">洢ƻT-SQL</param>
        /// <param name="commandParameters">SqlParamter</param>
        /// <returns>ؽеĵһеһ</returns>
        private static object ExecuteScalar(SqlTransaction transaction, CommandType commandType, string commandText, params SqlParameter[] commandParameters)
        {
            // ExecuteScalar #8
            if (transaction == null) throw new ArgumentNullException("transaction");
            if (transaction != null && transaction.Connection == null) throw new ArgumentException("The transaction was rollbacked or commited, please provide an open transaction.", "transaction");

            // SqlCommand,Ԥ
            SqlCommand cmd = new SqlCommand();
            bool mustCloseConnection = false;
            PrepareCommand(cmd, transaction.Connection, transaction, commandType, commandText, commandParameters, out mustCloseConnection);

            // ִSqlCommand,ؽ.
            object retval = cmd.ExecuteScalar();

            // ,Աٴʹ.
            cmd.Parameters.Clear();
            return retval;
        }

        /// <summary>
        /// ִָݿ,ֵָ,ؽеĵһеһ.
        /// </summary>
        /// <remarks>
        /// ˷ṩʴ洢ͷֵ.
        /// ʾ: 
        /// int orderCount = (int)ExecuteScalar(trans, "GetOrderCount", 24, 36);
        /// </remarks>
        /// <param name="transaction">һЧ</param>
        /// <param name="spName">洢</param>
        /// <param name="parameterValues">洢Ķ</param>
        /// <returns>ؽеĵһеһ</returns>
        private static object ExecuteScalar(SqlTransaction transaction, string spName, params object[] parameterValues)
        {
            // ExecuteScalar #9
            if (transaction == null) throw new ArgumentNullException("transaction");
            if (transaction != null && transaction.Connection == null) throw new ArgumentException("The transaction was rollbacked or commited, please provide an open transaction.", "transaction");
            if (spName == null || spName.Length == 0) throw new ArgumentNullException("spName");

            // вֵ
            if ((parameterValues != null) && (parameterValues.Length > 0))
            {
                SqlParameter[] commandParameters = GetSpParameterSet(transaction.Connection, spName);

                // 洢ֵ̲
                AssignParameterValues(commandParameters, parameterValues);

                // ط
                return ExecuteScalar(transaction, CommandType.StoredProcedure, spName, commandParameters);
            }
            else
            {
                // ûвֵ
                return ExecuteScalar(transaction, CommandType.StoredProcedure, spName);
            }
        }

        #endregion ExecuteScalar

        #region ˽й캯ͷ

        /// <summary>
        /// SqlParameters飨ֵSqlCommand
        /// κһDBNull.Value
        /// òֹĬֵʹãүģû
        /// </summary>
        /// <param name="command">ҪSqlParametersSqlCommand</param>
        /// <param name="commandParameters">SqlParameters</param>
        private static void AttachParameters(SqlCommand command, SqlParameter[] commandParameters)
        {
            if (command == null) throw new ArgumentNullException("command");
            if (commandParameters != null)
            {
                foreach (SqlParameter p in commandParameters)
                {
                    if (p != null)
                    {
                        // Check for derived output value with no value assigned
                        if ((p.Direction == ParameterDirection.InputOutput ||
                            p.Direction == ParameterDirection.Input) &&
                            (p.Value == null))
                        {
                            p.Value = DBNull.Value;
                        }
                        command.Parameters.Add(p);
                    }
                }
            }
        }

        /// <summary>
        /// DataRow͵ֵ䵽SqlParameter
        /// </summary>
        /// <param name="commandParameters">ҪSqlParameter</param>
        /// <param name="dataRow">Ҫ洢̲DataRow</param>
        private static void AssignParameterValues(SqlParameter[] commandParameters, DataRow dataRow)
        {
            if ((commandParameters == null) || (dataRow == null))
            {
                // ûнյݾͷ
                return;
            }

            int i = 0;
            // òֵ
            foreach (SqlParameter commandParameter in commandParameters)
            {
                // ƣڣ׳һ쳣
                if (commandParameter.ParameterName == null ||
                    commandParameter.ParameterName.Length <= 1)
                    throw new Exception(
                        string.Format(
                            "ṩ{0},һЧ{1}.",
                            i, commandParameter.ParameterName));
                // DataRowıлȡΪƵе.
                // ںͲͬ,ֵǰƵĲ.
                if (dataRow.Table.Columns.IndexOf(commandParameter.ParameterName.Substring(1)) != -1)
                    commandParameter.Value = dataRow[commandParameter.ParameterName.Substring(1)];
                i++;
            }
        }

        /// <summary>
        /// һSqlParameter.ط
        /// </summary>
        /// <param name="commandParameters">ҪSqlParameter</param>
        /// <param name="parameterValues">Ҫ洢̲Ķ</param>
        private static void AssignParameterValues(SqlParameter[] commandParameters, object[] parameterValues)
        {
            if ((commandParameters == null) || (parameterValues == null))
            {
                return;
            }

            // ȷƥ,ƥ,׳һ쳣
            if (commandParameters.Length != parameterValues.Length)
            {
                throw new ArgumentException("ֵƥ.");
            }

            // ֵ
            for (int i = 0, j = commandParameters.Length; i < j; i++)
            {
                if (parameterValues[i] is IDbDataParameter)
                {
                    IDbDataParameter paramInstance = (IDbDataParameter)parameterValues[i];
                    if (paramInstance.Value == null)
                    {
                        commandParameters[i].Value = DBNull.Value;
                    }
                    else
                    {
                        commandParameters[i].Value = paramInstance.Value;
                    }
                }
                else if (parameterValues[i] == null)
                {
                    commandParameters[i].Value = DBNull.Value;
                }
                else
                {
                    commandParameters[i].Value = parameterValues[i];
                }
            }
        }

        /// <summary>
        /// Ԥûṩ,ݿ///
        /// </summary>
        /// <param name="command">ҪSqlCommand</param>
        /// <param name="connection">Чݿ</param>
        /// <param name="transaction">һЧnullֵ</param>
        /// <param name="commandType"> (洢,ı, .)</param>
        /// <param name="commandText">洢T-SQLı</param>
        /// <param name="commandParameters">SqlParameter,ûвΪ'null'</param>
        /// <param name="mustCloseConnection"><c>true</c> Ǵ򿪵,Ϊtrue,Ϊfalse.</param>
        public static void PrepareCommand(SqlCommand command, SqlConnection connection, SqlTransaction transaction, CommandType commandType, string commandText, SqlParameter[] commandParameters, out bool mustCloseConnection)
        {
            if (command == null) throw new ArgumentNullException("command");
            if (commandText == null || commandText.Length == 0) throw new ArgumentNullException("commandText");

            if (connection.State != ConnectionState.Open)
            {
                mustCloseConnection = true;
                connection.Open();
            }
            else
            {
                mustCloseConnection = false;
            }

            command.CommandTimeout = 1000 * 60 * 60; // 60

            // һݿ.
            command.Connection = connection;

            // ı(洢SQL)
            command.CommandText = commandText;

            // 
            if (transaction != null)
            {
                if (transaction.Connection == null) throw new ArgumentException("The transaction was rollbacked or commited, please provide an open transaction.", "transaction");
                command.Transaction = transaction;
            }

            // .
            command.CommandType = commandType;

            // 
            if (commandParameters != null)
            {
                AttachParameters(command, commandParameters);
            }
            return;
        }

        #endregion ˽й캯ͷ



        #region private methods, variables, and constructors

        private static Hashtable paramCache = Hashtable.Synchronized(new Hashtable());

        /// <summary>
        /// Resolve at run time the appropriate set of SqlParameters for a stored procedure
        /// </summary>
        /// <param name="connection">A valid SqlConnection object</param>
        /// <param name="spName">The name of the stored procedure</param>
        /// <param name="includeReturnValueParameter">Whether or not to include their return value parameter</param>
        /// <returns>The parameter array discovered.</returns>
        private static SqlParameter[] DiscoverSpParameterSet(SqlConnection connection, string spName, bool includeReturnValueParameter)
        {
            if (connection == null) throw new ArgumentNullException("connection");
            if (spName == null || spName.Length == 0) throw new ArgumentNullException("spName");

            SqlCommand cmd = new SqlCommand(spName, connection);
            cmd.CommandType = CommandType.StoredProcedure;

            connection.Open();
            SqlCommandBuilder.DeriveParameters(cmd);
            connection.Close();

            if (!includeReturnValueParameter)
            {
                cmd.Parameters.RemoveAt(0);
            }

            SqlParameter[] discoveredParameters = new SqlParameter[cmd.Parameters.Count];

            cmd.Parameters.CopyTo(discoveredParameters, 0);

            // Init the parameters with a DBNull value
            foreach (SqlParameter discoveredParameter in discoveredParameters)
            {
                discoveredParameter.Value = DBNull.Value;
            }
            return discoveredParameters;
        }

        /// <summary>
        /// Deep copy of cached SqlParameter array
        /// </summary>
        /// <param name="originalParameters"></param>
        /// <returns></returns>
        private static SqlParameter[] CloneParameters(SqlParameter[] originalParameters)
        {
            SqlParameter[] clonedParameters = new SqlParameter[originalParameters.Length];

            for (int i = 0, j = originalParameters.Length; i < j; i++)
            {
                clonedParameters[i] = (SqlParameter)((ICloneable)originalParameters[i]).Clone();
            }

            return clonedParameters;
        }

        #endregion private methods, variables, and constructors

        #region caching functions

        /// <summary>
        /// Add parameter array to the cache
        /// </summary>
        /// <param name="connectionString">A valid connection string for a SqlConnection</param>
        /// <param name="commandText">The stored procedure name or T-SQL command</param>
        /// <param name="commandParameters">An array of SqlParamters to be cached</param>
        private static void CacheParameterSet(string connectionString, string commandText, params SqlParameter[] commandParameters)
        {
            if (connectionString == null || connectionString.Length == 0) throw new ArgumentNullException("connectionString");
            if (commandText == null || commandText.Length == 0) throw new ArgumentNullException("commandText");

            string hashKey = connectionString + ":" + commandText;

            paramCache[hashKey] = commandParameters;
        }

        /// <summary>
        /// Retrieve a parameter array from the cache
        /// </summary>
        /// <param name="connectionString">A valid connection string for a SqlConnection</param>
        /// <param name="commandText">The stored procedure name or T-SQL command</param>
        /// <returns>An array of SqlParamters</returns>
        private static SqlParameter[] GetCachedParameterSet(string connectionString, string commandText)
        {
            if (connectionString == null || connectionString.Length == 0) throw new ArgumentNullException("connectionString");
            if (commandText == null || commandText.Length == 0) throw new ArgumentNullException("commandText");

            string hashKey = connectionString + ":" + commandText;

            SqlParameter[] cachedParameters = paramCache[hashKey] as SqlParameter[];
            if (cachedParameters == null)
            {
                return null;
            }
            else
            {
                return CloneParameters(cachedParameters);
            }
        }

        #endregion caching functions

        #region Parameter Discovery Functions

        /// <summary>
        /// Retrieves the set of SqlParameters appropriate for the stored procedure
        /// </summary>
        /// <remarks>
        /// This method will query the database for this information, and then store it in a cache for future requests.
        /// </remarks>
        /// <param name="connectionString">A valid connection string for a SqlConnection</param>
        /// <param name="spName">The name of the stored procedure</param>
        /// <returns>An array of SqlParameters</returns>
        private static SqlParameter[] GetSpParameterSet(string connectionString, string spName)
        {
            return GetSpParameterSet(connectionString, spName, false);
        }

        /// <summary>
        /// Retrieves the set of SqlParameters appropriate for the stored procedure
        /// </summary>
        /// <remarks>
        /// This method will query the database for this information, and then store it in a cache for future requests.
        /// </remarks>
        /// <param name="connectionString">A valid connection string for a SqlConnection</param>
        /// <param name="spName">The name of the stored procedure</param>
        /// <param name="includeReturnValueParameter">A bool value indicating whether the return value parameter should be included in the results</param>
        /// <returns>An array of SqlParameters</returns>
        private static SqlParameter[] GetSpParameterSet(string connectionString, string spName, bool includeReturnValueParameter)
        {
            if (connectionString == null || connectionString.Length == 0) throw new ArgumentNullException("connectionString");
            if (spName == null || spName.Length == 0) throw new ArgumentNullException("spName");

            using (SqlConnection connection = new SqlConnection(connectionString))
            {
                return GetSpParameterSetInternal(connection, spName, includeReturnValueParameter);
            }
        }

        /// <summary>
        /// Retrieves the set of SqlParameters appropriate for the stored procedure
        /// </summary>
        /// <remarks>
        /// This method will query the database for this information, and then store it in a cache for future requests.
        /// </remarks>
        /// <param name="connection">A valid SqlConnection object</param>
        /// <param name="spName">The name of the stored procedure</param>
        /// <returns>An array of SqlParameters</returns>
        static internal SqlParameter[] GetSpParameterSet(SqlConnection connection, string spName)
        {
            return GetSpParameterSet(connection, spName, false);
        }

        /// <summary>
        /// Retrieves the set of SqlParameters appropriate for the stored procedure
        /// </summary>
        /// <remarks>
        /// This method will query the database for this information, and then store it in a cache for future requests.
        /// </remarks>
        /// <param name="connection">A valid SqlConnection object</param>
        /// <param name="spName">The name of the stored procedure</param>
        /// <param name="includeReturnValueParameter">A bool value indicating whether the return value parameter should be included in the results</param>
        /// <returns>An array of SqlParameters</returns>
        static internal SqlParameter[] GetSpParameterSet(SqlConnection connection, string spName, bool includeReturnValueParameter)
        {
            if (connection == null) throw new ArgumentNullException("connection");
            using (SqlConnection clonedConnection = (SqlConnection)((ICloneable)connection).Clone())
            {
                return GetSpParameterSetInternal(clonedConnection, spName, includeReturnValueParameter);
            }
        }

        /// <summary>
        /// Retrieves the set of SqlParameters appropriate for the stored procedure
        /// </summary>
        /// <param name="connection">A valid SqlConnection object</param>
        /// <param name="spName">The name of the stored procedure</param>
        /// <param name="includeReturnValueParameter">A bool value indicating whether the return value parameter should be included in the results</param>
        /// <returns>An array of SqlParameters</returns>
        private static SqlParameter[] GetSpParameterSetInternal(SqlConnection connection, string spName, bool includeReturnValueParameter)
        {
            if (connection == null) throw new ArgumentNullException("connection");
            if (spName == null || spName.Length == 0) throw new ArgumentNullException("spName");

            string hashKey = connection.ConnectionString + ":" + spName + (includeReturnValueParameter ? ":include ReturnValue Parameter" : "");

            SqlParameter[] cachedParameters;

            cachedParameters = paramCache[hashKey] as SqlParameter[];
            if (cachedParameters == null)
            {
                SqlParameter[] spParameters = DiscoverSpParameterSet(connection, spName, includeReturnValueParameter);
                paramCache[hashKey] = spParameters;
                cachedParameters = spParameters;
            }

            return CloneParameters(cachedParameters);
        }

        #endregion Parameter Discovery Functions



        //Class end
    }

}
