﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;
using BLL;
using Utils;
//本页是测试
namespace UI.CrmCustSale
{
    public partial class QuotationAdd : System.Web.UI.Page
    {
        CodeConfigBiz codeConfigBiz = new CodeConfigBiz();
        string code = "";
        IBizSQL bizSQL = new BizSQL();
        DefDicBiz defDicBiz = new DefDicBiz();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Request.QueryString["QuotationCode"] != null)
                code = Request.QueryString["QuotationCode"].Trim();
            if (code.Length > 2)
            {
                lbTitle.Text = "修改单据";
                btnAdd.Visible = false;
            }
            else
            {
                btnMod.Visible = false;
            }
            if (!Page.IsPostBack)
            {
                if (string.IsNullOrWhiteSpace(code))
                {
                    FirstGridViewRow(CreateTable());
                    defDicBiz.InitDropDownList("Cust_PayWay", ddlPayWay, "");
                    defDicBiz.InitDropDownList("Cust_SendWay", ddlSendWay, "");
                    defDicBiz.InitDropDownList("Cust_ShipCondition", ddlShipCondition, "");                  
                    defDicBiz.InitDropDownList("Cust_Tax", ddlTaxNum, "", "Name,TaxNum");
                    string strYMD = System.DateTime.Now.ToString("yyyy-MM-dd");
                    txtQuotationTime.Text = strYMD;
                    txtReferProductsTime.Text = strYMD;
                    txtPriPayTime.Text = strYMD;
                    txtPayTime.Text = strYMD;
                    txtQuotationCode.Text = codeConfigBiz.CreateCode("报价单单据编号", "Cust_QuotationList");
                }
                else
                {
                    BondQuotationInfo(code);
                    string sql = "SELECT RowNumber,ProductCode, ProductType,Name,Spec, cast(Num as varchar(7)) Num, cast(Price as varchar(14)) Price,Unit,SubTotal, Profile FROM Cust_QuotationDetail  WHERE QuotationCode= '" + code + "'";
                    DataTable dt = bizSQL.ExecSQL2(sql).Tables[0];
                    FirstGridViewRow(dt);
                }
            }
        }

        protected void btnAdd_Click(object sender, EventArgs e)
        {
            SetRowData();
            DataTable table = ViewState["CurrentTable"] as DataTable;
            string quotationCode = codeConfigBiz.CreateCode("报价单单据编号", "Cust_QuotationList");
            if (table != null)
            {
                List<SortedDictionary<string, string>> detailList = new List<SortedDictionary<string, string>>();
                foreach (DataRow row in table.Rows)
                {
                    SortedDictionary<string, string> item = new SortedDictionary<string, string>();                    
                     item.Add("QuotationCode",quotationCode);
                     item.Add("RowNumber",row.ItemArray[0] as string);
                     item.Add("ProductCode",row.ItemArray[1] as string);
                     item.Add("ProductType",row.ItemArray[2] as string);

                     item.Add("Name",row.ItemArray[3] as string);
                     item.Add("Spec",row.ItemArray[4] as string);
                     item.Add("Num",row.ItemArray[5] as string);
                     item.Add("Price",row.ItemArray[6] as string);
                     item.Add("Unit",row.ItemArray[7] as string);
                     item.Add("SubTotal", row.ItemArray[8] as string);
                     item.Add("Profile", row.ItemArray[9] as string);
            
                    detailList.Add(item);                  

                }

                SortedDictionary<string, string> mainList = GetMainList(quotationCode);

                string result = bizSQL.InsertMainAndDetail("Cust_QuotationList", mainList, "Cust_QuotationDetail", detailList);
               // JSUtility.ShowAndRedirect(this, result, "QuotationList.aspx");
                JSUtility.Alert(result);



            }
        }

        private SortedDictionary<string, string> GetMainList(string sheetCode)
        {
            //#############获取主表数据####################################################
            string customerID = hidCompanyID.Value;
           
            string QuotationTime = txtQuotationTime.Text;
            string linkMan = txtLinkMan.Text;
            string referProductsTime = txtReferProductsTime.Text;

            string priPayMoney = txtPriPayMoney.Text;
            string validLimit = txtValidLimit.Text.Trim();//有效期限           

            string priPayTime = txtPriPayTime.Text;
            string payWayID = ddlPayWay.SelectedValue.ToString();
            string payTime = txtPayTime.Text;
            string sendWayID = ddlSendWay.SelectedValue.ToString();

            string freight = txtFreight.Text.Trim();            

            string taxNum = ddlTaxNum.SelectedValue.ToString();
            string shippingConditionID = ddlShipCondition.SelectedValue.ToString();
            string state = "N";
            string profile = txtProfile.Text;

           
            SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
          
            if (code.Length < 2)
               sdList.Add("QuotationCode", sheetCode);
          //  sdList.Add("Account", account, "S" });//N是整数 D是decimal
            sdList.Add("CustomerID", customerID);
            sdList.Add("LinkMan", linkMan);
            sdList.Add("QuotationTime", QuotationTime);

            sdList.Add("PriPayMoney", priPayMoney);
            sdList.Add("Freight", freight);
            sdList.Add("PayTime", payTime);
            sdList.Add("PriPayTime", priPayTime);

            sdList.Add("ReferProductsTime", referProductsTime);
            sdList.Add("PayWayID", payWayID);
            sdList.Add("TaxNum", taxNum);
            sdList.Add("SendWayID", sendWayID);


            sdList.Add("ValidLimit", validLimit);
            sdList.Add("ShipConditionID", shippingConditionID);
            sdList.Add("Statu", state);
            sdList.Add("Profile", profile);

            return sdList;

        }
        protected void btnMod_Click(object sender, EventArgs e)
        {
            if (!string.IsNullOrWhiteSpace(code))
            {

                SetRowData();
                //string strHead, string strTable, int setBit,string dateType
                DataTable table = ViewState["CurrentTable"] as DataTable;
                string quotationCode = code;
                if (table != null)
                {
                    List<SortedDictionary<string, string>> detailList = new List<SortedDictionary<string, string>>();
                    foreach (DataRow row in table.Rows)
                    {
                        SortedDictionary<string, string> item = new SortedDictionary<string, string>();
                        item.Add("QuotationCode", quotationCode);
                        item.Add("RowNumber", row.ItemArray[0] as string);
                        item.Add("ProductCode", row.ItemArray[1] as string);
                        item.Add("ProductType", row.ItemArray[2] as string);

                        item.Add("Name", row.ItemArray[3] as string);
                        item.Add("Spec", row.ItemArray[4] as string);
                        item.Add("Num", row.ItemArray[5] as string);
                        item.Add("Price", row.ItemArray[6] as string);
                        item.Add("Unit", row.ItemArray[7] as string);
                        item.Add("SubTotal", row.ItemArray[8] as string);
                        item.Add("Profile", row.ItemArray[9] as string);
                        
                        detailList.Add(item);



                    }

                    SortedDictionary<string, string> mainList = GetMainList(quotationCode);
                    string[] primaryKey = new string[] { "QuotationCode", quotationCode, "S" };
                    string result = bizSQL.UpdateMainAndDetail("Cust_QuotationList", mainList, primaryKey, "Cust_QuotationDetail", detailList);
                    // JSUtility.ShowAndRedirect(this, result, "QuotationList.aspx");
                    JSUtility.Alert(result);

                }
            }
        }
        protected void BondQuotationInfo(string code)
        {
            string strShowSQL = "SELECT * FROM Cust_QuotationList WHERE  QuotationCode = '" + code + "'";
            DataTable dt = bizSQL.ExecSQL2(strShowSQL).Tables[0];
            
 
                    txtQuotationCode.Text = code;
                    txtQuotationTime.Text = Convert.ToDateTime(dt.Rows[0]["QuotationTime"].ToString()).ToString("yyyy-MM-dd");
                    hidCompanyID.Value = dt.Rows[0]["CustomerID"].ToString();

                    txtReferProductsTime.Text = Convert.ToDateTime(dt.Rows[0]["ReferProductsTime"].ToString()).ToString("yyyy-MM-dd");
                    txtPriPayMoney.Text = dt.Rows[0]["PriPayMoney"].ToString();
                    txtPriPayTime.Text = Convert.ToDateTime(dt.Rows[0]["PriPayTime"].ToString()).ToString("yyyy-MM-dd");
                    txtPayTime.Text = Convert.ToDateTime(dt.Rows[0]["PayTime"].ToString()).ToString("yyyy-MM-dd");

                    txtFreight.Text = dt.Rows[0]["Freight"].ToString();
                    txtProfile.Text = dt.Rows[0]["Profile"].ToString();
                    txtValidLimit.Text = dt.Rows[0]["ValidLimit"].ToString();//有效期限     

                    txtLinkMan.Text = dt.Rows[0]["LinkMan"].ToString();


                    defDicBiz.InitDropDownList("Cust_PayWay", ddlPayWay, dt.Rows[0]["PayWayID"].ToString());
                    defDicBiz.InitDropDownList("Cust_SendWay", ddlSendWay, dt.Rows[0]["SendWayID"].ToString());
                    defDicBiz.InitDropDownList("Cust_ShipCondition", ddlShipCondition, dt.Rows[0]["ShipConditionID"].ToString());
                    defDicBiz.InitDropDownList("Cust_Tax", ddlTaxNum, dt.Rows[0]["TaxNum"].ToString(), "Name,TaxNum");
        
        }
   



        private DataTable CreateTable()
        {
            DataTable dt = new DataTable();  
            dt.Columns.Add(new DataColumn("RowNumber", typeof(string)));
            dt.Columns.Add(new DataColumn("ProductCode", typeof(string)));
            dt.Columns.Add(new DataColumn("ProductType", typeof(string)));
            dt.Columns.Add(new DataColumn("Name", typeof(string)));
            dt.Columns.Add(new DataColumn("Spec", typeof(string)));
            dt.Columns.Add(new DataColumn("Price", typeof(string)));
            dt.Columns.Add(new DataColumn("Num", typeof(string)));
            dt.Columns.Add(new DataColumn("Unit", typeof(string)));
            dt.Columns.Add(new DataColumn("SubTotal", typeof(string)));
            dt.Columns.Add(new DataColumn("Profile", typeof(string)));
            DataRow dr = dt.NewRow();
            dr["RowNumber"] = 1;
            dr["ProductCode"] = string.Empty;
            dr["ProductType"] = string.Empty;
            dr["Name"] = string.Empty;
            dr["Spec"] = string.Empty;
            dr["Price"] = string.Empty;
            dr["Num"] = string.Empty;
            dr["Unit"] = string.Empty;
            dr["SubTotal"] = string.Empty;
            dr["Profile"] = string.Empty;
            dt.Rows.Add(dr);
            return dt;

           
        }
        private void FirstGridViewRow(DataTable dt)
        {           

            ViewState["CurrentTable"] = dt;


            gvDetail.DataSource = dt;
            gvDetail.DataBind();
              if (!string.IsNullOrWhiteSpace(code))
                 SetPreviousData();

            TextBox txn = (TextBox)gvDetail.Rows[0].Cells[1].FindControl("txtProductCode");
            txn.Focus();
            Button btnAdd = (Button)gvDetail.FooterRow.Cells[1].FindControl("ButtonAdd");
            Page.Form.DefaultFocus = btnAdd.ClientID;

        }
        protected void ButtonAdd_Click(object sender, EventArgs e)
        {
            AddNewRow();
        }
        private void AddNewRow()
        {
            int rowIndex = 0;

            if (ViewState["CurrentTable"] != null)
            {
                DataTable dtCurrentTable = (DataTable)ViewState["CurrentTable"];
                DataRow drCurrentRow = null;
                if (dtCurrentTable.Rows.Count > 0)
                {
                    for (int i = 1; i <= dtCurrentTable.Rows.Count; i++)
                    {
                        TextBox txtProductCode = (TextBox)gvDetail.Rows[rowIndex].Cells[1].FindControl("txtProductCode");
                        TextBox txtProductType = (TextBox)gvDetail.Rows[rowIndex].Cells[2].FindControl("txtProductType");
                        TextBox txtName = (TextBox)gvDetail.Rows[rowIndex].Cells[3].FindControl("txtName");
                        TextBox txtSpec = (TextBox)gvDetail.Rows[rowIndex].Cells[4].FindControl("txtSpec");

                        TextBox txtPrice = (TextBox)gvDetail.Rows[rowIndex].Cells[5].FindControl("txtPrice");
                        TextBox txtNum = (TextBox)gvDetail.Rows[rowIndex].Cells[6].FindControl("txtNum");
                        TextBox txtUnit = (TextBox)gvDetail.Rows[rowIndex].Cells[7].FindControl("txtUnit");
                        TextBox txtSubTotal = (TextBox)gvDetail.Rows[rowIndex].Cells[7].FindControl("txtSubTotal");
                        TextBox txtProfile = (TextBox)gvDetail.Rows[rowIndex].Cells[8].FindControl("txtProfile");

                        //  RadioButtonList RBLGender = (RadioButtonList)gvDetail.Rows[rowIndex].Cells[4].FindControl("RBLGender");
                        // DropDownList DrpQualification = (DropDownList)gvDetail.Rows[rowIndex].Cells[5].FindControl("drpQualification");


                        dtCurrentTable.Rows[i - 1]["ProductCode"] = txtProductCode.Text;
                        dtCurrentTable.Rows[i - 1]["ProductType"] = txtProductType.Text;
                        dtCurrentTable.Rows[i - 1]["Name"] = txtName.Text;
                        dtCurrentTable.Rows[i - 1]["Spec"] = txtSpec.Text;
                        dtCurrentTable.Rows[i - 1]["Price"] = txtPrice.Text;
                        dtCurrentTable.Rows[i - 1]["Num"] = txtNum.Text;
                        dtCurrentTable.Rows[i - 1]["Unit"] = txtUnit.Text;
                        dtCurrentTable.Rows[i - 1]["SubTotal"] = txtSubTotal.Text;
                        dtCurrentTable.Rows[i - 1]["Profile"] = txtProfile.Text;
                        rowIndex++;
                    }
                    drCurrentRow = dtCurrentTable.NewRow();
                    drCurrentRow["RowNumber"] = rowIndex + 1;
                    dtCurrentTable.Rows.Add(drCurrentRow);
                    ViewState["CurrentTable"] = dtCurrentTable;

                    gvDetail.DataSource = dtCurrentTable;
                    gvDetail.DataBind();

                    TextBox txn = (TextBox)gvDetail.Rows[rowIndex].Cells[1].FindControl("txtProductCode");
                    txn.Focus();
                  }
            }
            else
            {
                Response.Write("ViewState is null");
            }
            SetPreviousData();
        }
        private void SetPreviousData()
        {
            int rowIndex = 0;
            if (ViewState["CurrentTable"] != null)
            {
                DataTable dt = (DataTable)ViewState["CurrentTable"];
                if (dt.Rows.Count > 0)
                {
                    for (int i = 0; i < dt.Rows.Count; i++)
                    {
                        TextBox txtProductCode = (TextBox)gvDetail.Rows[rowIndex].Cells[1].FindControl("txtProductCode");
                        TextBox txtProductType = (TextBox)gvDetail.Rows[rowIndex].Cells[2].FindControl("txtProductType");
                        TextBox txtName = (TextBox)gvDetail.Rows[rowIndex].Cells[3].FindControl("txtName");
                        TextBox txtSpec = (TextBox)gvDetail.Rows[rowIndex].Cells[4].FindControl("txtSpec");

                        TextBox txtPrice = (TextBox)gvDetail.Rows[rowIndex].Cells[5].FindControl("txtPrice");
                        TextBox txtNum = (TextBox)gvDetail.Rows[rowIndex].Cells[6].FindControl("txtNum");
                        TextBox txtUnit = (TextBox)gvDetail.Rows[rowIndex].Cells[7].FindControl("txtUnit");
                        TextBox txtSubTotal = (TextBox)gvDetail.Rows[rowIndex].Cells[8].FindControl("txtSubTotal");
                        TextBox txtProfile = (TextBox)gvDetail.Rows[rowIndex].Cells[8].FindControl("txtProfile");

                        gvDetail.Rows[i].Cells[0].Text = Convert.ToString(i + 1);
                        txtProductCode.Text = dt.Rows[i]["ProductCode"].ToString();
                        txtProductType.Text = dt.Rows[i]["ProductType"].ToString();
                        txtName.Text = dt.Rows[i]["Name"].ToString();
                        txtSpec.Text = dt.Rows[i]["Spec"].ToString();
                        txtPrice.Text = dt.Rows[i]["Price"].ToString();
                        txtNum.Text = dt.Rows[i]["Num"].ToString();
                        txtUnit.Text = dt.Rows[i]["Unit"].ToString();
                        txtSubTotal.Text = dt.Rows[i]["SubTotal"].ToString();
                        txtProfile.Text = dt.Rows[i]["Profile"].ToString();

                        rowIndex++;
                    }
                }
            }
        }
        protected void gvDetail_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            SetRowData();
            if (ViewState["CurrentTable"] != null)
            {
                DataTable dt = (DataTable)ViewState["CurrentTable"];
                DataRow drCurrentRow = null;
                int rowIndex = Convert.ToInt32(e.RowIndex);
                if (dt.Rows.Count > 1)
                {
                    dt.Rows.Remove(dt.Rows[rowIndex]);
                    drCurrentRow = dt.NewRow();
                    ViewState["CurrentTable"] = dt;
                    gvDetail.DataSource = dt;
                    gvDetail.DataBind();

                    for (int i = 0; i < gvDetail.Rows.Count - 1; i++)
                    {
                        gvDetail.Rows[i].Cells[0].Text = Convert.ToString(i + 1);
                    }
                    SetPreviousData();
                }
            }
        }
        private void SetRowData()
        {
            int rowIndex = 0;

            if (ViewState["CurrentTable"] != null)
            {
                DataTable dtCurrentTable = (DataTable)ViewState["CurrentTable"];
                DataRow drCurrentRow = null;
                if (dtCurrentTable.Rows.Count > 0)
                {
                    for (int i = 1; i <= dtCurrentTable.Rows.Count; i++)
                    {
                        TextBox txtProductCode = (TextBox)gvDetail.Rows[rowIndex].Cells[1].FindControl("txtProductCode");
                        TextBox txtProductType = (TextBox)gvDetail.Rows[rowIndex].Cells[2].FindControl("txtProductType");
                        TextBox txtName = (TextBox)gvDetail.Rows[rowIndex].Cells[3].FindControl("txtName");
                        TextBox txtSpec = (TextBox)gvDetail.Rows[rowIndex].Cells[4].FindControl("txtSpec");

                        TextBox txtPrice = (TextBox)gvDetail.Rows[rowIndex].Cells[5].FindControl("txtPrice");
                        TextBox txtNum = (TextBox)gvDetail.Rows[rowIndex].Cells[6].FindControl("txtNum");
                        TextBox txtUnit = (TextBox)gvDetail.Rows[rowIndex].Cells[7].FindControl("txtUnit");
                        TextBox txtSubTotal = (TextBox)gvDetail.Rows[rowIndex].Cells[7].FindControl("txtSubTotal");
                        TextBox txtProfile = (TextBox)gvDetail.Rows[rowIndex].Cells[8].FindControl("txtProfile");

                        dtCurrentTable.Rows[i - 1]["ProductCode"] = txtProductCode.Text;
                        dtCurrentTable.Rows[i - 1]["ProductType"] = txtProductType.Text;
                        dtCurrentTable.Rows[i - 1]["Name"] = txtName.Text;
                        dtCurrentTable.Rows[i - 1]["Spec"] = txtSpec.Text;
                        dtCurrentTable.Rows[i - 1]["Price"] = txtPrice.Text;
                        dtCurrentTable.Rows[i - 1]["Num"] = txtNum.Text;
                        dtCurrentTable.Rows[i - 1]["Unit"] = txtUnit.Text;
                        dtCurrentTable.Rows[i - 1]["SubTotal"] = txtSubTotal.Text;
                        dtCurrentTable.Rows[i - 1]["Profile"] = txtProfile.Text;
                        rowIndex++;
                    }
                    drCurrentRow = dtCurrentTable.NewRow();
                    drCurrentRow["RowNumber"] = rowIndex + 1;
                    ViewState["CurrentTable"] = dtCurrentTable;
                    //gvDetail.DataSource = dtCurrentTable;
                    //gvDetail.DataBind();
                }
            }
            else
            {
                Response.Write("ViewState is null");
            }
            //SetPreviousData();
        }

        protected void txtProductCode_TextChanged(object sender, EventArgs e)
        {

            DataTable dt = (DataTable)ViewState["CurrentTable"];

            TextBox txtBox = sender as TextBox;
            int rowNum = (txtBox.NamingContainer as GridViewRow).RowIndex;

            for (int i = 0; i <= dt.Rows.Count; i++)
            {

                if (rowNum == i)
                {
                    TextBox txtProductCode = (TextBox)gvDetail.Rows[i].Cells[1].FindControl("txtProductCode");
                    string productCode = txtProductCode.Text.Trim();
                    if (string.IsNullOrWhiteSpace(productCode)) return;

                    TextBox txtProductType = (TextBox)gvDetail.Rows[i].Cells[2].FindControl("txtProductType");
                    TextBox txtName = (TextBox)gvDetail.Rows[i].Cells[3].FindControl("txtName");
                    TextBox txtSpec = (TextBox)gvDetail.Rows[i].Cells[4].FindControl("txtSpec");

                    TextBox txtPrice = (TextBox)gvDetail.Rows[i].Cells[5].FindControl("txtPrice");
                    //TextBox txtNum = (TextBox)gvDetail.Rows[i].Cells[6].FindControl("txtNum");
                    TextBox txtUnit = (TextBox)gvDetail.Rows[i].Cells[7].FindControl("txtUnit");
                    //TextBox txtProfile = (TextBox)gvDetail.Rows[i].Cells[8].FindControl("txtProfile");
                    // RadioButtonList RBLGender = (RadioButtonList)gvDetail.Rows[i].Cells[4].FindControl("RBLGender");
                    // DropDownList DrpQualification = (DropDownList)gvDetail.Rows[i].Cells[5].FindControl("drpQualification");


                    DataTable prodt = bizSQL.ExecSQL2("select * from Cust_Products where ProductCode='" + productCode + "'").Tables[0];
                    if (prodt == null) return;
                    if (prodt.Rows.Count < 1) return;
                    txtProductType.Text = prodt.Rows[0]["ProductType"].ToString();
                    txtName.Text = prodt.Rows[0]["Name"].ToString();
                    txtSpec.Text = prodt.Rows[0]["Spec"].ToString();
                    txtPrice.Text = prodt.Rows[0]["Price1"].ToString();
                    txtUnit.Text = prodt.Rows[0]["Unit"].ToString();
                    break;
                }

            }

        }

        protected void txtNum_TextChanged(object sender, EventArgs e)
        {

            DataTable dt = (DataTable)ViewState["CurrentTable"];
            TextBox txtBox = sender as TextBox;
            int rowNum = (txtBox.NamingContainer as GridViewRow).RowIndex;

            for (int i = 0; i <= dt.Rows.Count; i++)
            {

                if (rowNum == i)
                {
                    TextBox txtSubTotal = (TextBox)gvDetail.Rows[i].Cells[8].FindControl("txtSubTotal");
                    TextBox txtPrice = (TextBox)gvDetail.Rows[i].Cells[5].FindControl("txtPrice");                    
                    TextBox txtNum = (TextBox)gvDetail.Rows[i].Cells[6].FindControl("txtNum");
                    string num = txtNum.Text.Trim();
                    string price = txtPrice.Text.Trim();
                    if (string.IsNullOrWhiteSpace(num) || string.IsNullOrWhiteSpace(price)) return;
                    txtSubTotal.Text = (float.Parse(price)*Int32.Parse(num)).ToString();
                    break;
                }

            }

        }
    }
}