﻿using System;
using System.Collections.Generic;
using System.Data;
using BLL;
using Utils;
namespace UI.CrmCustomer
{
    public partial class CustomerAdd : System.Web.UI.Page
    {
        CustomerBiz customerBiz = new CustomerBiz();
        DefDicBiz defDicBiz = new DefDicBiz();
        string customerID = "";
        string account = "";
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["user"] != null)
            {
                User user = Session["user"] as User;
                account = user.Account;
            }
            else
            {
                JSUtility.Alert(this, "您没有登录!请先登录。");
                return;
            }

            if (Request.QueryString["CustomerID"] != null)
            {
                customerID = Request.QueryString["CustomerID"].ToString();
            }
            if (!IsPostBack)
            {
                txtInputAccount.Text = account;
                defDicBiz.InitDropDownList(new EmployeeBiz().GetLists("sale"), ddlAccount,account);//负责业务员
                defDicBiz.InitDropDownList("Cust_Type", ddlTypeID, "0");
                defDicBiz.InitDropDownList("Cust_Category", ddlCategoryID, "0");
                defDicBiz.InitDropDownList("Cust_FromTo", ddlFromToID, "展会");
                defDicBiz.InitDropDownList("Cust_Statu", ddlStatu, "拓展中");

                XmlDicBiz.InitCustGade(ddlGade, "无");
                XmlDicBiz.InitProvince(ddlProvince,  "无");
                XmlDicBiz.InitCustOrganize(ddlOrganize, "无");
                if (customerID != "")
                {
                    BindData(customerID);
                    btnAdd.Enabled = false;
                    JSUtility.AddConfirm(btnModi, "确实要修改吗？");
                    JSUtility.AddConfirm(btnDel, "您真的要删除客户信息吗？");
                }
                else
                {
                    btnDel.Enabled = false;
                    btnModi.Enabled = false;
                }

            }
        }
        private void BindData(string customerID)
        {
            DataTable dt = customerBiz.GetOneInfo(customerID);
            if (dt.Rows.Count > 0)
            {
                hidCustomerID.Value = customerID;
                txtAddr.Text = dt.Rows[0]["Addr"].ToString();
                txtAddrCode.Text = dt.Rows[0]["AddrCode"].ToString();
                txtCity.Text = dt.Rows[0]["City"].ToString();
                txtCode.Text = dt.Rows[0]["SimpleName"].ToString();
                txtCountry.Text = dt.Rows[0]["Country"].ToString();
                txtEmail.Text = dt.Rows[0]["Email"].ToString();
               
                txtFields.Text = dt.Rows[0]["Fields"].ToString();
                txtLinkMan.Text = dt.Rows[0]["LinkMan"].ToString();
                txtMobile.Text = dt.Rows[0]["Mobile"].ToString();
                txtCustName.Text = dt.Rows[0]["CustName"].ToString();

                string tel = dt.Rows[0]["Tel"].ToString();
                if (tel.Contains("-"))
                {
                    string[] arr = tel.Split('-');
                    txtTelHeader.Text = arr[0];
                    txtTel.Text = arr[1];// dt.Rows[0]["Tel"].ToString();                
                }
                else
                {
                    txtTelHeader.Text = " ";
                    txtTel.Text = tel;
                }
                string fax = dt.Rows[0]["Fax"].ToString();
                if (fax.Contains("-"))
                {
                    string[] arr = fax.Split('-');
                    txtFaxHeader.Text = arr[0];
                    txtFax.Text = arr[1];// dt.Rows[0]["Tel"].ToString();                
                }
                else
                {
                    txtFaxHeader.Text = "";
                    txtFax.Text = "";
                }               

                txtWebUrl.Text = dt.Rows[0]["WebUrl"].ToString();
                txtProfile.Text = dt.Rows[0]["Profile"].ToString();

                txtEmployeeNum.Text = dt.Rows[0]["EmployeeNum"].ToString();
                txtPapers.Text = dt.Rows[0]["Papers"].ToString();
                txtNowNum.Text = dt.Rows[0]["NowNum"].ToString();

                defDicBiz.InitDropDownList(ddlAccount, dt.Rows[0]["Account"].ToString());
                defDicBiz.InitDropDownList(ddlTypeID, dt.Rows[0]["TypeID"].ToString());
                defDicBiz.InitDropDownList(ddlCategoryID, dt.Rows[0]["CategoryID"].ToString());
                defDicBiz.InitDropDownList(ddlFromToID, dt.Rows[0]["FromToID"].ToString());
                defDicBiz.InitDropDownList(ddlStatu, dt.Rows[0]["StatuID"].ToString());


                defDicBiz.InitDropDownList(ddlProvince, dt.Rows[0]["Province"].ToString());
                defDicBiz.InitDropDownList(ddlOrganize, dt.Rows[0]["Organize"].ToString());

                defDicBiz.InitDropDownList(ddlGade, dt.Rows[0]["Gade"].ToString());
                lbCustCodeTitle.Visible = true;
                lbCustCode.Visible = true;
                pnMemo.Visible = true;
                lbCustCode.Text = dt.Rows[0]["CustomerCode"].ToString();
                lbAccount.Text = dt.Rows[0]["Account"].ToString();
                lbCTime.Text = dt.Rows[0]["LastContactTime"].ToString();
                lbInputTime.Text = dt.Rows[0]["InputTime"].ToString();
                lbIsLogin.Text = dt.Rows[0]["IsLogin"].ToString();
                lbQTime.Text = dt.Rows[0]["LastQuotationTime"].ToString();
                lbMemo.Text = dt.Rows[0]["Memo"].ToString();
                lbModifyTime.Text = dt.Rows[0]["ModifyTime"].ToString();
                lbModifyUser.Text = dt.Rows[0]["ModifyUser"].ToString();
                lbOTime.Text = dt.Rows[0]["LastOrderTime"].ToString();
            }

        }
        protected void btnAdd_Click(object sender, EventArgs e)
        {
           
            try
            {
                SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
                //获取数据
                sdList.Add("SimpleName", txtCode.Text.Trim());
                sdList.Add("CustName", txtCustName.Text.Trim());
                sdList.Add("Addr", txtAddr.Text.Trim());
                sdList.Add("AddrCode", txtAddrCode.Text.Trim());
                sdList.Add("City", txtCity.Text.Trim());
                sdList.Add("Country", txtCountry.Text.Trim());
                sdList.Add("Email", txtEmail.Text.Trim());

                string strTelHeader = txtTelHeader.Text.Trim();
                string strFaxHeader = txtFaxHeader.Text.Trim();
                if (strFaxHeader == "") strFaxHeader = strTelHeader;
                sdList.Add("Tel", strTelHeader + "-" + txtTel.Text.Trim());

                if (!string.IsNullOrWhiteSpace(txtFax.Text.Trim()))
                    sdList.Add("Fax", strFaxHeader + "-" + txtFax.Text.Trim());

                sdList.Add("Fields", txtFields.Text.Trim());
                sdList.Add("LinkMan", txtLinkMan.Text.Trim());
                sdList.Add("Mobile", txtMobile.Text.Trim());



                sdList.Add("WebUrl", txtWebUrl.Text.Trim());
                sdList.Add("CategoryID", ddlCategoryID.SelectedValue.ToString());
                sdList.Add("Gade", ddlGade.SelectedValue.ToString());
                sdList.Add("Organize", ddlOrganize.SelectedValue.ToString());

                string strProvince = ddlProvince.SelectedValue.ToString();
                sdList.Add("Province", strProvince);
                sdList.Add("TypeID", ddlTypeID.SelectedValue.ToString());
                sdList.Add("Profile", txtProfile.Text.Trim());

                sdList.Add("Papers", txtPapers.Text.Trim());//营业执照号码，可以不填写
                sdList.Add("EmployeeNum", txtEmployeeNum.Text.Trim());//员工人数,默认为０　不能填写字符，判断在前台进行
                sdList.Add("FromToID", ddlFromToID.SelectedValue.ToString());//来源ＩＤ
                sdList.Add("NowNum", txtNowNum.Text.Trim());//月消耗量

                sdList.Add("StatuID", ddlStatu.SelectedValue.ToString());
                //**需要检测以上数据的有效性

                //***判断该客户是否存在
                if (customerBiz.IsExist(txtCode.Text.Trim(), txtCustName.Text.Trim(), txtMobile.Text.Trim(), strTelHeader + "-" + txtTel.Text.Trim()))
                {
                    JSUtility.Alert(this, "该客户名称，简称，联系手机或联系电话已经存在！");
                    return;
                }
                //合成客户编号
                sdList.Add("CustomerCode", CodeConvert.GetFlowCode(strProvince, strTelHeader, txtCode.Text.Trim()));
               
                //***如果存在,可以向部门经理申请该客户为自己的客户            

                sdList.Add("Account", ddlAccount.SelectedValue == "" ? account : ddlAccount.SelectedValue);
                sdList.Add("InputAccount", txtInputAccount.Text);
                string msg = customerBiz.Insert(sdList);
                if (msg != "插入成功")
                    JSUtility.Alert(msg);
                else
                    JSUtility.AlertAndRedirect(msg, "CustomerAdd.aspx?CustomerID=" + customerID);               
            }
            catch (Exception ex)
            {
                Response.Write("错误1，错误原因：" + ex.Message);
                Response.End();
            }
        }
        protected void btnModi_Click(object sender, EventArgs e)
        {
           
            try
            {
                string comID = hidCustomerID.Value;
                if (string.IsNullOrEmpty(comID))
                {
                      JSUtility.Alert(this, "您没有更新的权限！");
                    return;
                }
                SortedDictionary<string, string> sdList = new SortedDictionary<string, string>();
                
                //获取数据
                sdList.Add("CustomerID", comID);
                sdList.Add("SimpleName", txtCode.Text.Trim());
                sdList.Add("CustName", txtCustName.Text.Trim());
                sdList.Add("Addr", txtAddr.Text.Trim());
                sdList.Add("AddrCode", txtAddrCode.Text.Trim());
                sdList.Add("City", txtCity.Text.Trim());
                sdList.Add("Country", txtCountry.Text.Trim());
                sdList.Add("Email", txtEmail.Text.Trim());

                string strTelHeader = txtTelHeader.Text.Trim();
                string strFaxHeader = txtFaxHeader.Text.Trim();
                if (strFaxHeader == "") strFaxHeader = strTelHeader;
                sdList.Add("Tel", strTelHeader + "-" + txtTel.Text.Trim());

                if (!string.IsNullOrWhiteSpace(txtFax.Text.Trim()))
                sdList.Add("Fax", strFaxHeader + "-" + txtFax.Text.Trim());

                sdList.Add("Fields", txtFields.Text.Trim());
                sdList.Add("LinkMan", txtLinkMan.Text.Trim());
                sdList.Add("Mobile", txtMobile.Text.Trim());



                sdList.Add("WebUrl", txtWebUrl.Text.Trim());
                sdList.Add("CategoryID", ddlCategoryID.SelectedValue.ToString());
                sdList.Add("Gade", ddlGade.SelectedValue.ToString());
                sdList.Add("Organize", ddlOrganize.SelectedValue.ToString());

                string strProvince = ddlProvince.SelectedValue.ToString();
                sdList.Add("Province", strProvince);
                sdList.Add("TypeID", ddlTypeID.SelectedValue.ToString());
                sdList.Add("Profile", txtProfile.Text.Trim());

                sdList.Add("Papers", txtPapers.Text.Trim());//营业执照号码，可以不填写
                sdList.Add("EmployeeNum", txtEmployeeNum.Text.Trim());//员工人数,默认为０　不能填写字符，判断在前台进行
                sdList.Add("FromToID", ddlFromToID.SelectedValue.ToString());//来源ＩＤ
                sdList.Add("NowNum", txtNowNum.Text.Trim());//月消耗量

                sdList.Add("StatuID", ddlStatu.SelectedValue.ToString());
                //**需要检测以上数据的有效性

                //合成客户编号
                sdList.Add("CustomerCode", CodeConvert.GetFlowCode(strProvince, strTelHeader, txtCode.Text.Trim()));
                //***需要判断该客户是否存在
                //***如果存在,可以向部门经理申请该客户为自己的客户            
                sdList.Add("Account", ddlAccount.SelectedValue == "" ? account : ddlAccount.SelectedValue);
                sdList.Add("InputAccount", txtInputAccount.Text);
                sdList.Add("ModifyUser", account);
                sdList.Add("ModifyTime", System.DateTime.Now.ToString());

                JSUtility.AlertAndRedirect(customerBiz.Update(sdList), "CustomerAdd.aspx?CustomerID=" + customerID);               

               
            }
            catch (Exception ex)
            {
                Response.Write("错误1，错误原因：" + ex.Message);
                Response.End();
            }
        }

        protected void btnDel_Click(object sender, EventArgs e)
        {           
            if (customerID != "0")
            {                
                    JSUtility.Alert(this, customerBiz.Delete(customerID));
                    JSUtility.CloseWindow();               
            }
            else
                JSUtility.Alert(this, "请先选择数据");
        }

        protected void btnMove_Click(object sender, EventArgs e)
        {
            JSUtility.OpenNewWinodw(this, "CustomerMove.aspx?Account=" + lbAccount.Text + "&CustomerID=" + customerID,"640","480",true);
            //Response.Redirect("CustomerMove.aspx?Account=" + lbAccount.Text + "&CustomerID=" + customerID);
        }

        protected void btnRemote_Click(object sender, EventArgs e)
        {
            string comID = hidCustomerID.Value;
            if (string.IsNullOrEmpty(comID))
            {
                JSUtility.Alert(this, "没有客户ID！");
                return;
            }

            string isLogin = lbIsLogin.Text.Trim();
            if (isLogin == "Y") isLogin = "N";
            else if (isLogin == "N") isLogin = "Y";
            if (comID != "0" && !string.IsNullOrWhiteSpace(comID))
            {
                if (customerBiz.IsLogin(comID, isLogin))
                {
                    JSUtility.AlertAndRedirect("操作成功", "CustomerShow.aspx?CustomerID" + comID);
                }
                else
                    JSUtility.Alert(this, "操作失败");
            }
            else
                JSUtility.Alert(this, "请先选择数据");
        }


    }
}