﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="CustomerList.aspx.cs" Inherits="UI.CrmCustomer.CustomerList" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>客户档案管理</title>
    <link rel="stylesheet" type="text/css" href="../Styles/BaseStyle.css" />
    <script type="text/javascript" src="../JS/jsFunction.js"></script>
    <script type="text/javascript" src="../JS/calendar.js"></script>
</head>
<body>
    <form id="form1" runat="server">
    <table class="pagetop">
        <tr>
            <td>
                <div class="pagetopleft">
                    客户档案管理</div>
            </td>
            <td align="right">
             
                   <asp:DropDownList ID="ddlDept" runat="server" CssClass="InputCss">
                    </asp:DropDownList>
                    日期<asp:TextBox ID="txtBtime" runat="server" CssClass="InputCss" Width="69px" MaxLength="10"
                        onclick="setday(this,false)" onkeypress="return validateKey(this,false, getkeyCode(event));"
                        Style="ime-mode: Disabled;"></asp:TextBox>
                    至<asp:TextBox ID="txtEtime" runat="server" CssClass="InputCss" Width="69px" MaxLength="10"
                        onclick="setday(this,false)" onkeypress="return validateKey(this,false, getkeyCode(event));"
                        Style="ime-mode: Disabled;"></asp:TextBox>
                    
                            <asp:DropDownList ID="ddlTime" runat="server"  CssClass="InputCss">
                        <asp:ListItem Selected="True" Value="InputTime">建档时间</asp:ListItem>
                        <asp:ListItem Value="LastContactTime">最近联系时间</asp:ListItem>
                        <asp:ListItem Value="LastQuotationTime">最近报价时间</asp:ListItem>
                        <asp:ListItem Value="LastOrderTime">最后下单时间</asp:ListItem>
                        <asp:ListItem Value="LastServerTime">最后服务时间</asp:ListItem>
                        <asp:ListItem Value="ModifyTime">修改时间</asp:ListItem>
                        <asp:ListItem Value="OutPutTime">流失时间</asp:ListItem>
                        </asp:DropDownList>                  
                   状态 <asp:DropDownList ID="ddlStatuID" runat="server" CssClass="InputCss">
                    </asp:DropDownList> 
                    关键字：<asp:TextBox ID="txtSearchWord" runat="server" MaxLength="20" Width="70px" 
                            CssClass="InputCss"></asp:TextBox>
                   
                    <asp:Button ID="btnEmSearch" runat="server" Width="40px" Text="查询" OnClick="btnEmSearch_Click"
                        CssClass="ButtonCss" />                   
                    <asp:Button ID="btnAdd" runat="server" Text="增加" CssClass="ButtonCss"  />
                     <asp:Button ID="btnOut" runat="server" Width="40px" Text="导出" CssClass="ButtonCss" onclick="btnOut_Click" />  
               
            </td>
        </tr>
    </table>
    <asp:GridView ID="gvList" runat="server" DataKeyNames="CustomerID" 
        Width="1200px" AutoGenerateColumns="False"
        BackColor="White" BorderColor="#E7E7FF" BorderStyle="None" BorderWidth="1px"
        CellPadding="3" GridLines="Horizontal" 
        onrowdatabound="gvList_RowDataBound"    >
        <Columns>
                <asp:BoundField DataField="CustomerID" HeaderText="CustomerID" ReadOnly="True" SortExpression="CustomerID" />
                <asp:BoundField DataField="Account" HeaderText="Account" SortExpression="Account" />
                <asp:TemplateField HeaderText="客户编号" SortExpression="CustomerCode">
                    <ItemTemplate>
                        <a href="javascript:ShowLink('CustomerShow.aspx?CustomerID=<%# Eval("CustomerID") %>&CustName=<%# Eval("CustName") %>',880,550)"><%# Eval("CustomerCode") %></a>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="客户名称" SortExpression="CustName">
                    <ItemTemplate>
                        <a href="javascript:ShowLink('CustomerShow.aspx?CustomerID=<%# Eval("CustomerID") %>&CustName=<%# Eval("CustName") %>',880,550)"><%# Eval("CustName") %></a>
                   </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="City" HeaderText="所在城市" SortExpression="City" />
                <asp:BoundField DataField="Fields" HeaderText="来往业务" SortExpression="Fields" />
                <asp:BoundField DataField="LinkMan" HeaderText="联系人" SortExpression="LinkMan" />
                <asp:BoundField DataField="Tel" HeaderText="电话" SortExpression="Tel" />
                <asp:TemplateField HeaderText="业务员" SortExpression="EmpName">
                    <ItemTemplate>
                        <a href="javascript:ShowLink('../ModAccount/AccountShowDetail.aspx?Account=<%# Eval("Account") %>',880,550)"><%# Eval("EmpName") %></a>
                   </ItemTemplate>
                </asp:TemplateField>
                
                <asp:TemplateField HeaderText="操作">
                <itemtemplate>
                <a href="../ModEvent/EventList.aspx?CustomerID=<%# Eval("CustomerID") %>">事件</a>
                <a href="../ModEvent/OutList.aspx?CustomerID=<%# Eval("CustomerID") %>">拜访</a>
                <a href="LinkManList.aspx?CustomerID=<%# Eval("CustomerID") %>">联系人</a>
                <a href="SendAddrList.aspx?CustomerID=<%# Eval("CustomerID") %>">地址</a>                   
                </itemtemplate>
                    <ItemStyle HorizontalAlign="Center" />
                </asp:TemplateField>
        </Columns>
        <FooterStyle BackColor="#B5C7DE" ForeColor="#4A3C8C" />
        <RowStyle BackColor="#E7E7FF" ForeColor="#4A3C8C" />
        <PagerStyle BackColor="#E7E7FF" ForeColor="#4A3C8C" HorizontalAlign="Right" />
        <HeaderStyle BackColor="#4A3C8C" Font-Bold="True" ForeColor="#F7F7F7" />
        <AlternatingRowStyle BackColor="#F7F7F7" />
    </asp:GridView>
    <div id="divAmount" class="amountLine">
        <asp:Label ID="lbAmount" runat="server"></asp:Label>
    </div>
    </form>
</body>
</html>
