﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using BLL;
using Utils;
namespace UI.CrmCustomer
{
    public partial class CustomerList : System.Web.UI.Page
    {

        string account = "";
        int companyID = 0;
        int departmentID = 0;
        CustomerBiz customerBiz=new CustomerBiz();
        DepartmentBiz departmentBiz= new DepartmentBiz();
        CheckRight checkRight = new CheckRight();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["user"] != null)
            {
                User user = Session["user"] as User;
                account = user.Account;
               companyID= user.CompanyID;
               departmentID = user.DepartemntID;
            }
            else
            {
                JSUtility.Alert(this, "您没有登录!请先登录。");
                return;
            }

            if (!IsPostBack)
            {
                btnAdd.Attributes.Add("onclick", "javascript:ShowLink('CustomerAdd.aspx',850,600);");
                DefDicBiz defDicBiz = new DefDicBiz();
                defDicBiz.InitDropDownList("Cust_Statu", ddlStatuID, "");
                departmentBiz.InitDropDownList(ddlDept, "", account, companyID.ToString(), departmentID.ToString());
               
              }
        }
           

        protected void btnEmSearch_Click(object sender, EventArgs e)
        {
            if (!checkRight.Check("Search", account))
            { lbAmount.Text = "没有查询权限"; }
            else
            {
                string strSearchWord = txtSearchWord.Text.Trim();//输入的查询字符串
                string strStatuID = ddlStatuID.SelectedValue.Trim();//类型：正常、充公、关闭
                string strDept = ddlDept.SelectedValue.Trim(); // 部门
                string strBtime = txtBtime.Text.Trim();
                string strEtime = txtEtime.Text.Trim();
                string timeType = ddlTime.SelectedValue.Trim();

                DataTable dt = customerBiz.GetList(strSearchWord, strStatuID, strDept, strBtime, strEtime, timeType);
                int r = dt.Rows.Count;
                gvList.DataSource = dt;
                gvList.DataBind();
                if (r > 0)
                {
                    lbAmount.Text = "总人数：" + r.ToString();
                }
                else
                    lbAmount.Text = "总人数：0" ;
            }
        }

        protected void btnOut_Click(object sender, EventArgs e)
        {
            if (!checkRight.Check("Export", account))
            {
                JSUtility.Alert("无导出权限");
            }
            else
            {
                string strSearchWord = txtSearchWord.Text.Trim();//输入的查询字符串
                string strStatuID = ddlStatuID.SelectedValue.Trim();//类型：正常、充公、关闭
                string strDept = ddlDept.SelectedValue.Trim(); // 部门
                string strBtime = txtBtime.Text.Trim();
                string strEtime = txtEtime.Text.Trim();
                string timeType = ddlTime.SelectedValue.Trim();

                DataTable dt = customerBiz.GetList(strSearchWord, strStatuID, strDept, strBtime, strEtime, timeType);
                ExcelUtility.ExportDsToXls(this, dt, "CustomerList.xls");
            }
        }

        protected void gvList_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow || e.Row.RowType == DataControlRowType.Header)
            {
                e.Row.Cells[0].Visible = false;
                e.Row.Cells[1].Visible = false;
            }
        }

   

    
       
    }
}